/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.literals.internal;

import com.google.inject.Inject;
import net.enilink.komma.core.ILiteral;
import net.enilink.komma.core.ILiteralFactory;
import net.enilink.komma.core.URI;
import net.enilink.komma.core.URIs;
import net.enilink.komma.literals.IConverter;

public class CharacterConverter
implements IConverter<Character> {
    private static final URI DATATYPE = URIs.createURI((String)("java:" + Character.class.getName()));
    @Inject
    private ILiteralFactory lf;
    private URI datatype = DATATYPE;

    @Override
    public String getJavaClassName() {
        return Character.class.getName();
    }

    @Override
    public URI getDatatype() {
        return this.datatype;
    }

    @Override
    public void setDatatype(URI datatype) {
        this.datatype = datatype;
    }

    @Override
    public Character deserialize(String label) {
        assert (label.length() == 1) : label;
        return Character.valueOf(label.charAt(0));
    }

    @Override
    public ILiteral serialize(Character object) {
        return this.lf.createLiteral(object.toString(), this.datatype, null);
    }
}

