/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.literals.internal;

import com.google.inject.Inject;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import net.enilink.komma.core.ILiteral;
import net.enilink.komma.core.ILiteralFactory;
import net.enilink.komma.core.URI;
import net.enilink.komma.literals.IConverter;
import net.enilink.vocab.xmlschema.XMLSCHEMA;

public class DurationConverter
implements IConverter<Duration> {
    @Inject
    private ILiteralFactory lf;
    private DatatypeFactory factory;
    private Class<? extends Duration> javaClass;
    private URI datatype = XMLSCHEMA.TYPE_DURATION;

    @Inject
    public DurationConverter(DatatypeFactory factory) {
        this.factory = factory;
        this.javaClass = factory.newDuration(0L).getClass();
    }

    @Override
    public String getJavaClassName() {
        return this.javaClass.getName();
    }

    @Override
    public URI getDatatype() {
        return this.datatype;
    }

    @Override
    public void setDatatype(URI datatype) {
        this.datatype = datatype;
    }

    @Override
    public Duration deserialize(String label) {
        return this.factory.newDuration(label);
    }

    @Override
    public ILiteral serialize(Duration object) {
        return this.lf.createLiteral(object.toString(), this.datatype, null);
    }
}

