/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.literals.internal;

import com.google.inject.Inject;
import net.enilink.komma.core.ILiteral;
import net.enilink.komma.core.ILiteralFactory;
import net.enilink.komma.core.URI;
import net.enilink.komma.literals.IConverter;
import net.enilink.vocab.xmlschema.XMLSCHEMA;

public class IntegerConverter
implements IConverter<Integer> {
    @Inject
    private ILiteralFactory lf;

    @Override
    public String getJavaClassName() {
        return Integer.class.getName();
    }

    @Override
    public URI getDatatype() {
        return XMLSCHEMA.TYPE_INT;
    }

    @Override
    public void setDatatype(URI datatype) {
        if (!datatype.equals((Object)this.getDatatype())) {
            throw new IllegalArgumentException(datatype.toString());
        }
    }

    @Override
    public Integer deserialize(String label) {
        return Integer.valueOf(label);
    }

    @Override
    public ILiteral serialize(Integer object) {
        return this.lf.createLiteral(object.toString(), this.getDatatype(), null);
    }
}

