/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.literals.internal;

import com.google.inject.Inject;
import net.enilink.komma.core.ILiteral;
import net.enilink.komma.core.ILiteralFactory;
import net.enilink.komma.core.URI;
import net.enilink.komma.literals.IConverter;
import net.enilink.vocab.xmlschema.XMLSCHEMA;

public class LongConverter
implements IConverter<Long> {
    @Inject
    private ILiteralFactory lf;

    @Override
    public String getJavaClassName() {
        return Long.class.getName();
    }

    @Override
    public URI getDatatype() {
        return XMLSCHEMA.TYPE_LONG;
    }

    @Override
    public void setDatatype(URI datatype) {
        if (!datatype.equals((Object)this.getDatatype())) {
            throw new IllegalArgumentException(datatype.toString());
        }
    }

    @Override
    public Long deserialize(String label) {
        return Long.valueOf(label);
    }

    @Override
    public ILiteral serialize(Long object) {
        return this.lf.createLiteral(object.toString(), this.getDatatype(), null);
    }
}

