/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.literals.internal;

import com.google.inject.Inject;
import java.lang.reflect.Constructor;
import net.enilink.composition.properties.exceptions.ObjectConversionException;
import net.enilink.komma.core.ILiteral;
import net.enilink.komma.core.ILiteralFactory;
import net.enilink.komma.core.URI;
import net.enilink.komma.core.URIs;
import net.enilink.komma.literals.IConverter;

public class ObjectConstructorConverter<T>
implements IConverter<T> {
    @Inject
    private ILiteralFactory lf;
    private Constructor<T> constructor;
    private URI datatype;

    public ObjectConstructorConverter(Class<T> type) throws NoSuchMethodException {
        this.datatype = URIs.createURI((String)("java:" + type.getName()));
        try {
            this.constructor = type.getConstructor(String.class);
        }
        catch (NoSuchMethodException e) {
            try {
                this.constructor = type.getConstructor(CharSequence.class);
            }
            catch (NoSuchMethodException e1) {
                throw e;
            }
        }
    }

    @Override
    public String getJavaClassName() {
        return this.constructor.getDeclaringClass().getName();
    }

    @Override
    public URI getDatatype() {
        return this.datatype;
    }

    @Override
    public void setDatatype(URI datatype) {
        this.datatype = datatype;
    }

    @Override
    public T deserialize(String label) {
        try {
            return this.constructor.newInstance(label);
        }
        catch (Exception e) {
            throw new ObjectConversionException((Throwable)e);
        }
    }

    @Override
    public ILiteral serialize(T object) {
        return this.lf.createLiteral(object.toString(), this.datatype, null);
    }
}

