/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.literals.internal;

import com.google.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import net.enilink.composition.properties.exceptions.ObjectConversionException;
import net.enilink.komma.core.ILiteral;
import net.enilink.komma.core.ILiteralFactory;
import net.enilink.komma.core.URI;
import net.enilink.komma.core.URIs;
import net.enilink.komma.literals.IConverter;

public class ObjectSerializationConverter<T>
implements IConverter<T> {
    private static final String[] pseudo = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
    @Inject
    private ILiteralFactory lf;
    @Inject
    private ClassLoader cl;
    private Class<T> type;
    private URI datatype;

    public ObjectSerializationConverter(Class<T> type) {
        this.type = type;
        this.datatype = URIs.createURI((String)("java:" + type.getName()));
    }

    @Override
    public String getJavaClassName() {
        return this.type.getName();
    }

    @Override
    public URI getDatatype() {
        return this.datatype;
    }

    @Override
    public void setDatatype(URI datatype) {
        this.datatype = datatype;
    }

    @Override
    public T deserialize(String label) {
        try {
            byte[] decoded = this.decode(label);
            ByteArrayInputStream is = new ByteArrayInputStream(decoded);
            ObjectInputStream ois = new ObjectInputStream(is){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    try {
                        return ObjectSerializationConverter.this.cl.loadClass(desc.getName());
                    }
                    catch (ClassNotFoundException e) {
                        return super.resolveClass(desc);
                    }
                }
            };
            Object result = ois.readObject();
            ois.close();
            return this.type.cast(result);
        }
        catch (ObjectConversionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ObjectConversionException((Throwable)e);
        }
    }

    @Override
    public ILiteral serialize(T object) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(object);
            oos.close();
            byte[] byteArray = bos.toByteArray();
            String label = this.encode(byteArray);
            return this.lf.createLiteral(label, this.datatype, null);
        }
        catch (ObjectConversionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ObjectConversionException((Throwable)e);
        }
    }

    private String encode(byte[] in) {
        StringBuilder out = new StringBuilder(in.length * 2);
        for (int i = 0; i < in.length; ++i) {
            byte ch = (byte)(in[i] & 0xF0);
            ch = (byte)(ch >>> 4);
            ch = (byte)(ch & 0xF);
            out.append(pseudo[ch]);
            ch = (byte)(in[i] & 0xF);
            out.append(pseudo[ch]);
        }
        return out.toString();
    }

    private byte[] decode(String str) {
        char[] in = str.toCharArray();
        byte[] out = new byte[in.length / 2];
        if (in.length % 2 == 1) {
            throw new ObjectConversionException("Hex String must be an odd number of characters");
        }
        int j = 0;
        for (int i = 0; i < out.length; ++i) {
            int most = Character.digit(in[j++], 16);
            int least = Character.digit(in[j++], 16);
            int value = most << 4 | least;
            out[i] = (byte)(value & 0xFF);
        }
        return out;
    }
}

