/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.literals.internal;

import com.google.inject.Inject;
import net.enilink.komma.core.ILiteral;
import net.enilink.komma.core.ILiteralFactory;
import net.enilink.komma.core.URI;
import net.enilink.komma.literals.IConverter;
import net.enilink.vocab.xmlschema.XMLSCHEMA;

public class ShortConverter
implements IConverter<Short> {
    @Inject
    private ILiteralFactory lf;

    @Override
    public String getJavaClassName() {
        return Short.class.getName();
    }

    @Override
    public URI getDatatype() {
        return XMLSCHEMA.TYPE_SHORT;
    }

    @Override
    public void setDatatype(URI datatype) {
        if (!datatype.equals((Object)this.getDatatype())) {
            throw new IllegalArgumentException(datatype.toString());
        }
    }

    @Override
    public Short deserialize(String label) {
        return Short.valueOf(label);
    }

    @Override
    public ILiteral serialize(Short object) {
        return this.lf.createLiteral(object.toString(), this.getDatatype(), null);
    }
}

