/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.literals.internal;

import com.google.inject.Inject;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import net.enilink.komma.core.ILiteral;
import net.enilink.komma.core.ILiteralFactory;
import net.enilink.komma.core.URI;
import net.enilink.komma.literals.IConverter;
import net.enilink.vocab.xmlschema.XMLSCHEMA;

public class XMLGregorianCalendarConverter
implements IConverter<XMLGregorianCalendar> {
    @Inject
    private ILiteralFactory lf;
    private DatatypeFactory factory;
    private Class<? extends XMLGregorianCalendar> javaClass;

    @Inject
    public XMLGregorianCalendarConverter(DatatypeFactory factory) {
        this.factory = factory;
        this.javaClass = factory.newXMLGregorianCalendar().getClass();
    }

    @Override
    public String getJavaClassName() {
        return this.javaClass.getName();
    }

    @Override
    public URI getDatatype() {
        return XMLSCHEMA.TYPE_DATETIME;
    }

    @Override
    public void setDatatype(URI datatype) {
        if (datatype.equals((Object)XMLSCHEMA.TYPE_DATETIME)) {
            return;
        }
        if (datatype.equals((Object)XMLSCHEMA.TYPE_DATE)) {
            return;
        }
        if (datatype.equals((Object)XMLSCHEMA.TYPE_TIME)) {
            return;
        }
        if (datatype.equals((Object)XMLSCHEMA.TYPE_GYEARMONTH)) {
            return;
        }
        if (datatype.equals((Object)XMLSCHEMA.TYPE_GMONTHDAY)) {
            return;
        }
        if (datatype.equals((Object)XMLSCHEMA.TYPE_GYEAR)) {
            return;
        }
        if (datatype.equals((Object)XMLSCHEMA.TYPE_GMONTH)) {
            return;
        }
        if (datatype.equals((Object)XMLSCHEMA.TYPE_GDAY)) {
            return;
        }
        throw new IllegalArgumentException(datatype.toString());
    }

    @Override
    public XMLGregorianCalendar deserialize(String label) {
        return this.factory.newXMLGregorianCalendar(label);
    }

    @Override
    public ILiteral serialize(XMLGregorianCalendar object) {
        return this.lf.createLiteral(object.toString(), this.getDatatype(), null);
    }
}

