/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.parser.manchester;

import java.util.Collection;
import java.util.List;
import net.enilink.komma.core.URI;
import net.enilink.komma.core.URIs;
import net.enilink.komma.parser.BaseRdfParser;
import net.enilink.komma.parser.manchester.IManchesterActions;
import net.enilink.komma.parser.manchester.tree.Annotation;
import net.enilink.komma.parser.sparql.tree.BNode;
import net.enilink.komma.parser.sparql.tree.BooleanLiteral;
import net.enilink.komma.parser.sparql.tree.GraphNode;
import net.enilink.komma.parser.sparql.tree.IriRef;
import net.enilink.komma.parser.sparql.tree.Literal;
import net.enilink.komma.parser.sparql.tree.QName;
import net.enilink.vocab.owl.OWL;
import net.enilink.vocab.rdf.RDF;
import net.enilink.vocab.rdfs.RDFS;
import org.parboiled.Rule;
import org.parboiled.support.Var;

public class ManchesterSyntaxParser
extends BaseRdfParser {
    public IManchesterActions actions;

    public ManchesterSyntaxParser() {
        this(new IManchesterActions(){

            @Override
            public boolean createStmt(Object subject, Object predicate, Object object) {
                return true;
            }
        });
    }

    public ManchesterSyntaxParser(IManchesterActions actions) {
        this.actions = actions;
    }

    public Rule AnnotatedList(Var<? extends GraphNode> source, URI property, Rule target) {
        return this.Sequence(this.WithAnnotations(source, property, target), this.ZeroOrMore(Character.valueOf(','), this.WithAnnotations(source, property, target), new Object[0]), new Object[0]);
    }

    public Rule Annotation() {
        return this.Sequence(this.IriRef(), this.AnnotationTarget(), new Object[]{this.push(new Annotation((GraphNode)this.pop(1), (GraphNode)this.pop()))});
    }

    public Rule AnnotationPropertyFrame() {
        Var annotationPropertyIri = new Var();
        return this.Sequence("AnnotationProperty:", this.IriRef(), new Object[]{annotationPropertyIri.set((Object)((GraphNode)this.pop())), this.actions.createStmt(annotationPropertyIri, RDF.PROPERTY_TYPE, OWL.TYPE_ANNOTATIONPROPERTY), this.ZeroOrMore(this.FirstOf(this.Sequence("Annotations:", this.AnnotatedList((Var<? extends GraphNode>)annotationPropertyIri, null, this.Annotation()), new Object[0]), this.Sequence("Domain:", this.AnnotatedList((Var<? extends GraphNode>)annotationPropertyIri, RDFS.PROPERTY_DOMAIN, this.IriRef()), new Object[0]), new Object[]{this.Sequence("Range:", this.AnnotatedList((Var<? extends GraphNode>)annotationPropertyIri, RDFS.PROPERTY_RANGE, this.IriRef()), new Object[0]), this.Sequence("SubPropertyOf:", this.AnnotatedList((Var<? extends GraphNode>)annotationPropertyIri, RDFS.PROPERTY_SUBPROPERTYOF, this.IriRef()), new Object[0])}))});
    }

    public Rule WithAnnotations(Var<? extends GraphNode> source, URI property, Rule target) {
        return this.Sequence(this.Annotations(), target, new Object[]{this.createAnnotatedStmt((List)this.pop(1), source.get(), property, this.pop())});
    }

    public boolean createAnnotatedStmt(List<Annotation> annotations, Object source, URI property, Object target) {
        if (source != null && property != null) {
            this.actions.createStmt(source, property, target);
        } else if (target instanceof Annotation) {
            this.push(target);
            source = target;
            property = URIs.createURI((String)((Annotation)target).getPredicate().toString());
            target = ((Annotation)target).getObject();
        }
        for (Annotation annotation : annotations) {
            if (property == null) {
                this.actions.createStmt(source, annotation.getPredicate(), annotation.getObject());
                continue;
            }
            BNode annotationNode = new BNode();
            this.actions.createStmt(annotationNode, RDF.PROPERTY_TYPE, OWL.TYPE_ANNOTATIONPROPERTY);
            this.actions.createStmt(annotationNode, OWL.PROPERTY_ANNOTATEDSOURCE, source);
            this.actions.createStmt(annotationNode, OWL.PROPERTY_ANNOTATEDPROPERTY, property);
            this.actions.createStmt(annotationNode, OWL.PROPERTY_ANNOTATEDTARGET, target);
            this.actions.createStmt(annotationNode, annotation.getPredicate(), annotation.getObject());
        }
        return true;
    }

    public Rule Annotations() {
        return this.Sequence(this.push(LIST_BEGIN), this.ZeroOrMore("Annotations:", this.AnnotatedList((Var<? extends GraphNode>)new Var((Object)null), null, this.Annotation()), new Object[0]), new Object[]{this.push(this.popList(Annotation.class))});
    }

    public Rule AnnotationTarget() {
        return this.FirstOf(this.BlankNode(), this.IriRef(), new Object[]{this.Literal()});
    }

    public Rule Atomic() {
        return this.FirstOf(this.IriRef(), this.Sequence(Character.valueOf('{'), this.List(this.Individual()), new Object[]{Character.valueOf('}')}), new Object[]{this.Sequence(Character.valueOf('('), this.Description(), new Object[]{Character.valueOf(')')})});
    }

    public Rule ClassFrame() {
        Var classIri = new Var();
        return this.Sequence("Class:", this.IriRef(), new Object[]{classIri.set((Object)((GraphNode)this.pop())), this.actions.createStmt(classIri, RDF.PROPERTY_TYPE, OWL.TYPE_CLASS), this.ZeroOrMore(this.FirstOf(this.Sequence("Annotations:", this.AnnotatedList((Var<? extends GraphNode>)classIri, null, this.Annotation()), new Object[0]), this.Sequence("SubClassOf:", this.AnnotatedList((Var<? extends GraphNode>)classIri, RDFS.PROPERTY_SUBCLASSOF, this.Description()), new Object[0]), new Object[]{this.Sequence("EquivalentTo:", this.AnnotatedList((Var<? extends GraphNode>)classIri, OWL.PROPERTY_EQUIVALENTCLASS, this.Description()), new Object[0]), this.Sequence("DisjointWith:", this.AnnotatedList((Var<? extends GraphNode>)classIri, OWL.PROPERTY_DISJOINTWITH, this.Description()), new Object[0]), this.Sequence("DisjointUnionOf:", this.WithAnnotations((Var<? extends GraphNode>)classIri, OWL.PROPERTY_DISJOINTUNIONOF, this.Sequence(this.List2(this.Description()), this.push(this.createRdfList((List)this.pop())), new Object[0])), new Object[0]), this.Sequence("HasKey:", this.WithAnnotations((Var<? extends GraphNode>)classIri, OWL.PROPERTY_HASKEY, this.OneOrMore(this.PropertyExpression())), new Object[0])}))});
    }

    public Rule PropertyExpression() {
        return this.FirstOf(this.ObjectPropertyExpression(), this.DataPropertyExpression(), new Object[0]);
    }

    public Rule Conjunction() {
        return this.FirstOf(this.Sequence(this.IriRef(), "that", new Object[]{this.Optional("not"), this.Restriction(), this.ZeroOrMore("and", this.Optional("not"), new Object[]{this.Restriction()})}), this.Sequence(this.Primary(), this.Optional(this.push(LIST_BEGIN), this.OneOrMore("and", this.Primary(), new Object[0]), new Object[]{this.push(new BNode()), this.actions.createStmt(this.peek(), RDF.PROPERTY_TYPE, OWL.TYPE_CLASS), this.actions.createStmt(this.peek(), OWL.PROPERTY_INTERSECTIONOF, this.createRdfList(this.popList(1, GraphNode.class, 1)))}), new Object[0]), new Object[0]);
    }

    public GraphNode createRdfList(Collection<? extends Object> elements) {
        BNode head = null;
        BNode last = null;
        for (Object object : elements) {
            BNode current = new BNode();
            this.actions.createStmt(current, RDF.PROPERTY_TYPE, RDF.TYPE_LIST);
            this.actions.createStmt(current, RDF.PROPERTY_FIRST, object);
            if (last != null) {
                this.actions.createStmt(last, RDF.PROPERTY_REST, current);
            }
            if (head == null) {
                head = current;
            }
            last = current;
        }
        this.actions.createStmt(last, RDF.PROPERTY_REST, RDF.NIL);
        return head;
    }

    public Rule DataAtomic() {
        return this.FirstOf(this.DatatypeRestriction(), this.Sequence(Character.valueOf('{'), this.List(this.Literal()), new Object[]{Character.valueOf('}')}), new Object[]{this.Sequence(Character.valueOf('('), this.DataRange(), new Object[]{Character.valueOf(')')})});
    }

    public Rule DataConjunction() {
        return this.Sequence(this.DataPrimary(), this.Optional(this.push(LIST_BEGIN), this.OneOrMore("and", this.DataPrimary(), new Object[0]), new Object[]{this.push(new BNode()), this.actions.createStmt(this.peek(), OWL.PROPERTY_INTERSECTIONOF, this.createRdfList(this.popList(1, GraphNode.class, 1)))}), new Object[0]);
    }

    public Rule DataPrimary() {
        return this.Sequence(this.Optional("not"), this.DataAtomic(), new Object[0]);
    }

    public Rule DataPropertyExpression() {
        return this.IriRef();
    }

    public Rule DataPropertyFact() {
        return this.Sequence(this.IriRef(), this.Literal(), new Object[0]);
    }

    public Rule DataPropertyFrame() {
        Var datapropertyIri = new Var();
        return this.Sequence("DataProperty:", this.IriRef(), new Object[]{datapropertyIri.set((Object)((GraphNode)this.pop())), this.actions.createStmt(datapropertyIri, RDF.PROPERTY_TYPE, OWL.TYPE_DATATYPEPROPERTY), this.ZeroOrMore(this.FirstOf(this.Sequence("Annotations:", this.AnnotatedList((Var<? extends GraphNode>)datapropertyIri, null, this.Annotation()), new Object[0]), this.Sequence("Domain:", this.AnnotatedList((Var<? extends GraphNode>)datapropertyIri, RDFS.PROPERTY_DOMAIN, this.Description()), new Object[0]), new Object[]{this.Sequence("Range:", this.AnnotatedList((Var<? extends GraphNode>)datapropertyIri, RDFS.PROPERTY_RANGE, this.DataRange()), new Object[0]), this.Sequence("Characteristics:", this.WithAnnotations((Var<? extends GraphNode>)datapropertyIri, RDF.PROPERTY_TYPE, this.Sequence("Functional", this.push(new IriRef(OWL.TYPE_FUNCTIONALPROPERTY.toString())), new Object[0])), new Object[0]), this.Sequence("SubPropertyOf:", this.AnnotatedList((Var<? extends GraphNode>)datapropertyIri, RDFS.PROPERTY_SUBPROPERTYOF, this.DataPropertyExpression()), new Object[0]), this.Sequence("EquivalentTo:", this.AnnotatedList((Var<? extends GraphNode>)datapropertyIri, OWL.PROPERTY_EQUIVALENTPROPERTY, this.DataPropertyExpression()), new Object[0]), this.Sequence("DisjointWith:", this.AnnotatedList((Var<? extends GraphNode>)datapropertyIri, OWL.PROPERTY_DISJOINTWITH, this.DataPropertyExpression()), new Object[0])}))});
    }

    public Rule DataRange() {
        return this.Sequence(this.DataConjunction(), this.Optional(this.push(LIST_BEGIN), this.OneOrMore("or", this.DataConjunction(), new Object[0]), new Object[]{this.push(new BNode()), this.actions.createStmt(this.peek(), OWL.PROPERTY_UNIONOF, this.createRdfList(this.popList(1, GraphNode.class, 1)))}), new Object[0]);
    }

    public Rule Datatype() {
        return this.FirstOf(this.IriRef(), this.Sequence(this.FirstOf("integer", "decimal", new Object[]{"float", "string"}), this.push(new IriRef("http://www.w3.org/2001/XMLSchema#" + this.match())), new Object[0]), new Object[0]);
    }

    public Rule DatatypeFrame() {
        Var datatypeIri = new Var();
        return this.Sequence("Datatype:", this.Datatype(), new Object[]{datatypeIri.set((Object)((GraphNode)this.pop())), this.actions.createStmt(datatypeIri, RDF.PROPERTY_TYPE, RDFS.TYPE_DATATYPE), this.ZeroOrMore("Annotations:", this.AnnotatedList((Var<? extends GraphNode>)datatypeIri, null, this.Annotation()), new Object[0]), this.Optional("EquivalentTo:", this.WithAnnotations((Var<? extends GraphNode>)datatypeIri, OWL.PROPERTY_EQUIVALENTCLASS, this.DataRange()), new Object[0]), this.ZeroOrMore("Annotations:", this.AnnotatedList((Var<? extends GraphNode>)datatypeIri, null, this.Annotation()), new Object[0])});
    }

    public Rule DatatypeRestriction() {
        Var restriction = new Var();
        return this.Sequence(this.Datatype(), this.Optional(Character.valueOf('['), restriction.set((Object)new BNode()), new Object[]{this.actions.createStmt(restriction.get(), RDF.PROPERTY_TYPE, RDFS.TYPE_DATATYPE), this.actions.createStmt(restriction.get(), OWL.PROPERTY_ONDATATYPE, this.pop()), this.push(LIST_BEGIN), this.push(new BNode()), this.Facet(), this.RestrictionValue(), this.actions.createStmt(this.peek(2), this.pop(1), this.pop()), this.ZeroOrMore(Character.valueOf(','), this.push(new BNode()), new Object[]{this.Facet(), this.RestrictionValue(), this.actions.createStmt(this.peek(2), this.pop(1), this.pop())}), Character.valueOf(']'), this.actions.createStmt(restriction.get(), OWL.PROPERTY_WITHRESTRICTIONS, this.createRdfList(this.popList(GraphNode.class))), this.push(restriction.get())}), new Object[0]);
    }

    public Rule Description() {
        return this.Sequence(this.Conjunction(), this.Optional(this.push(LIST_BEGIN), this.OneOrMore("or", this.Conjunction(), new Object[0]), new Object[]{this.push(new BNode()), this.actions.createStmt(this.peek(), RDF.PROPERTY_TYPE, OWL.TYPE_CLASS), this.actions.createStmt(this.peek(), OWL.PROPERTY_UNIONOF, this.createRdfList(this.popList(1, GraphNode.class, 1)))}), new Object[0]);
    }

    public Rule Entity() {
        return this.FirstOf(this.Sequence("Datatype", Character.valueOf('('), new Object[]{this.Datatype(), Character.valueOf(')')}), this.Sequence("Class", Character.valueOf('('), new Object[]{this.IriRef(), Character.valueOf(')')}), new Object[]{this.Sequence("ObjectProperty", Character.valueOf('('), new Object[]{this.IriRef(), Character.valueOf(')')}), this.Sequence("DataProperty", Character.valueOf('('), new Object[]{this.IriRef(), Character.valueOf(')')}), this.Sequence("AnnotationProperty", Character.valueOf('('), new Object[]{this.IriRef(), Character.valueOf(')')}), this.Sequence("NamedIndividual", Character.valueOf('('), new Object[]{this.IriRef(), Character.valueOf(')')})});
    }

    public Rule Facet() {
        return this.Sequence(this.FirstOf("length", "minLength", new Object[]{"maxLength", "pattern", "langPattern", "<=", Character.valueOf('<'), ">=", Character.valueOf('>')}), this.push(this.createFacet(this.match().trim())), new Object[0]);
    }

    public IriRef createFacet(String facet) {
        String name = facet;
        if ("<=".equals(facet)) {
            name = "minInclusive";
        } else if ("<".equals(facet)) {
            name = "minExclusive";
        } else if (">=".equals(facet)) {
            name = "maxInclusive";
        } else if (">".equals(facet)) {
            name = "maxExclusive";
        }
        return new IriRef("http://www.w3.org/2001/XMLSchema#" + name);
    }

    public Rule Fact(Var<GraphNode> individualIri) {
        Var not = new Var((Object)false);
        return this.Sequence(this.Optional("not", not.set((Object)true), new Object[0]), this.FirstOf(this.ObjectPropertyFact(), this.DataPropertyFact(), new Object[0]), new Object[]{this.createPropertyAssertion((GraphNode)individualIri.get(), (Boolean)not.get())});
    }

    public boolean createPropertyAssertion(GraphNode individual, boolean negative) {
        if (negative) {
            BNode assertion = new BNode();
            GraphNode property = (GraphNode)this.pop(1);
            Object value = this.pop();
            this.actions.createStmt(assertion, RDF.PROPERTY_TYPE, OWL.TYPE_NEGATIVEPROPERTYASSERTION);
            this.actions.createStmt(assertion, OWL.PROPERTY_SOURCEINDIVIDUAL, individual);
            this.actions.createStmt(assertion, OWL.PROPERTY_ASSERTIONPROPERTY, property);
            this.actions.createStmt(assertion, value instanceof Literal ? OWL.PROPERTY_TARGETVALUE : OWL.PROPERTY_TARGETINDIVIDUAL, value);
            this.push(assertion);
        } else {
            this.actions.createStmt(this.pop(1), this.pop(), individual);
            this.push(individual);
        }
        return true;
    }

    public Rule Frame() {
        return this.FirstOf(this.DatatypeFrame(), this.ClassFrame(), new Object[]{this.ObjectPropertyFrame(), this.DataPropertyFrame(), this.AnnotationPropertyFrame(), this.IndividualFrame(), this.Misc()});
    }

    public Rule ImportOntology() {
        return this.Sequence("Import:", this.IRI_REF_WS(), new Object[0]);
    }

    public Rule Individual() {
        return this.FirstOf(this.IriRef(), this.BlankNode(), new Object[0]);
    }

    public Rule IndividualFrame() {
        Var individualIri = new Var();
        return this.Sequence("Individual:", this.Individual(), new Object[]{individualIri.set((Object)((GraphNode)this.pop())), this.actions.createStmt(individualIri.get(), RDF.PROPERTY_TYPE, OWL.TYPE_INDIVIDUAL), this.ZeroOrMore(this.FirstOf(this.Sequence("Annotations:", this.AnnotatedList((Var<? extends GraphNode>)individualIri, null, this.Annotation()), new Object[0]), this.Sequence("Types:", this.AnnotatedList((Var<? extends GraphNode>)individualIri, RDF.PROPERTY_TYPE, this.Description()), new Object[0]), new Object[]{this.Sequence("Facts:", this.AnnotatedList((Var<? extends GraphNode>)individualIri, null, this.Fact((Var<GraphNode>)individualIri)), new Object[0]), this.Sequence("SameAs:", this.AnnotatedList((Var<? extends GraphNode>)individualIri, OWL.PROPERTY_SAMEAS, this.Individual()), new Object[0]), this.Sequence("DifferentFrom:", this.AnnotatedList((Var<? extends GraphNode>)individualIri, OWL.PROPERTY_DIFFERENTFROM, this.Individual()), new Object[0])}))});
    }

    public Rule InverseObjectProperty() {
        return this.Sequence("inverse", this.IriRef(), new Object[0]);
    }

    public Rule IRI_REF_WS() {
        return this.Sequence(this.IRI_REF(), this.WS(), new Object[0]);
    }

    @Override
    public Rule IriRef() {
        return this.FirstOf(this.IRI_REF(), this.PrefixedName(), new Object[]{this.Sequence(this.PN_LOCAL(), this.push(new QName("", (String)this.pop())), new Object[0])});
    }

    public Rule List(Rule element) {
        return this.Sequence(this.push(LIST_BEGIN), element, new Object[]{this.ZeroOrMore(Character.valueOf(','), element, new Object[0]), this.push(this.createRdfList(this.popList(GraphNode.class)))});
    }

    public Rule List2(Rule element) {
        return this.Sequence(this.push(LIST_BEGIN), element, new Object[]{this.OneOrMore(this.Sequence(Character.valueOf(','), element, new Object[0])), this.push(this.popList(GraphNode.class))});
    }

    public Rule Literal() {
        return this.FirstOf(this.RdfLiteral(), this.NumericLiteral(), new Object[]{this.BooleanLiteral()});
    }

    public Rule Misc() {
        return this.FirstOf(this.Sequence("EquivalentClasses:", this.Annotations(), new Object[]{this.List2(this.Description())}), this.Sequence("DisjointClasses:", this.Annotations(), new Object[]{this.List2(this.Description())}), new Object[]{this.Sequence("EquivalentProperties:", this.Annotations(), new Object[]{this.List2(this.IriRef())}), this.Sequence("DisjointProperties:", this.Annotations(), new Object[]{this.List2(this.IriRef())}), this.Sequence("SameIndividual:", this.Annotations(), new Object[]{this.List2(this.Individual())}), this.Sequence("DifferentIndividuals:", this.Annotations(), new Object[]{this.List2(this.Individual())})});
    }

    public Rule ObjectPropertyCharacteristic() {
        return this.Sequence(this.FirstOf("Functional", "InverseFunctional", new Object[]{"Reflexive", "Irreflexive", "Symmetric", "Asymmetric", "Transitive"}), this.push(new IriRef(OWL.NAMESPACE_URI.appendFragment(this.match().trim() + "Property").toString())), new Object[0]);
    }

    public Rule ObjectPropertyExpression() {
        return this.FirstOf(this.IriRef(), this.InverseObjectProperty(), new Object[0]);
    }

    public Rule ObjectPropertyFact() {
        return this.Sequence(this.IriRef(), this.Individual(), new Object[0]);
    }

    public Rule ObjectPropertyFrame() {
        Var objectPropertyIri = new Var();
        return this.Sequence("ObjectProperty:", this.IriRef(), new Object[]{objectPropertyIri.set((Object)((GraphNode)this.pop())), this.actions.createStmt(objectPropertyIri, RDF.PROPERTY_TYPE, OWL.TYPE_OBJECTPROPERTY), this.ZeroOrMore(this.FirstOf(this.Sequence("Annotations:", this.AnnotatedList((Var<? extends GraphNode>)objectPropertyIri, null, this.Annotation()), new Object[0]), this.Sequence("Domain:", this.AnnotatedList((Var<? extends GraphNode>)objectPropertyIri, RDFS.PROPERTY_DOMAIN, this.Description()), new Object[0]), new Object[]{this.Sequence("Range:", this.AnnotatedList((Var<? extends GraphNode>)objectPropertyIri, RDFS.PROPERTY_RANGE, this.Description()), new Object[0]), this.Sequence("Characteristics:", this.AnnotatedList((Var<? extends GraphNode>)objectPropertyIri, RDF.PROPERTY_TYPE, this.ObjectPropertyCharacteristic()), new Object[0]), this.Sequence("SubPropertyOf:", this.AnnotatedList((Var<? extends GraphNode>)objectPropertyIri, RDFS.PROPERTY_SUBPROPERTYOF, this.ObjectPropertyExpression()), new Object[0]), this.Sequence("EquivalentTo:", this.AnnotatedList((Var<? extends GraphNode>)objectPropertyIri, OWL.PROPERTY_EQUIVALENTPROPERTY, this.ObjectPropertyExpression()), new Object[0]), this.Sequence("DisjointWith:", this.AnnotatedList((Var<? extends GraphNode>)objectPropertyIri, OWL.PROPERTY_DISJOINTWITH, this.ObjectPropertyExpression()), new Object[0]), this.Sequence("InverseOf:", this.AnnotatedList((Var<? extends GraphNode>)objectPropertyIri, OWL.PROPERTY_INVERSEOF, this.ObjectPropertyExpression()), new Object[0]), this.Sequence("SubPropertyChain:", this.WithAnnotations((Var<? extends GraphNode>)objectPropertyIri, OWL.PROPERTY_PROPERTYCHAINAXIOM, this.Sequence(this.push(LIST_BEGIN), this.OneOrMore(this.Sequence(this.ObjectPropertyExpression(), Character.valueOf('o'), new Object[]{this.ObjectPropertyExpression()})), new Object[]{this.push(this.createRdfList(this.popList(GraphNode.class)))})), new Object[0])}))});
    }

    public Rule Ontology() {
        Var ontologyIri = new Var();
        return this.Sequence("Ontology:", this.Optional(this.Sequence(this.OntologyIRI(), ontologyIri.set((Object)((IriRef)this.pop())), new Object[]{this.actions.createStmt(ontologyIri.get(), RDF.PROPERTY_TYPE, OWL.TYPE_ONTOLOGY), this.Optional(this.Sequence(this.VersionIRI(), this.actions.createStmt(ontologyIri.get(), OWL.PROPERTY_VERSIONINFO, this.match()), new Object[0]))})), new Object[]{this.ZeroOrMore(this.ImportOntology()), this.Annotations(), this.ZeroOrMore(this.Frame())});
    }

    public Rule OntologyDocument() {
        return this.Sequence(this.ZeroOrMore(this.PrefixDeclaration()), this.Ontology(), new Object[]{EOI});
    }

    public Rule OntologyIRI() {
        return this.IRI_REF_WS();
    }

    public Rule PrefixDeclaration() {
        return this.Sequence("Prefix:", this.PNAME_NS(), new Object[]{this.IRI_REF()});
    }

    public Rule Primary() {
        Var isComplement = new Var((Object)false);
        return this.Sequence(this.Optional("not", isComplement.set((Object)true), new Object[0]), this.FirstOf(this.Restriction(), this.Atomic(), new Object[0]), new Object[]{this.FirstOf((Boolean)isComplement.get() != false && this.push(new BNode()) && this.actions.createStmt(this.peek(), RDF.PROPERTY_TYPE, OWL.TYPE_CLASS) && this.actions.createStmt(this.peek(), OWL.PROPERTY_COMPLEMENTOF, this.pop(1)), true, new Object[0])});
    }

    public Rule Restriction() {
        Var type = new Var();
        Var on = new Var();
        return this.Sequence(this.FirstOf(this.Sequence(this.DataPropertyExpression(), this.FirstOf(this.Sequence("some", type.set((Object)OWL.PROPERTY_SOMEVALUESFROM), new Object[]{this.DataPrimary()}), this.Sequence("only", type.set((Object)OWL.PROPERTY_ALLVALUESFROM), new Object[]{this.DataPrimary()}), new Object[]{this.Sequence("value", type.set((Object)OWL.PROPERTY_HASVALUE), new Object[]{this.Literal()}), this.Sequence("min", type.set((Object)OWL.PROPERTY_MINCARDINALITY), new Object[]{this.INTEGER(), this.Optional(this.DataPrimary(), on.set((Object)OWL.PROPERTY_ONDATARANGE), new Object[0])}), this.Sequence("max", type.set((Object)OWL.PROPERTY_MAXCARDINALITY), new Object[]{this.INTEGER(), this.Optional(this.DataPrimary(), on.set((Object)OWL.PROPERTY_ONDATARANGE), new Object[0])}), this.Sequence("exactly", type.set((Object)OWL.PROPERTY_CARDINALITY), new Object[]{this.INTEGER(), this.Optional(this.DataPrimary(), on.set((Object)OWL.PROPERTY_ONDATARANGE), new Object[0])})}), new Object[0]), this.Sequence(this.ObjectPropertyExpression(), this.FirstOf(this.Sequence("some", type.set((Object)OWL.PROPERTY_SOMEVALUESFROM), new Object[]{this.Primary()}), this.Sequence("only", type.set((Object)OWL.PROPERTY_ALLVALUESFROM), new Object[]{this.Primary()}), new Object[]{this.Sequence("value", type.set((Object)OWL.PROPERTY_HASVALUE), new Object[]{this.Individual()}), this.Sequence("Self", type.set((Object)OWL.PROPERTY_HASSELF), new Object[]{this.push(new BooleanLiteral(true))}), this.Sequence("min", type.set((Object)OWL.PROPERTY_MINCARDINALITY), new Object[]{this.INTEGER(), this.Optional(this.Primary(), on.set((Object)OWL.PROPERTY_ONCLASS), new Object[0])}), this.Sequence("max", type.set((Object)OWL.PROPERTY_MAXCARDINALITY), new Object[]{this.INTEGER(), this.Optional(this.Primary(), on.set((Object)OWL.PROPERTY_ONCLASS), new Object[0])}), this.Sequence("exactly", type.set((Object)OWL.PROPERTY_CARDINALITY), new Object[]{this.INTEGER(), this.Optional(this.Primary(), on.set((Object)OWL.PROPERTY_ONCLASS), new Object[0])})}), new Object[0]), new Object[0]), this.createRestriction((URI)type.get(), (URI)on.get()), new Object[0]);
    }

    public boolean createRestriction(URI type, URI on) {
        Object onTarget = null;
        if (on != null) {
            onTarget = this.pop();
            if (type.equals((Object)OWL.PROPERTY_CARDINALITY)) {
                type = OWL.PROPERTY_QUALIFIEDCARDINALITY;
            } else if (type.equals((Object)OWL.PROPERTY_MAXCARDINALITY)) {
                type = OWL.PROPERTY_MAXQUALIFIEDCARDINALITY;
            } else if (type.equals((Object)OWL.PROPERTY_MINCARDINALITY)) {
                type = OWL.PROPERTY_MINQUALIFIEDCARDINALITY;
            }
        }
        GraphNode property = (GraphNode)this.pop(1);
        BNode restriction = new BNode();
        this.actions.createStmt(restriction, RDF.PROPERTY_TYPE, OWL.TYPE_RESTRICTION);
        this.actions.createStmt(restriction, OWL.PROPERTY_ONPROPERTY, property);
        this.actions.createStmt(restriction, type, this.pop());
        if (on != null) {
            this.actions.createStmt(restriction, on, onTarget);
        }
        this.push(restriction);
        return true;
    }

    public Rule RestrictionValue() {
        return this.Literal();
    }

    public Rule VersionIRI() {
        return this.IRI_REF_WS();
    }
}

