/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.parser.sparql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.enilink.komma.parser.BaseRdfParser;
import net.enilink.komma.parser.sparql.tree.AbstractGraphNode;
import net.enilink.komma.parser.sparql.tree.AskQuery;
import net.enilink.komma.parser.sparql.tree.BNodePropertyList;
import net.enilink.komma.parser.sparql.tree.BasicGraphPattern;
import net.enilink.komma.parser.sparql.tree.Collection;
import net.enilink.komma.parser.sparql.tree.ConstructQuery;
import net.enilink.komma.parser.sparql.tree.Dataset;
import net.enilink.komma.parser.sparql.tree.DescribeQuery;
import net.enilink.komma.parser.sparql.tree.Graph;
import net.enilink.komma.parser.sparql.tree.GraphNode;
import net.enilink.komma.parser.sparql.tree.GraphPattern;
import net.enilink.komma.parser.sparql.tree.IntegerLiteral;
import net.enilink.komma.parser.sparql.tree.IriRef;
import net.enilink.komma.parser.sparql.tree.LimitModifier;
import net.enilink.komma.parser.sparql.tree.NamedGraph;
import net.enilink.komma.parser.sparql.tree.NumericLiteral;
import net.enilink.komma.parser.sparql.tree.OffsetModifier;
import net.enilink.komma.parser.sparql.tree.OptionalGraph;
import net.enilink.komma.parser.sparql.tree.OrderCondition;
import net.enilink.komma.parser.sparql.tree.OrderModifier;
import net.enilink.komma.parser.sparql.tree.PrefixDecl;
import net.enilink.komma.parser.sparql.tree.Prologue;
import net.enilink.komma.parser.sparql.tree.PropertyList;
import net.enilink.komma.parser.sparql.tree.PropertyPattern;
import net.enilink.komma.parser.sparql.tree.Query;
import net.enilink.komma.parser.sparql.tree.SelectQuery;
import net.enilink.komma.parser.sparql.tree.SolutionModifier;
import net.enilink.komma.parser.sparql.tree.UnionGraph;
import net.enilink.komma.parser.sparql.tree.Variable;
import net.enilink.komma.parser.sparql.tree.expr.BuiltInCall;
import net.enilink.komma.parser.sparql.tree.expr.Expression;
import net.enilink.komma.parser.sparql.tree.expr.FunctionCall;
import net.enilink.komma.parser.sparql.tree.expr.LogicalExpr;
import net.enilink.komma.parser.sparql.tree.expr.LogicalOperator;
import net.enilink.komma.parser.sparql.tree.expr.NegateExpr;
import net.enilink.komma.parser.sparql.tree.expr.NumericExpr;
import net.enilink.komma.parser.sparql.tree.expr.NumericOperator;
import net.enilink.komma.parser.sparql.tree.expr.RelationalExpr;
import net.enilink.komma.parser.sparql.tree.expr.RelationalOperator;
import org.parboiled.Rule;
import org.parboiled.support.Var;

public class SparqlParser
extends BaseRdfParser {
    public static String RDF_NAMESPACE = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    public static String RDF_TYPE = RDF_NAMESPACE + "type";
    public static String RDF_NIL = RDF_NAMESPACE + "nil";

    public Rule Query() {
        return this.Sequence(this.WS(), this.Prologue(), new Object[]{this.FirstOf(this.SelectQuery(), this.ConstructQuery(), new Object[]{this.DescribeQuery(), this.AskQuery()}), this.setPrologue((Prologue)this.pop(1), (Query)this.peek()), EOI});
    }

    public boolean setPrologue(Prologue prologue, Query query) {
        if (query != null) {
            query.setPrologue(prologue);
        }
        return true;
    }

    public Rule Prologue() {
        Var base = new Var();
        Var prefixes = new Var();
        return this.Sequence(prefixes.set(new ArrayList()), this.Optional(this.BaseDecl(), base.set((Object)((IriRef)this.pop())), new Object[0]), new Object[]{this.ZeroOrMore(this.PrefixDecl(), ((List)prefixes.get()).add((PrefixDecl)this.pop()), new Object[0]), this.push(new Prologue((IriRef)base.get(), (List)prefixes.get()))});
    }

    public Rule BaseDecl() {
        return this.Sequence("BASE", this.IRI_REF(), new Object[0]);
    }

    public Rule PrefixDecl() {
        return this.Sequence("PREFIX", this.PNAME_NS(), new Object[]{this.WS(), this.IRI_REF(), this.push(new PrefixDecl((String)this.pop(1), (IriRef)this.pop()))});
    }

    public Rule SelectQuery() {
        Var modifier = new Var();
        Var projection = new Var();
        Var dataset = new Var();
        return this.Sequence("SELECT", this.Optional(this.FirstOf(this.Sequence("DISTINCT", modifier.set((Object)SelectQuery.Modifier.DISTINCT), new Object[0]), this.Sequence("REDUCED", modifier.set((Object)SelectQuery.Modifier.REDUCED), new Object[0]), new Object[0])), new Object[]{this.push(LIST_BEGIN), this.FirstOf(this.OneOrMore(this.Var()), Character.valueOf('*'), new Object[0]), projection.set(this.popList(Variable.class)), dataset.set((Object)new Dataset()), this.ZeroOrMore(this.DatasetClause((Var<Dataset>)dataset)), this.WhereClause(), this.SolutionModifier(), this.push(new SelectQuery((SelectQuery.Modifier)((Object)modifier.get()), (List)projection.get(), (Dataset)dataset.get(), (Graph)this.pop(1), (List)this.pop()))});
    }

    public Rule ConstructQuery() {
        Var dataset = new Var();
        return this.Sequence("CONSTRUCT", this.ConstructTemplate(), new Object[]{dataset.set((Object)new Dataset()), this.ZeroOrMore(this.DatasetClause((Var<Dataset>)dataset)), this.WhereClause(), this.SolutionModifier(), this.push(new ConstructQuery((List)this.pop(2), (Dataset)dataset.get(), (Graph)this.pop(1), (List)this.pop()))});
    }

    public Rule DescribeQuery() {
        Var subjects = new Var();
        Var dataset = new Var();
        Var where = new Var();
        return this.Sequence("DESCRIBE", this.push(LIST_BEGIN), new Object[]{this.FirstOf(this.OneOrMore(this.VarOrIRIref()), Character.valueOf('*'), new Object[0]), subjects.set(this.popList(GraphNode.class)), dataset.set((Object)new Dataset()), this.ZeroOrMore(this.DatasetClause((Var<Dataset>)dataset)), this.Optional(this.WhereClause(), where.set((Object)((Graph)this.pop())), new Object[0]), this.SolutionModifier(), this.push(new DescribeQuery((List)subjects.get(), (Dataset)dataset.get(), (Graph)where.get(), (List)this.pop()))});
    }

    public Rule AskQuery() {
        Var dataset = new Var();
        return this.Sequence("ASK", dataset.set((Object)new Dataset()), new Object[]{this.ZeroOrMore(this.DatasetClause((Var<Dataset>)dataset)), this.WhereClause(), this.push(new AskQuery((Dataset)dataset.get(), (Graph)this.pop()))});
    }

    public Rule DatasetClause(Var<Dataset> dataset) {
        return this.Sequence("FROM", this.FirstOf(this.Sequence(this.DefaultGraphClause(), ((Dataset)dataset.get()).addDefaultGraph((Expression)this.pop()), new Object[0]), this.Sequence(this.NamedGraphClause(), ((Dataset)dataset.get()).addNamedGraph((Expression)this.pop()), new Object[0]), new Object[0]), new Object[0]);
    }

    public Rule DefaultGraphClause() {
        return this.SourceSelector();
    }

    public Rule NamedGraphClause() {
        return this.Sequence("NAMED", this.SourceSelector(), new Object[0]);
    }

    public Rule SourceSelector() {
        return this.IriRef();
    }

    public Rule WhereClause() {
        return this.Sequence(this.Optional("WHERE"), this.GroupGraphPattern(), new Object[0]);
    }

    public Rule SolutionModifier() {
        Var modifiers = new Var();
        return this.Sequence(modifiers.set(new ArrayList()), this.Optional(this.OrderClause(), ((List)modifiers.get()).add((SolutionModifier)this.pop()), new Object[0]), new Object[]{this.Optional(this.LimitOffsetClauses(), ((List)modifiers.get()).addAll((List)this.pop()), new Object[0]), this.push(modifiers.get())});
    }

    public Rule LimitOffsetClauses() {
        return this.FirstOf(this.Sequence(this.push(LIST_BEGIN), this.LimitClause(), new Object[]{this.Optional(this.OffsetClause()), this.push(this.popList(SolutionModifier.class))}), this.Sequence(this.push(LIST_BEGIN), this.OffsetClause(), new Object[]{this.Optional(this.LimitClause()), this.push(this.popList(SolutionModifier.class))}), new Object[0]);
    }

    public Rule OrderClause() {
        return this.Sequence("ORDER", "BY", new Object[]{this.push(LIST_BEGIN), this.OneOrMore(this.OrderCondition()), this.push(new OrderModifier(this.popList(OrderCondition.class)))});
    }

    public Rule OrderCondition() {
        return this.FirstOf(this.Sequence(this.FirstOf("ASC", "DESC", new Object[0]), this.push(this.match()), new Object[]{this.BrackettedExpression(), this.push(new OrderCondition("asc".equals(((String)this.pop(1)).toLowerCase()) ? OrderCondition.Direction.ASC : OrderCondition.Direction.DESC, (Expression)this.pop()))}), this.Sequence(this.FirstOf(this.Constraint(), this.Var(), new Object[0]), this.push(new OrderCondition(OrderCondition.Direction.ASC, (Expression)this.pop())), new Object[0]), new Object[0]);
    }

    public Rule LimitClause() {
        return this.Sequence("LIMIT", this.INTEGER(), new Object[]{this.push(new LimitModifier(((IntegerLiteral)this.pop()).getValue()))});
    }

    public Rule OffsetClause() {
        return this.Sequence("OFFSET", this.INTEGER(), new Object[]{this.push(new OffsetModifier(((IntegerLiteral)this.pop()).getValue()))});
    }

    public Rule GroupGraphPattern() {
        Var patterns = new Var();
        Var filters = new Var();
        return this.Sequence(Character.valueOf('{'), patterns.set(new ArrayList()), new Object[]{filters.set(new ArrayList()), this.Optional(this.TriplesBlock(), ((List)patterns.get()).add(new BasicGraphPattern((List)this.pop())), new Object[0]), this.ZeroOrMore(this.FirstOf(this.Sequence(this.GraphPatternNotTriples(), ((List)patterns.get()).add((Graph)this.pop()), new Object[0]), this.Sequence(this.Filter(), ((List)filters.get()).add((Expression)this.pop()), new Object[0]), new Object[0]), this.Optional(Character.valueOf('.')), new Object[]{this.Optional(this.TriplesBlock(), ((List)patterns.get()).add(new BasicGraphPattern((List)this.pop())), new Object[0])}), Character.valueOf('}'), this.push(new GraphPattern((List)patterns.get(), (List)filters.get()))});
    }

    public Rule TriplesBlock() {
        Var nodes = new Var();
        return this.Sequence(this.TriplesSameSubject(), nodes.set(new ArrayList()), new Object[]{((List)nodes.get()).add((GraphNode)this.pop()), this.Optional(Character.valueOf('.'), this.Optional(this.TriplesBlock(), ((List)nodes.get()).addAll((List)this.pop()), new Object[0]), new Object[0]), this.push(nodes.get())});
    }

    public Rule GraphPatternNotTriples() {
        return this.FirstOf(this.OptionalGraphPattern(), this.GroupOrUnionGraphPattern(), new Object[]{this.GraphGraphPattern()});
    }

    public Rule OptionalGraphPattern() {
        return this.Sequence("Optional", this.GroupGraphPattern(), new Object[]{this.push(new OptionalGraph((Graph)this.pop()))});
    }

    public Rule GraphGraphPattern() {
        return this.Sequence("GRAPH", this.VarOrIRIref(), new Object[]{this.GroupGraphPattern(), this.push(new NamedGraph((GraphNode)this.pop(1), (Graph)this.pop()))});
    }

    public Rule GroupOrUnionGraphPattern() {
        return this.Sequence(this.GroupGraphPattern(), this.Sequence(this.push(LIST_BEGIN), this.ZeroOrMore("UNION", this.GroupGraphPattern(), new Object[0]), new Object[]{this.push(new UnionGraph(this.popList(Graph.class, 1)))}), new Object[0]);
    }

    public Rule Filter() {
        return this.Sequence("FILTER", this.Constraint(), new Object[0]);
    }

    public Rule Constraint() {
        return this.FirstOf(this.BrackettedExpression(), this.BuiltInCall(), new Object[]{this.FunctionCall()});
    }

    public Rule FunctionCall() {
        return this.Sequence(this.IriRef(), this.ArgList(), new Object[]{this.push(new FunctionCall((Expression)this.pop(1), (List)this.pop()))});
    }

    public Rule ArgList() {
        Var args = new Var();
        return this.FirstOf(this.Sequence(Character.valueOf('('), Character.valueOf(')'), new Object[]{this.push(Collections.emptyList())}), this.Sequence(Character.valueOf('('), args.set(new ArrayList()), new Object[]{this.Expression(), ((List)args.get()).add((Expression)this.pop()), this.ZeroOrMore(Character.valueOf(','), this.Expression(), new Object[]{((List)args.get()).add((Expression)this.pop())}), Character.valueOf(')'), this.push(args.get())}), new Object[0]);
    }

    public Rule ConstructTemplate() {
        return this.Sequence(this.push(null), Character.valueOf('{'), new Object[]{this.Optional(this.ConstructTriples(), this.drop(1), new Object[0]), Character.valueOf('}')});
    }

    public Rule ConstructTriples() {
        Var nodes = new Var();
        return this.Sequence(this.TriplesSameSubject(), nodes.set(new ArrayList()), new Object[]{((List)nodes.get()).add((GraphNode)this.pop()), this.Optional(Character.valueOf('.'), this.Optional(this.ConstructTriples(), ((List)nodes.get()).addAll((List)this.pop()), new Object[0]), new Object[0]), this.push(nodes.get())});
    }

    public Rule TriplesSameSubject() {
        Var subject = new Var();
        return this.FirstOf(this.Sequence(this.VarOrTerm(), subject.set((Object)((GraphNode)this.peek())), new Object[]{this.PropertyListNotEmpty((Var<GraphNode>)subject)}), this.Sequence(this.TriplesNode(), subject.set((Object)((GraphNode)this.peek())), new Object[]{this.PropertyList((Var<GraphNode>)subject)}), new Object[0]);
    }

    public boolean addPropertyPatterns(PropertyList propertyList, GraphNode predicate, List<GraphNode> objects) {
        for (GraphNode object : objects) {
            propertyList.add(new PropertyPattern(predicate, object));
        }
        return true;
    }

    public PropertyList createPropertyList(GraphNode subject) {
        PropertyList propertyList = subject.getPropertyList();
        if ((propertyList == null || PropertyList.EMPTY_LIST.equals(propertyList)) && subject instanceof AbstractGraphNode) {
            propertyList = new PropertyList();
            ((AbstractGraphNode)subject).setPropertyList(propertyList);
        }
        return propertyList;
    }

    public Rule PropertyListNotEmpty(Var<GraphNode> subject) {
        Var propertyList = new Var();
        return this.Sequence(this.Verb(), this.ObjectList(), new Object[]{propertyList.set((Object)this.createPropertyList((GraphNode)subject.get())), this.addPropertyPatterns((PropertyList)propertyList.get(), (GraphNode)this.pop(1), (List)this.pop()), this.ZeroOrMore(Character.valueOf(';'), this.Optional(this.Verb(), this.ObjectList(), new Object[]{this.addPropertyPatterns((PropertyList)propertyList.get(), (GraphNode)this.pop(1), (List)this.pop())}), new Object[0])});
    }

    public Rule PropertyList(Var<GraphNode> subject) {
        return this.Optional(this.PropertyListNotEmpty(subject));
    }

    public Rule ObjectList() {
        return this.Sequence(this.Object(), this.Sequence(this.push(LIST_BEGIN), this.ZeroOrMore(Character.valueOf(','), this.Object(), new Object[0]), new Object[]{this.push(this.popList(GraphNode.class, 1))}), new Object[0]);
    }

    public Rule Object() {
        return this.GraphNode();
    }

    public Rule Verb() {
        return this.FirstOf(this.VarOrIRIref(), this.Sequence(Character.valueOf('a'), this.push(new IriRef(RDF_TYPE)), new Object[0]), new Object[0]);
    }

    public Rule TriplesNode() {
        return this.FirstOf(this.Collection(), this.BlankNodePropertyList(), new Object[0]);
    }

    public Rule BlankNodePropertyList() {
        Var subject = new Var();
        return this.Sequence(Character.valueOf('['), this.push(new BNodePropertyList()), new Object[]{subject.set((Object)((GraphNode)this.peek())), this.PropertyListNotEmpty((Var<GraphNode>)subject), Character.valueOf(']')});
    }

    public Rule Collection() {
        return this.Sequence(Character.valueOf('('), this.push(LIST_BEGIN), new Object[]{this.OneOrMore(this.GraphNode()), this.push(new Collection(this.popList(GraphNode.class))), Character.valueOf(')')});
    }

    public Rule GraphNode() {
        return this.FirstOf(this.VarOrTerm(), this.TriplesNode(), new Object[0]);
    }

    public Rule VarOrTerm() {
        return this.FirstOf(this.Var(), this.GraphTerm(), new Object[0]);
    }

    public Rule VarOrIRIref() {
        return this.FirstOf(this.Var(), this.IriRef(), new Object[0]);
    }

    public Rule Var() {
        return this.FirstOf(this.VAR1(), this.VAR2(), new Object[0]);
    }

    public Rule GraphTerm() {
        return this.FirstOf(this.IriRef(), this.RdfLiteral(), new Object[]{this.NumericLiteral(), this.BooleanLiteral(), this.BlankNode(), this.Sequence(Character.valueOf('('), Character.valueOf(')'), new Object[]{this.push(new IriRef(RDF_NIL))})});
    }

    public Rule Expression() {
        return this.ConditionalOrExpression();
    }

    public Rule ConditionalOrExpression() {
        return this.Sequence(this.ConditionalAndExpression(), this.Optional(this.push(LIST_BEGIN), this.OneOrMore("||", this.ConditionalAndExpression(), new Object[0]), new Object[]{this.push(new LogicalExpr(LogicalOperator.OR, this.popList(Expression.class, 1)))}), new Object[0]);
    }

    public Rule ConditionalAndExpression() {
        return this.Sequence(this.ValueLogical(), this.Optional(this.push(LIST_BEGIN), this.OneOrMore("&&", this.ValueLogical(), new Object[0]), new Object[]{this.push(new LogicalExpr(LogicalOperator.AND, this.popList(Expression.class, 1)))}), new Object[0]);
    }

    public Rule ValueLogical() {
        return this.RelationalExpression();
    }

    public Rule RelationalExpression() {
        return this.Sequence(this.NumericExpression(), this.Optional(this.RelationalOperator(), this.NumericExpression(), new Object[]{this.push(new RelationalExpr((RelationalOperator)((Object)this.pop(1)), (Expression)this.pop(1), (Expression)this.pop()))}), new Object[0]);
    }

    public Rule RelationalOperator() {
        return this.Sequence(this.FirstOf(Character.valueOf('='), "!=", new Object[]{"<=", ">=", Character.valueOf('<'), Character.valueOf('>')}), this.push((Object)RelationalOperator.fromSymbol(this.match().trim())), new Object[0]);
    }

    public Rule NumericExpression() {
        return this.AdditiveExpression();
    }

    public Rule AdditiveExpression() {
        Var expr = new Var();
        return this.Sequence(this.MultiplicativeExpression(), expr.set((Object)((Expression)this.pop())), new Object[]{this.ZeroOrMore(this.FirstOf(this.Sequence(Character.valueOf('+'), this.MultiplicativeExpression(), new Object[]{expr.set((Object)new NumericExpr(NumericOperator.ADD, (Expression)expr.get(), (Expression)this.pop()))}), this.Sequence(Character.valueOf('-'), this.MultiplicativeExpression(), new Object[]{expr.set((Object)new NumericExpr(NumericOperator.SUB, (Expression)expr.get(), (Expression)this.pop()))}), new Object[]{this.Sequence(this.NumericLiteralPositive(), expr.set((Object)new NumericExpr(NumericOperator.ADD, (Expression)expr.get(), (Expression)this.pop())), new Object[0]), this.Sequence(this.NumericLiteralNegative(), expr.set((Object)new NumericExpr(NumericOperator.SUB, (Expression)expr.get(), ((NumericLiteral)this.pop()).negate())), new Object[0])})), this.push(expr.get())});
    }

    public Rule MultiplicativeExpression() {
        Var expr = new Var();
        return this.Sequence(this.UnaryExpression(), expr.set((Object)((Expression)this.pop())), new Object[]{this.ZeroOrMore(this.FirstOf(this.Sequence(Character.valueOf('*'), this.UnaryExpression(), new Object[]{expr.set((Object)new NumericExpr(NumericOperator.MUL, (Expression)expr.get(), (Expression)this.pop()))}), this.Sequence(Character.valueOf('/'), this.UnaryExpression(), new Object[]{expr.set((Object)new NumericExpr(NumericOperator.DIV, (Expression)expr.get(), (Expression)this.pop()))}), new Object[0])), this.push(expr.get())});
    }

    public Rule UnaryExpression() {
        return this.FirstOf(this.Sequence(Character.valueOf('!'), this.PrimaryExpression(), new Object[]{this.push(new LogicalExpr(LogicalOperator.NOT, Collections.singletonList((Expression)this.pop())))}), this.Sequence(Character.valueOf('+'), this.PrimaryExpression(), new Object[0]), new Object[]{this.Sequence(Character.valueOf('-'), this.PrimaryExpression(), new Object[]{this.push(new NegateExpr((Expression)this.pop()))}), this.PrimaryExpression()});
    }

    public Rule PrimaryExpression() {
        return this.FirstOf(this.BrackettedExpression(), this.BuiltInCall(), new Object[]{this.IriRefOrFunction(), this.RdfLiteral(), this.NumericLiteral(), this.BooleanLiteral(), this.Var()});
    }

    public Rule BrackettedExpression() {
        return this.Sequence(Character.valueOf('('), this.Expression(), new Object[]{Character.valueOf(')')});
    }

    public boolean beginExprList() {
        this.push(this.match());
        this.push(LIST_BEGIN);
        return true;
    }

    public Rule BuiltInCall() {
        Var args = new Var();
        return this.Sequence(this.FirstOf(this.Sequence("STR", this.beginExprList(), new Object[]{Character.valueOf('('), this.Expression(), Character.valueOf(')')}), this.Sequence("LANG", this.beginExprList(), new Object[]{Character.valueOf('('), this.Expression(), Character.valueOf(')')}), new Object[]{this.Sequence("LANGMATCHES", this.beginExprList(), new Object[]{Character.valueOf('('), this.Expression(), Character.valueOf(','), this.Expression(), Character.valueOf(')')}), this.Sequence("DATATYPE", this.beginExprList(), new Object[]{Character.valueOf('('), this.Expression(), Character.valueOf(')')}), this.Sequence("BOUND", this.beginExprList(), new Object[]{Character.valueOf('('), this.Var(), Character.valueOf(')')}), this.Sequence("SAMETERM", this.beginExprList(), new Object[]{Character.valueOf('('), this.Expression(), Character.valueOf(','), this.Expression(), Character.valueOf(')')}), this.Sequence("ISIRI", this.beginExprList(), new Object[]{Character.valueOf('('), this.Expression(), Character.valueOf(')')}), this.Sequence("ISURI", this.beginExprList(), new Object[]{Character.valueOf('('), this.Expression(), Character.valueOf(')')}), this.Sequence("ISBLANK", this.beginExprList(), new Object[]{Character.valueOf('('), this.Expression(), Character.valueOf(')')}), this.Sequence("ISLITERAL", this.beginExprList(), new Object[]{Character.valueOf('('), this.Expression(), Character.valueOf(')')}), this.Sequence("REGEX", this.beginExprList(), new Object[]{Character.valueOf('('), this.Expression(), Character.valueOf(','), this.Expression(), this.Optional(Character.valueOf(','), this.Expression(), new Object[0]), Character.valueOf(')')})}), args.set(this.popList(Expression.class)), new Object[]{this.push(new BuiltInCall((String)this.pop(), (List)args.get()))});
    }

    public Rule IriRefOrFunction() {
        return this.Sequence(this.IriRef(), this.Optional(this.ArgList(), this.push(new FunctionCall((Expression)this.pop(1), (List)this.pop())), new Object[0]), new Object[0]);
    }

    public Rule VAR1() {
        return this.Sequence(this.Ch('?'), this.VARNAME(), new Object[0]);
    }

    public Rule VAR2() {
        return this.Sequence(this.Ch('$'), this.VARNAME(), new Object[0]);
    }

    public Rule VARNAME() {
        return this.Sequence(this.Sequence(this.FirstOf(this.PN_CHARS_U(), this.DIGIT(), new Object[0]), this.ZeroOrMore(this.FirstOf(this.PN_CHARS_U(), this.DIGIT(), new Object[]{this.Ch('\u00b7'), this.CharRange('\u0300', '\u036f'), this.CharRange('\u203f', '\u2040')})), new Object[0]), this.push(new Variable(this.match())), new Object[]{this.WS()});
    }

    @Override
    protected Rule fromStringLiteral(String string) {
        return this.Sequence(this.IgnoreCase(string), this.WS(), new Object[0]);
    }
}

