/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.parser.sparql.tree;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import net.enilink.komma.parser.sparql.tree.expr.Expression;
import net.enilink.komma.parser.sparql.tree.visitor.Visitable;
import net.enilink.komma.parser.sparql.tree.visitor.Visitor;

public class Dataset
implements Visitable {
    protected Set<Expression> defaultGraphs = new LinkedHashSet<Expression>();
    protected Set<Expression> namedGraphs = new LinkedHashSet<Expression>();

    public Dataset() {
    }

    public Dataset(Set<Expression> defaultGraphs, Set<Expression> namedGraphs) {
        this.defaultGraphs.addAll(defaultGraphs);
        this.namedGraphs.addAll(namedGraphs);
    }

    public Set<Expression> getDefaultGraphs() {
        return Collections.unmodifiableSet(this.defaultGraphs);
    }

    public boolean addDefaultGraph(Expression graph) {
        return this.defaultGraphs.add(graph);
    }

    public boolean removeDefaultGraph(Expression graph) {
        return this.defaultGraphs.remove(graph);
    }

    public Set<Expression> getNamedGraphs() {
        return Collections.unmodifiableSet(this.namedGraphs);
    }

    public boolean addNamedGraph(Expression graph) {
        return this.namedGraphs.add(graph);
    }

    public boolean removeNamedGraph(Expression graph) {
        return this.namedGraphs.remove(graph);
    }

    public void clear() {
        this.defaultGraphs.clear();
        this.namedGraphs.clear();
    }

    public boolean isEmpty() {
        return this.defaultGraphs.isEmpty() && this.namedGraphs.isEmpty();
    }

    @Override
    public <R, T> R accept(Visitor<R, T> visitor, T data) {
        return visitor.dataset(this, data);
    }

    public void add(Dataset dataset) {
        this.defaultGraphs.addAll(dataset.getDefaultGraphs());
        this.namedGraphs.addAll(dataset.getNamedGraphs());
    }
}

