/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.edit.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.enilink.komma.common.command.AbstractCommand;
import net.enilink.komma.common.command.CommandResult;
import net.enilink.komma.common.command.ICommand;
import net.enilink.komma.edit.KommaEditPlugin;
import net.enilink.komma.edit.command.AbstractOverrideableCommand;
import net.enilink.komma.edit.command.CommandParameter;
import net.enilink.komma.edit.command.CopyCommand;
import net.enilink.komma.edit.domain.IEditingDomain;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;

public class CopyToClipboardCommand
extends AbstractOverrideableCommand
implements AbstractCommand.INonDirtying {
    protected static final String LABEL = KommaEditPlugin.INSTANCE.getString("_UI_CopyToClipboardCommand_label");
    protected static final String DESCRIPTION = KommaEditPlugin.INSTANCE.getString("_UI_CopyToClipboardCommand_description");
    protected Collection<?> sourceObjects;
    protected Collection<Object> oldClipboard;
    protected ICommand copyCommand;

    public static ICommand create(IEditingDomain domain, Collection<?> collection) {
        if (domain == null) {
            CopyToClipboardCommand command = new CopyToClipboardCommand(domain, collection);
            return command;
        }
        ICommand command = domain.createCommand(CopyToClipboardCommand.class, new CommandParameter(null, null, collection));
        return command;
    }

    public CopyToClipboardCommand(IEditingDomain domain, Collection<?> collection) {
        super(domain, LABEL, DESCRIPTION);
        this.sourceObjects = collection;
    }

    public static ICommand create(IEditingDomain domain, Object owner) {
        return CopyToClipboardCommand.create(domain, Collections.singleton(owner));
    }

    public Collection<?> getSourceObjects() {
        return this.sourceObjects;
    }

    protected boolean prepare() {
        this.copyCommand = CopyCommand.create(this.getDomain(), this.sourceObjects, this.getDomain().getClipboardModel());
        return this.copyCommand.canExecute();
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        this.getDomain().getClipboardModel().getManager().clear();
        this.copyCommand.execute(progressMonitor, info);
        this.oldClipboard = this.getDomain().getClipboard();
        this.getDomain().setClipboard(new ArrayList<Object>(new ArrayList(this.copyCommand.getCommandResult().getReturnValues())));
        return this.copyCommand.getCommandResult();
    }

    @Override
    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        this.copyCommand.undo(progressMonitor, info);
        this.getDomain().setClipboard(this.oldClipboard);
        return this.copyCommand.getCommandResult();
    }

    @Override
    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        this.copyCommand.redo(progressMonitor, info);
        this.oldClipboard = this.getDomain().getClipboard();
        this.getDomain().setClipboard(new ArrayList<Object>(this.copyCommand.getCommandResult().getReturnValues()));
        return this.copyCommand.getCommandResult();
    }

    @Override
    public Collection<?> doGetAffectedObjects() {
        return this.copyCommand.getAffectedObjects();
    }

    @Override
    public void doDispose() {
        if (this.copyCommand != null) {
            this.copyCommand.dispose();
        }
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (domain: " + this.getDomain() + ")");
        result.append(" (sourceObjects: " + this.sourceObjects + ")");
        result.append(" (oldClipboard: " + this.oldClipboard + ")");
        return result.toString();
    }
}

