/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.edit.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import net.enilink.komma.common.command.CommandResult;
import net.enilink.komma.common.command.ExtendedCompositeCommand;
import net.enilink.komma.common.command.ICommand;
import net.enilink.komma.core.IReference;
import net.enilink.komma.edit.KommaEditPlugin;
import net.enilink.komma.edit.command.AddCommand;
import net.enilink.komma.edit.command.CommandParameter;
import net.enilink.komma.edit.command.ICommandActionDelegate;
import net.enilink.komma.edit.command.SetCommand;
import net.enilink.komma.edit.domain.IEditingDomain;
import net.enilink.komma.em.concepts.IResource;
import net.enilink.komma.model.IModel;
import net.enilink.komma.model.IObject;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;

public class CreateChildCommand
extends ExtendedCompositeCommand
implements ICommandActionDelegate {
    protected ICommand addChildCommand;
    protected Collection<?> affectedObjects;
    protected Object child;
    protected Object childDescription;
    protected boolean doAdd = false;
    protected IEditingDomain domain;
    protected IHelper helper;
    protected int index;
    protected IResource owner;
    protected IReference property;
    protected Collection<?> selection;

    public static ICommand create(IEditingDomain domain, Object owner, Object newChildDescriptor, Collection<?> selection) {
        return domain.createCommand(CreateChildCommand.class, new CommandParameter(owner, null, newChildDescriptor, new ArrayList(selection)));
    }

    public CreateChildCommand(IEditingDomain domain, IResource owner, IReference property, Object childDescription, Collection<?> selection) {
        this(domain, owner, property, childDescription, -1, selection, null);
    }

    public CreateChildCommand(IEditingDomain domain, IResource owner, IReference property, Object childDescription, Collection<?> selection, IHelper helper) {
        this(domain, owner, property, childDescription, -1, selection, helper);
    }

    public CreateChildCommand(IEditingDomain domain, IResource owner, IReference property, Object childDescription, int index, Collection<?> selection) {
        this(domain, owner, property, childDescription, index, selection, null);
    }

    public CreateChildCommand(IEditingDomain domain, IResource owner, IReference property, Object childDescription, int index, Collection<?> selection, IHelper helper) {
        this.domain = domain;
        this.owner = owner;
        this.property = property;
        this.childDescription = childDescription;
        this.index = index;
        this.selection = selection == null ? Collections.EMPTY_LIST : selection;
        this.helper = helper;
        String text = this.helper.getCreateChildText(owner, property, childDescription, selection);
        this.setLabel(KommaEditPlugin.INSTANCE.getString("_UI_CreateChildCommand_label", new Object[]{text}));
        this.setDescription(KommaEditPlugin.INSTANCE.getString("_UI_CreateChildCommand_description"));
    }

    public boolean canRedo() {
        return true;
    }

    public boolean canUndo() {
        return true;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        Collection<?> result;
        this.child = this.helper.createChild(this.owner, this.property, this.childDescription, info);
        if (this.child != null) {
            this.addAndExecute(this.doAdd ? AddCommand.create(this.domain, (Object)this.owner, (Object)this.property, this.child, this.index) : SetCommand.create(this.domain, this.owner, this.property, this.child), progressMonitor, info);
        }
        return CommandResult.newOKCommandResult((Object)((result = (this.affectedObjects = this.helper.getCreateChildResult(this.child))) == null ? Collections.EMPTY_LIST : result));
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        CommandResult result = super.doRedoWithResult(progressMonitor, info);
        this.affectedObjects = this.helper.getCreateChildResult(this.child);
        return result;
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        CommandResult result = super.doUndoWithResult(progressMonitor, info);
        this.affectedObjects = this.selection;
        return result;
    }

    public Collection<?> getAffectedObjects() {
        return this.affectedObjects == null ? Collections.EMPTY_LIST : this.affectedObjects;
    }

    public Collection<Object> getAffectedResources(Object type) {
        if (IModel.class.equals(type) && this.owner instanceof IObject) {
            HashSet<Object> affected = new HashSet<Object>(super.getAffectedResources(type));
            affected.add(((IObject)this.owner).getModel());
            return affected;
        }
        return super.getAffectedResources(type);
    }

    @Override
    public String getDescription() {
        return this.helper.getCreateChildDescription(this.owner, this.property, this.childDescription, this.selection);
    }

    @Override
    public Object getImage() {
        return this.helper.getCreateChildImage(this.owner, this.property, this.childDescription, this.selection);
    }

    @Override
    public String getText() {
        return this.helper.getCreateChildText(this.owner, this.property, this.childDescription, this.selection);
    }

    @Override
    public String getToolTipText() {
        return this.helper.getCreateChildToolTipText(this.owner, this.property, this.childDescription, this.selection);
    }

    public boolean prepare() {
        if (this.owner == null || this.property == null || this.childDescription == null) {
            return false;
        }
        int maxCardinality = (Integer)this.owner.getApplicableCardinality(this.property).getSecond();
        if (maxCardinality != 1) {
            if (maxCardinality != Integer.MAX_VALUE && this.owner.getCardinality(this.property) >= maxCardinality) {
                return false;
            }
            this.doAdd = true;
            return true;
        }
        return this.owner.getCardinality(this.property) == 0;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (domain: " + this.domain + ")");
        result.append(" (owner: " + this.owner + ")");
        result.append(" (property: " + this.property + ")");
        result.append(" (child: " + this.childDescription + ")");
        result.append(" (index: " + this.index + ")");
        result.append(" (helper: " + this.helper + ")");
        result.append(" (affectedObjects: " + this.affectedObjects + ")");
        result.append(" (selection: " + this.selection + ")");
        return result.toString();
    }

    public static interface IHelper {
        public Object createChild(Object var1, Object var2, Object var3, IAdaptable var4);

        public String getCreateChildDescription(Object var1, Object var2, Object var3, Collection<?> var4);

        public Object getCreateChildImage(Object var1, Object var2, Object var3, Collection<?> var4);

        public Collection<?> getCreateChildResult(Object var1);

        public String getCreateChildText(Object var1, Object var2, Object var3, Collection<?> var4);

        public String getCreateChildToolTipText(Object var1, Object var2, Object var3, Collection<?> var4);
    }
}

