/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.edit.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.enilink.komma.common.command.CommandResult;
import net.enilink.komma.common.command.CommandWrapper;
import net.enilink.komma.common.command.ICommand;
import net.enilink.komma.edit.KommaEditPlugin;
import net.enilink.komma.edit.command.CommandParameter;
import net.enilink.komma.edit.command.RemoveCommand;
import net.enilink.komma.edit.domain.IEditingDomain;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;

public class CutToClipboardCommand
extends CommandWrapper {
    protected static final String LABEL = KommaEditPlugin.INSTANCE.getString("_UI_CutToClipboardCommand_label");
    protected static final String DESCRIPTION = KommaEditPlugin.INSTANCE.getString("_UI_CutToClipboardCommand_description");
    protected IEditingDomain domain;
    protected Collection<Object> oldClipboard;

    public static ICommand create(IEditingDomain domain, Object value) {
        if (domain == null) {
            return new CutToClipboardCommand(domain, RemoveCommand.create(domain, value));
        }
        return domain.createCommand(CutToClipboardCommand.class, new CommandParameter(null, null, Collections.singleton(value)));
    }

    public static ICommand create(IEditingDomain domain, Object owner, Object feature, Object value) {
        if (domain == null) {
            return new CutToClipboardCommand(domain, RemoveCommand.create(domain, owner, feature, value));
        }
        return domain.createCommand(CutToClipboardCommand.class, new CommandParameter(owner, feature, Collections.singleton(value)));
    }

    public static ICommand create(IEditingDomain domain, Collection<?> collection) {
        if (domain == null) {
            return new CutToClipboardCommand(domain, RemoveCommand.create(domain, collection));
        }
        return domain.createCommand(CutToClipboardCommand.class, new CommandParameter(null, null, collection));
    }

    public static ICommand create(IEditingDomain domain, Object owner, Object property, Collection<?> collection) {
        if (domain == null) {
            return new CutToClipboardCommand(domain, RemoveCommand.create(domain, owner, property, collection));
        }
        return domain.createCommand(CutToClipboardCommand.class, new CommandParameter(owner, property, collection));
    }

    public CutToClipboardCommand(IEditingDomain domain, ICommand command) {
        super(LABEL, DESCRIPTION, command);
        this.domain = domain;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        CommandResult result = super.doExecuteWithResult(progressMonitor, info);
        if (this.domain != null) {
            this.oldClipboard = this.domain.getClipboard();
            this.domain.setClipboard(new ArrayList<Object>(result.getReturnValues()));
        }
        return result;
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        CommandResult result = super.doUndoWithResult(progressMonitor, info);
        if (this.domain != null) {
            this.domain.setClipboard(this.oldClipboard);
        }
        return result;
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        CommandResult result = super.doRedoWithResult(progressMonitor, info);
        if (this.domain != null) {
            this.oldClipboard = this.domain.getClipboard();
            this.domain.setClipboard(new ArrayList<Object>(result.getReturnValues()));
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (domain: " + this.domain + ")");
        result.append(" (oldClipboard: " + this.oldClipboard + ")");
        return result.toString();
    }
}

