/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.edit.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.ListIterator;
import net.enilink.komma.common.command.AbstractCommand;
import net.enilink.komma.common.command.CommandResult;
import net.enilink.komma.common.command.CommandWrapper;
import net.enilink.komma.common.command.CompositeCommand;
import net.enilink.komma.common.command.ExtendedCompositeCommand;
import net.enilink.komma.common.command.ICommand;
import net.enilink.komma.common.command.IdentityCommand;
import net.enilink.komma.common.command.UnexecutableCommand;
import net.enilink.komma.core.IReference;
import net.enilink.komma.edit.KommaEditPlugin;
import net.enilink.komma.edit.command.AddCommand;
import net.enilink.komma.edit.command.CommandParameter;
import net.enilink.komma.edit.command.CopyCommand;
import net.enilink.komma.edit.command.IDragAndDropFeedback;
import net.enilink.komma.edit.command.MoveCommand;
import net.enilink.komma.edit.command.RemoveCommand;
import net.enilink.komma.edit.command.SetCommand;
import net.enilink.komma.edit.domain.IEditingDomain;
import net.enilink.komma.em.concepts.IProperty;
import net.enilink.komma.em.concepts.IResource;
import net.enilink.komma.model.IModelAware;
import net.enilink.komma.model.IModelSet;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class DragAndDropCommand
extends AbstractCommand
implements IDragAndDropFeedback {
    protected static final String DESCRIPTION = KommaEditPlugin.INSTANCE.getString("_UI_DragAndDropCommand_description");
    protected static final String LABEL = KommaEditPlugin.INSTANCE.getString("_UI_DragAndDropCommand_label");
    protected Collection<?> collection;
    protected IEditingDomain domain;
    protected ICommand dragCommand;
    protected ICommand dropCommand;
    protected int feedback;
    protected boolean isDragCommandExecuted;
    protected float location;
    protected float lowerLocationBound;
    protected int operation;
    protected int operations;
    protected Object owner;
    protected float upperLocationBound;

    public static ICommand create(IEditingDomain domain, Object owner, float location, int operations, int operation, Collection<?> collection) {
        return domain.createCommand(DragAndDropCommand.class, new CommandParameter(owner, (Object)new Detail(location, operations, operation), collection));
    }

    public DragAndDropCommand(IEditingDomain domain, Object owner, float location, int operations, int operation, Collection<?> collection) {
        super(LABEL, DESCRIPTION);
        this.domain = domain;
        this.owner = owner;
        this.location = location;
        this.operations = operations;
        this.operation = operation;
        this.collection = collection;
    }

    protected boolean analyzeForNonContainment(ICommand command) {
        if (command instanceof AddCommand) {
            return this.isNonContainment(((AddCommand)command).getProperty());
        }
        if (command instanceof SetCommand) {
            return this.isNonContainment(((SetCommand)command).getProperty());
        }
        if (command instanceof CommandWrapper) {
            return this.analyzeForNonContainment(((CommandWrapper)command).getCommand());
        }
        if (command instanceof ExtendedCompositeCommand) {
            for (ICommand childCommand : ((ExtendedCompositeCommand)command).getCommandList()) {
                if (!this.analyzeForNonContainment(childCommand)) continue;
                return true;
            }
        }
        return false;
    }

    public void dispose() {
        if (this.dragCommand != null) {
            this.dragCommand.dispose();
        }
        if (this.dropCommand != null) {
            this.dropCommand.dispose();
        }
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.dragCommand != null && !this.isDragCommandExecuted && !this.dragCommand.execute(progressMonitor, info).isOK()) {
            return this.dragCommand.getCommandResult();
        }
        if (this.dropCommand != null && this.dropCommand.canExecute()) {
            this.dropCommand.execute(progressMonitor, info);
            return this.dropCommand.getCommandResult();
        }
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.dragCommand != null && this.dragCommand.redo(progressMonitor, info).isOK()) {
            return this.dragCommand.getCommandResult();
        }
        if (this.dropCommand != null && this.dropCommand.redo(progressMonitor, info).isOK()) {
            return this.dropCommand.getCommandResult();
        }
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (this.dropCommand != null && this.dropCommand.undo(progressMonitor, info).isOK()) {
            return this.dropCommand.getCommandResult();
        }
        if (this.dragCommand != null && this.dragCommand.undo(progressMonitor, info).isOK()) {
            return this.dragCommand.getCommandResult();
        }
        return CommandResult.newOKCommandResult();
    }

    public Collection<?> getAffectedObjects() {
        return this.dropCommand != null ? this.dropCommand.getAffectedObjects() : super.getAffectedObjects();
    }

    public Collection<?> getAffectedResources(Object type) {
        HashSet affected = new HashSet();
        if (this.dragCommand != null) {
            affected.addAll(this.dragCommand.getAffectedResources(type));
        }
        if (this.dropCommand != null) {
            affected.addAll(this.dropCommand.getAffectedResources(type));
        }
        return affected;
    }

    protected Collection<?> getChildren(Object object) {
        return this.domain.getChildren(object);
    }

    public Collection<?> getCollection() {
        return this.collection;
    }

    @Override
    public int getFeedback() {
        return this.isExecutable ? this.feedback : 1;
    }

    public float getLocation() {
        return this.location;
    }

    @Override
    public int getOperation() {
        return this.isExecutable ? this.operation : 0;
    }

    public int getOperations() {
        return this.operations;
    }

    public Object getOwner() {
        return this.owner;
    }

    protected Object getParent(Object object) {
        return this.domain.getParent(object);
    }

    protected boolean isCrossModelSet() {
        for (Object item : this.collection) {
            IModelSet itemModelSet;
            if (!(item instanceof IModelAware) || (itemModelSet = ((IModelAware)item).getModel().getModelSet()) == null || itemModelSet.equals(this.domain.getModelSet())) continue;
            return true;
        }
        return false;
    }

    protected boolean isNonContainment(IReference property) {
        property = ((IResource)this.owner).getEntityManager().find(property);
        return !((IProperty)property).isContainment();
    }

    protected boolean prepare() {
        boolean result = false;
        if (this.owner != null && this.collection != null && this.operations != 0 && this.operation != 0) {
            if ((double)this.location <= 0.2 || (double)this.location >= 0.8) {
                result = this.prepareDropInsert();
                if (result) {
                    if ((double)this.location <= 0.2) {
                        this.lowerLocationBound = 0.0f;
                        this.upperLocationBound = 0.2f;
                    } else {
                        this.lowerLocationBound = 0.8f;
                        this.upperLocationBound = 1.0f;
                    }
                } else {
                    this.reset();
                    result = this.prepareDropOn();
                    if ((double)this.location <= 0.2) {
                        this.lowerLocationBound = 0.0f;
                        this.upperLocationBound = 0.8f;
                    } else {
                        this.lowerLocationBound = 0.2f;
                        this.upperLocationBound = 1.0f;
                    }
                }
            } else {
                result = this.prepareDropOn();
                if (result) {
                    this.lowerLocationBound = 0.2f;
                    this.upperLocationBound = 0.8f;
                } else {
                    this.reset();
                    result = this.prepareDropInsert();
                    if ((double)this.location <= 0.5) {
                        this.lowerLocationBound = 0.0f;
                        this.upperLocationBound = 0.5f;
                    } else {
                        this.lowerLocationBound = 0.5f;
                        this.upperLocationBound = 1.0f;
                    }
                }
            }
        } else {
            this.lowerLocationBound = 0.0f;
            this.upperLocationBound = 1.0f;
        }
        return result;
    }

    protected boolean prepareDropCopyInsert(Object parent, Collection<?> children, int index) {
        if (this.collection.contains(this.owner)) {
            this.dragCommand = IdentityCommand.INSTANCE;
            this.dropCommand = UnexecutableCommand.INSTANCE;
        } else {
            this.dragCommand = IdentityCommand.INSTANCE;
            final ICommand copyCommand = CopyCommand.create(this.domain, this.collection, null);
            CompositeCommand copyAndAddCommand = new CompositeCommand(){

                protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                    CommandResult result = super.doExecuteWithResult(progressMonitor, info);
                    if (!result.getStatus().isOK()) {
                        return result;
                    }
                    IStatus status = this.addAndExecute(AddCommand.create(DragAndDropCommand.this.domain, DragAndDropCommand.this.owner, null, copyCommand.getCommandResult().getReturnValues()), progressMonitor, info);
                    return CommandResult.newCommandResult((IStatus)status, (Object)result.getReturnValue());
                }
            };
            copyAndAddCommand.add((IUndoableOperation)copyCommand);
            if (copyAndAddCommand.canExecute() && copyAndAddCommand.canUndo()) {
                ICommand dummyAdd = AddCommand.create(this.domain, this.owner, null, this.collection);
                if (!dummyAdd.canExecute() || this.analyzeForNonContainment(dummyAdd)) {
                    this.dropCommand = UnexecutableCommand.INSTANCE;
                    copyAndAddCommand.dispose();
                } else {
                    this.dropCommand = copyAndAddCommand;
                }
                dummyAdd.dispose();
            } else {
                this.dropCommand = UnexecutableCommand.INSTANCE;
            }
        }
        return this.dragCommand.canExecute() && this.dropCommand.canExecute();
    }

    protected boolean prepareDropCopyOn() {
        this.dragCommand = IdentityCommand.INSTANCE;
        final ICommand copyCommand = CopyCommand.create(this.domain, this.collection, null);
        CompositeCommand copyAndAddCommand = new CompositeCommand(){

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                CommandResult result = super.doExecuteWithResult(progressMonitor, info);
                if (!result.getStatus().isOK()) {
                    return result;
                }
                IStatus status = this.addAndExecute(AddCommand.create(DragAndDropCommand.this.domain, DragAndDropCommand.this.owner, null, copyCommand.getCommandResult().getReturnValues()), progressMonitor, info);
                return CommandResult.newCommandResult((IStatus)status, (Object)result.getReturnValue());
            }
        };
        copyAndAddCommand.add((IUndoableOperation)copyCommand);
        if (copyAndAddCommand.canExecute() && copyAndAddCommand.canUndo()) {
            ICommand dummyAdd = AddCommand.create(this.domain, this.owner, null, this.collection);
            if (!dummyAdd.canExecute() || this.analyzeForNonContainment(dummyAdd)) {
                this.dropCommand = UnexecutableCommand.INSTANCE;
                copyAndAddCommand.dispose();
            } else {
                this.dropCommand = copyAndAddCommand;
            }
            dummyAdd.dispose();
        } else {
            this.dropCommand = UnexecutableCommand.INSTANCE;
        }
        return this.dragCommand.canExecute() && this.dropCommand.canExecute();
    }

    protected boolean prepareDropInsert() {
        boolean result = false;
        this.feedback = (double)this.location < 0.5 ? 2 : 4;
        Object parent = this.getParent(this.owner);
        if (parent == null) {
            this.dragCommand = UnexecutableCommand.INSTANCE;
            this.dropCommand = UnexecutableCommand.INSTANCE;
        } else {
            Collection<?> children = this.getChildren(parent);
            int i = 0;
            for (Object child : children) {
                if (child.equals(this.owner)) break;
                ++i;
            }
            if ((double)this.location >= 0.5) {
                ++i;
            }
            switch (this.operation) {
                case 2: {
                    result = this.prepareDropMoveInsert(parent, children, i);
                    break;
                }
                case 1: {
                    result = this.prepareDropCopyInsert(parent, children, i);
                    break;
                }
                case 4: {
                    result = this.prepareDropLinkInsert(parent, children, i);
                }
            }
            if (!result && this.operation != 1 && this.operation != 4 && (this.operations & 1) != 0) {
                this.reset();
                result = this.prepareDropCopyInsert(parent, children, i);
                if (result) {
                    this.operation = 1;
                }
            }
            if (!result && this.operation != 4 && (this.operations & 4) != 0) {
                this.reset();
                result = this.prepareDropLinkInsert(parent, children, i);
                if (result) {
                    this.operation = 4;
                }
            }
        }
        return result;
    }

    protected boolean prepareDropLinkInsert(Object parent, Collection<?> children, int index) {
        boolean result;
        if (this.collection.contains(this.owner)) {
            this.dragCommand = IdentityCommand.INSTANCE;
            this.dropCommand = UnexecutableCommand.INSTANCE;
            result = false;
        } else {
            this.dragCommand = IdentityCommand.INSTANCE;
            this.dropCommand = AddCommand.create(this.domain, parent, null, this.collection, index);
            if (!this.analyzeForNonContainment(this.dropCommand)) {
                this.dropCommand.dispose();
                this.dropCommand = UnexecutableCommand.INSTANCE;
            }
            result = this.dropCommand.canExecute();
        }
        return result;
    }

    protected boolean prepareDropLinkOn() {
        this.dragCommand = IdentityCommand.INSTANCE;
        this.dropCommand = SetCommand.create(this.domain, this.owner, null, this.collection);
        if (!this.dropCommand.canExecute() && this.collection.size() == 1) {
            this.dropCommand.dispose();
            this.dropCommand = SetCommand.create(this.domain, this.owner, null, this.collection.iterator().next());
        }
        if (!this.dropCommand.canExecute() || !this.analyzeForNonContainment(this.dropCommand)) {
            this.dropCommand.dispose();
            this.dropCommand = AddCommand.create(this.domain, this.owner, null, this.collection);
            if (!this.analyzeForNonContainment(this.dropCommand)) {
                this.dropCommand.dispose();
                this.dropCommand = UnexecutableCommand.INSTANCE;
            }
        }
        boolean result = this.dropCommand.canExecute();
        return result;
    }

    protected boolean prepareDropMoveInsert(Object parent, Collection<?> children, int index) {
        if (this.collection.contains(this.owner)) {
            this.dragCommand = IdentityCommand.INSTANCE;
            this.dropCommand = UnexecutableCommand.INSTANCE;
        } else if (children.containsAll(this.collection)) {
            this.dragCommand = IdentityCommand.INSTANCE;
            ExtendedCompositeCommand compoundCommand = new ExtendedCompositeCommand();
            ArrayList before = new ArrayList();
            ArrayList after = new ArrayList();
            int j = 0;
            for (Object object : children) {
                if (this.collection.contains(object)) {
                    if (j < index) {
                        before.add(object);
                    } else if (j > index) {
                        after.add(object);
                    }
                }
                ++j;
            }
            for (Object object : before) {
                compoundCommand.add((IUndoableOperation)MoveCommand.create(this.domain, parent, null, object, index - 1));
            }
            ListIterator objects = after.listIterator(after.size());
            while (objects.hasPrevious()) {
                Object object;
                object = objects.previous();
                compoundCommand.add((IUndoableOperation)MoveCommand.create(this.domain, parent, null, object, index));
            }
            this.dropCommand = compoundCommand.getCommandList().size() == 0 ? IdentityCommand.INSTANCE : compoundCommand;
        } else if (this.isCrossModelSet()) {
            this.dragCommand = IdentityCommand.INSTANCE;
            this.dropCommand = UnexecutableCommand.INSTANCE;
        } else {
            this.dropCommand = AddCommand.create(this.domain, parent, null, this.collection, index);
            if (!this.dropCommand.canExecute() || this.analyzeForNonContainment(this.dropCommand)) {
                this.dropCommand.dispose();
                this.dropCommand = UnexecutableCommand.INSTANCE;
                this.dragCommand = IdentityCommand.INSTANCE;
            } else {
                this.dragCommand = RemoveCommand.create(this.domain, this.collection);
            }
        }
        boolean result = this.dragCommand.canExecute() && this.dropCommand.canExecute();
        return result;
    }

    protected boolean prepareDropMoveOn() {
        if (this.isCrossModelSet()) {
            this.dragCommand = IdentityCommand.INSTANCE;
            this.dropCommand = UnexecutableCommand.INSTANCE;
        } else {
            this.dropCommand = AddCommand.create(this.domain, this.owner, null, this.collection);
            if (this.analyzeForNonContainment(this.dropCommand)) {
                this.dropCommand.dispose();
                this.dropCommand = UnexecutableCommand.INSTANCE;
                this.dragCommand = IdentityCommand.INSTANCE;
            } else {
                this.dragCommand = RemoveCommand.create(this.domain, this.collection);
            }
        }
        boolean result = this.dragCommand.canExecute() && this.dropCommand.canExecute();
        return result;
    }

    protected boolean prepareDropOn() {
        boolean result = false;
        this.feedback = 1;
        switch (this.operation) {
            case 2: {
                result = this.prepareDropMoveOn();
                break;
            }
            case 1: {
                result = this.prepareDropCopyOn();
                break;
            }
            case 4: {
                result = this.prepareDropLinkOn();
            }
        }
        if (!result && this.operation != 1 && this.operation != 4 && (this.operations & 1) != 0) {
            this.reset();
            result = this.prepareDropCopyOn();
            if (result) {
                this.operation = 1;
            }
        }
        if (!result && this.operation != 4 && (this.operations & 4) != 0) {
            this.reset();
            result = this.prepareDropLinkOn();
            if (result) {
                this.operation = 4;
            }
        }
        return result;
    }

    protected void reset() {
        if (this.dragCommand != null) {
            if (this.isDragCommandExecuted && this.dragCommand.canUndo()) {
                try {
                    this.dragCommand.undo(null, null);
                }
                catch (ExecutionException e) {
                    KommaEditPlugin.getPlugin().log(new Status(4, "net.enilink.komma.edit", "Error while undoing drag command", (Throwable)e));
                }
            }
            this.dragCommand.dispose();
        }
        if (this.dropCommand != null) {
            this.dropCommand.dispose();
        }
        this.isPrepared = false;
        this.isExecutable = false;
        this.dragCommand = null;
        this.isDragCommandExecuted = false;
        this.dropCommand = null;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (domain: " + this.domain + ")");
        result.append(" (owner: " + this.owner + ")");
        result.append(" (location: " + this.location + ")");
        result.append(" (lowerLocationBound: " + this.lowerLocationBound + ")");
        result.append(" (upperLocationBound: " + this.upperLocationBound + ")");
        result.append(" (operations: " + this.operations + ")");
        result.append(" (operation: " + this.operation + ")");
        result.append(" (collection: " + this.collection + ")");
        result.append(" (feedback: " + this.feedback + ")");
        return result.toString();
    }

    @Override
    public boolean validate(Object owner, float location, int operations, int operation, Collection<?> collection) {
        if (owner != this.owner || location != this.location || location < this.lowerLocationBound || location > this.upperLocationBound || operation != this.operation || collection != this.collection) {
            this.reset();
            this.owner = owner;
            this.location = location;
            this.operations = operations;
            this.operation = operation;
            this.collection = collection;
            return this.canExecute();
        }
        return this.isExecutable;
    }

    public static class Detail {
        public float location;
        public int operation;
        public int operations;

        public Detail(float location, int operations, int operation) {
            this.location = location;
            this.operations = operations;
            this.operation = operation;
        }
    }
}

