/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.edit.command;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.enilink.komma.common.command.CommandResult;
import net.enilink.komma.common.command.ICommand;
import net.enilink.komma.core.IEntity;
import net.enilink.komma.core.IReference;
import net.enilink.komma.edit.KommaEditPlugin;
import net.enilink.komma.edit.command.AbstractOverrideableCommand;
import net.enilink.komma.edit.command.CommandParameter;
import net.enilink.komma.edit.domain.AdapterFactoryEditingDomain;
import net.enilink.komma.edit.domain.IEditingDomain;
import net.enilink.komma.em.concepts.IResource;
import net.enilink.komma.model.IModel;
import net.enilink.komma.model.IObject;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;

public class MoveCommand
extends AbstractOverrideableCommand {
    protected static final String LABEL = KommaEditPlugin.INSTANCE.getString("_UI_MoveCommand_label");
    protected static final String DESCRIPTION = KommaEditPlugin.INSTANCE.getString("_UI_MoveCommand_description");
    protected static final String DESCRIPTION_FOR_LIST = KommaEditPlugin.INSTANCE.getString("_UI_MoveCommand_description_for_list");
    protected IResource owner;
    protected IReference property;
    protected Collection<Object> ownerList;
    protected Object value;
    protected int index;
    protected int oldIndex;

    public static ICommand create(IEditingDomain domain, Object owner, Object property, Object value, int index) {
        return domain.createCommand(MoveCommand.class, new CommandParameter(owner, property, value, index));
    }

    public MoveCommand(IEditingDomain domain, IResource owner, IReference property, Object value, int index) {
        super(domain, LABEL, DESCRIPTION);
        this.owner = owner;
        this.property = property;
        this.value = value;
        this.index = index;
        this.ownerList = MoveCommand.getOwnerList(this.owner, property);
    }

    public MoveCommand(IEditingDomain domain, Collection<?> list, Object value, int index) {
        super(domain, LABEL, DESCRIPTION_FOR_LIST);
        List untypedList;
        this.value = value;
        this.index = index;
        this.ownerList = untypedList = (List)list;
    }

    public IResource getOwner() {
        return this.owner;
    }

    public IReference getProperty() {
        return this.property;
    }

    public Collection<Object> getOwnerList() {
        return this.ownerList;
    }

    public Object getValue() {
        return this.value;
    }

    public int getIndex() {
        return this.index;
    }

    public int getOldIndex() {
        return this.oldIndex;
    }

    protected boolean prepare() {
        boolean result = this.ownerList != null && this.ownerList instanceof List && this.ownerList.contains(this.value) && this.index >= 0 && this.index < this.ownerList.size() && (this.owner == null || !this.getDomain().isReadOnly((IEntity)this.owner));
        return result;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        this.oldIndex = ((List)this.ownerList).indexOf(this.value);
        ((List)this.ownerList).add(this.index, this.ownerList.remove(this.oldIndex));
        return CommandResult.newOKCommandResult(Collections.singleton(this.value));
    }

    @Override
    public Collection<?> doGetAffectedObjects() {
        return Collections.singleton(this.value);
    }

    @Override
    public Collection<?> doGetAffectedResources(Object type) {
        if (IModel.class.equals(type) && (this.owner != null || this.ownerList != null)) {
            HashSet affected = new HashSet(super.doGetAffectedResources(type));
            if (this.value instanceof IObject) {
                affected.add(((IObject)this.value).getModel());
            }
            if (this.owner instanceof IObject) {
                affected.add(((IObject)this.owner).getModel());
            }
            if (this.ownerList != null) {
                for (Object element : this.ownerList) {
                    Object object = AdapterFactoryEditingDomain.unwrap(element);
                    if (!(object instanceof IObject)) continue;
                    affected.add(((IObject)object).getModel());
                }
            }
            return affected;
        }
        return super.doGetAffectedResources(type);
    }

    @Override
    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (owner: " + this.owner + ")");
        result.append(" (property: " + this.property + ")");
        result.append(" (ownerList: " + this.ownerList + ")");
        result.append(" (value: " + this.value + ")");
        result.append(" (index: " + this.index + ")");
        result.append(" (oldIndex: " + this.oldIndex + ")");
        return result.toString();
    }
}

