/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.edit.properties;

import net.enilink.commons.iterator.IExtendedIterator;
import net.enilink.komma.common.command.ICommand;
import net.enilink.komma.common.command.IdentityCommand;
import net.enilink.komma.common.command.UnexecutableCommand;
import net.enilink.komma.core.IEntity;
import net.enilink.komma.core.IEntityManager;
import net.enilink.komma.core.ILiteral;
import net.enilink.komma.core.IReference;
import net.enilink.komma.core.IStatement;
import net.enilink.komma.core.IValue;
import net.enilink.komma.core.URI;
import net.enilink.komma.edit.properties.IEditingSupport;
import net.enilink.komma.edit.properties.IProposalSupport;
import net.enilink.komma.em.concepts.IProperty;
import net.enilink.vocab.owl.OWL;
import net.enilink.vocab.rdfs.RDFS;
import net.enilink.vocab.xmlschema.XMLSCHEMA;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class LiteralEditingSupport
implements IEditingSupport {
    @Override
    public IProposalSupport getProposalSupport(Object element) {
        return null;
    }

    @Override
    public boolean canEdit(Object element) {
        return element instanceof IStatement;
    }

    @Override
    public Object getEditorValue(Object element) {
        Object value = ((IStatement)element).getObject();
        if (value instanceof ILiteral) {
            ILiteral literal = (ILiteral)value;
            return literal.getLabel();
        }
        return value != null ? value.toString() : "";
    }

    protected boolean isAbstractType(URI literalType) {
        return OWL.TYPE_THING.equals((Object)literalType) || RDFS.TYPE_RESOURCE.equals((Object)literalType) || RDFS.TYPE_LITERAL.equals((Object)literalType) || XMLSCHEMA.TYPE_ANYSIMPLETYPE.equals((Object)literalType) || XMLSCHEMA.TYPE_ANYTYPE.equals((Object)literalType);
    }

    @Override
    public ICommand convertEditorValue(Object editorValue, IEntityManager entityManager, Object element) {
        ILiteral newLiteral;
        IStatement stmt = (IStatement)element;
        Object oldValue = stmt.getObject();
        if (editorValue instanceof ILiteral) {
            newLiteral = (ILiteral)editorValue;
        } else {
            Object result;
            URI literalType = null;
            String literalLanguage = null;
            if (oldValue instanceof ILiteral) {
                literalType = ((ILiteral)oldValue).getDatatype();
                literalLanguage = ((ILiteral)oldValue).getLanguage();
            } else {
                IExtendedIterator ranges = ((IProperty)entityManager.find(stmt.getPredicate(), IProperty.class, new Class[0])).getNamedRanges((IEntity)stmt.getSubject(), false);
                while (ranges.hasNext() && literalType == null) {
                    URI type = ((IReference)ranges.next()).getURI();
                    if (this.isAbstractType(type)) continue;
                    literalType = type;
                }
                ranges.close();
            }
            if (this.isAbstractType(literalType)) {
                literalType = null;
            }
            newLiteral = entityManager.createLiteral((String)editorValue, literalType, literalLanguage);
            if (literalType != null && (result = entityManager.toInstance((IValue)newLiteral)) instanceof ILiteral) {
                return new UnexecutableCommand((IStatus)new Status(4, "net.enilink.komma.edit", "Invalid literal value for type " + literalType));
            }
        }
        if (!newLiteral.equals(oldValue)) {
            return new IdentityCommand((Object)newLiteral);
        }
        return null;
    }
}

