/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.edit.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ComposedImage {
    protected List<Object> images;
    protected List<Size> imageSizes;

    public ComposedImage(Collection<?> images) {
        this.images = new ArrayList(images);
    }

    public boolean equals(Object that) {
        return that instanceof ComposedImage && ((ComposedImage)that).getImages().equals(this.images);
    }

    public int hashCode() {
        return this.images.hashCode();
    }

    public List<Object> getImages() {
        return this.images;
    }

    public Size getSize(Collection<? extends Size> imageSizes) {
        this.imageSizes = new ArrayList<Size>(imageSizes);
        Size result = new Size();
        for (Size size : imageSizes) {
            result.width = Math.max(result.width, size.width);
            result.height = Math.max(result.height, size.height);
        }
        return result;
    }

    public List<Point> getDrawPoints(Size size) {
        ArrayList<Point> results = new ArrayList<Point>();
        for (int i = this.imageSizes.size(); i > 0; --i) {
            Point result = new Point();
            results.add(result);
        }
        return results;
    }

    public static class Size {
        public int width;
        public int height;
    }

    public static class Point {
        public int x;
        public int y;
    }
}

