/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.edit.provider;

import com.google.inject.AbstractModule;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import java.util.Locale;
import net.enilink.composition.ClassDefiner;
import net.enilink.composition.ClassResolver;
import net.enilink.composition.CompositionModule;
import net.enilink.composition.DefaultObjectFactory;
import net.enilink.composition.ObjectFactory;
import net.enilink.composition.mappers.DefaultRoleMapper;
import net.enilink.composition.mappers.RoleMapper;
import net.enilink.composition.mappers.TypeFactory;
import net.enilink.komma.common.adapter.IAdapterFactory;
import net.enilink.komma.core.IEntityManagerFactory;
import net.enilink.komma.core.KommaModule;
import net.enilink.komma.core.URI;
import net.enilink.komma.core.URIs;

public class DynamicAdapterFactory
implements IAdapterFactory {
    public DynamicAdapterFactory(KommaModule module) {
    }

    protected Module createModule() {
        return new CompositionModule<String>(){

            protected void configure() {
                super.configure();
                this.bind((Key)new Key<ObjectFactory<String>>(){}).to((TypeLiteral)new TypeLiteral<DefaultObjectFactory<String>>(){});
                this.bind((TypeLiteral)new TypeLiteral<ClassResolver<String>>(){});
            }

            protected void initRoleMapper(RoleMapper<String> roleMapper, TypeFactory<String> typeFactory) {
            }

            @Provides
            @Singleton
            protected TypeFactory<String> provideTypeFactory() {
                return new TypeFactory<String>(){

                    public String createType(String type) {
                        return type;
                    }

                    public String toString(String type) {
                        return type;
                    }
                };
            }
        };
    }

    public Object adapt(Object object, Object type) {
        return null;
    }

    public boolean isFactoryForType(Object type) {
        return false;
    }

    protected class AdapterCompositionModule
    extends AbstractModule {
        private KommaModule module;
        private Locale locale;

        protected AdapterCompositionModule(IEntityManagerFactory factory, KommaModule module, Locale locale) {
            this.module = module;
            this.locale = locale == null ? Locale.getDefault() : locale;
        }

        @Provides
        @Singleton
        protected ClassDefiner provideClassDefiner(ClassLoader classLoader) {
            return new ClassDefiner(classLoader);
        }

        @Provides
        @Singleton
        protected RoleMapper<URI> provideRoleMapper(TypeFactory<URI> typeFactory) {
            DefaultRoleMapper roleMapper = new DefaultRoleMapper(typeFactory);
            for (KommaModule.Association e : this.module.getConcepts()) {
                if (e.getRdfType() == null) {
                    roleMapper.addConcept(e.getJavaClass());
                    continue;
                }
                roleMapper.addConcept(e.getJavaClass(), typeFactory.createType(e.getRdfType()));
            }
            for (KommaModule.Association e : this.module.getBehaviours()) {
                if (e.getRdfType() == null) {
                    roleMapper.addBehaviour(e.getJavaClass());
                    continue;
                }
                roleMapper.addBehaviour(e.getJavaClass(), typeFactory.createType(e.getRdfType()));
            }
            return roleMapper;
        }

        protected void configure() {
            this.install((Module)new CompositionModule());
            this.bind(Locale.class).toInstance((Object)this.locale);
            this.bind((Key)new Key<ObjectFactory<URI>>(){}).to((TypeLiteral)new TypeLiteral<DefaultObjectFactory<URI>>(){});
            this.bind((TypeLiteral)new TypeLiteral<ClassResolver<URI>>(){}).in(Singleton.class);
        }

        @Provides
        @Singleton
        protected TypeFactory<URI> provideTypeFactory() {
            return new TypeFactory<URI>(){

                public URI createType(String type) {
                    return URIs.createURI((String)type);
                }

                public String toString(URI type) {
                    return type.toString();
                }
            };
        }

        @Provides
        @Singleton
        protected KommaModule provideKommaModule() {
            return this.module;
        }

        @Provides
        @Singleton
        protected ClassLoader provideClassLoader() {
            return this.module.getClassLoader();
        }
    }
}

