/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.edit.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import net.enilink.komma.common.adapter.IAdapterFactory;
import net.enilink.komma.common.command.ExtendedCompositeCommand;
import net.enilink.komma.common.command.ICommand;
import net.enilink.komma.common.util.IResourceLocator;
import net.enilink.komma.core.IEntity;
import net.enilink.komma.core.IEntityManager;
import net.enilink.komma.core.IReference;
import net.enilink.komma.edit.KommaEditPlugin;
import net.enilink.komma.edit.command.SetCommand;
import net.enilink.komma.edit.domain.AdapterFactoryEditingDomain;
import net.enilink.komma.edit.domain.IEditingDomain;
import net.enilink.komma.edit.domain.IEditingDomainProvider;
import net.enilink.komma.edit.provider.AdapterFactoryItemDelegator;
import net.enilink.komma.edit.provider.IComposeableAdapterFactory;
import net.enilink.komma.edit.provider.IItemLabelProvider;
import net.enilink.komma.edit.provider.IItemPropertyDescriptor;
import net.enilink.komma.edit.provider.IItemPropertySource;
import net.enilink.komma.edit.provider.ItemPropertyDescriptorDecorator;
import net.enilink.komma.em.concepts.IProperty;
import net.enilink.komma.em.concepts.IResource;
import net.enilink.komma.em.util.KommaUtil;
import net.enilink.komma.model.IModel;
import net.enilink.komma.model.IObject;
import net.enilink.komma.model.ModelUtil;
import net.enilink.vocab.owl.DatatypeProperty;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.Status;

public class ItemPropertyDescriptor
implements IItemPropertyDescriptor,
IItemPropertyDescriptor.OverrideableCommandOwner {
    public static final Object BOOLEAN_VALUE_IMAGE = KommaEditPlugin.INSTANCE.getImage("full/obj16/BooleanValue");
    public static final Object GENERIC_VALUE_IMAGE = KommaEditPlugin.INSTANCE.getImage("full/obj16/GenericValue");
    public static final Object INTEGRAL_VALUE_IMAGE = KommaEditPlugin.INSTANCE.getImage("full/obj16/IntegralValue");
    public static final Object REAL_VALUE_IMAGE = KommaEditPlugin.INSTANCE.getImage("full/obj16/RealValue");
    public static final Object TEXT_VALUE_IMAGE = KommaEditPlugin.INSTANCE.getImage("full/obj16/TextValue");
    protected IAdapterFactory adapterFactory;
    protected IResourceLocator resourceLocator;
    protected AdapterFactoryItemDelegator itemDelegator;
    protected boolean isSettable;
    protected String displayName;
    protected String description;
    protected IReference property;
    protected IReference[] parentReferences;
    protected boolean multiLine;
    protected boolean sortChoices;
    protected String category;
    protected String[] filterFlags;
    protected Object staticImage;
    protected Object commandOwner;

    public static String getDefaultId(IReference property) {
        return property.getURI().toString();
    }

    public ItemPropertyDescriptor(IAdapterFactory adapterFactory, IResourceLocator resourceLocator, String displayName, String description, IReference property, boolean isSettable) {
        this(adapterFactory, resourceLocator, displayName, description, property, isSettable, false, false, null, null, null);
    }

    public ItemPropertyDescriptor(IAdapterFactory adapterFactory, IResourceLocator resourceLocator, String displayName, String description, IReference property, boolean isSettable, Object staticImage) {
        this(adapterFactory, resourceLocator, displayName, description, property, isSettable, false, false, staticImage, null, null);
    }

    public ItemPropertyDescriptor(IAdapterFactory adapterFactory, IResourceLocator resourceLocator, String displayName, String description, IReference property, boolean isSettable, String category, String[] filterFlags) {
        this(adapterFactory, resourceLocator, displayName, description, property, isSettable, false, false, null, category, filterFlags);
    }

    public ItemPropertyDescriptor(IAdapterFactory adapterFactory, IResourceLocator resourceLocator, String displayName, String description, IReference property, boolean isSettable, Object staticImage, String category, String[] filterFlags) {
        this(adapterFactory, resourceLocator, displayName, description, property, isSettable, false, false, staticImage, category, filterFlags);
    }

    public ItemPropertyDescriptor(IAdapterFactory adapterFactory, IResourceLocator resourceLocator, String displayName, String description, IReference property, boolean isSettable, boolean multiLine, boolean sortChoices, Object staticImage, String category, String[] filterFlags) {
        this.adapterFactory = adapterFactory;
        this.resourceLocator = resourceLocator;
        this.itemDelegator = new ItemDelegator(adapterFactory, resourceLocator);
        this.displayName = displayName;
        this.description = description;
        this.property = property;
        this.isSettable = isSettable;
        this.multiLine = multiLine;
        this.sortChoices = sortChoices;
        this.staticImage = staticImage;
        this.category = category;
        this.filterFlags = filterFlags;
    }

    public ItemPropertyDescriptor(IAdapterFactory adapterFactory, IResourceLocator resourceLocator, String displayName, String description, IReference[] parentReferences, boolean isSettable) {
        this(adapterFactory, resourceLocator, displayName, description, parentReferences, isSettable, null, null);
    }

    public ItemPropertyDescriptor(IAdapterFactory adapterFactory, IResourceLocator resourceLocator, String displayName, String description, IReference[] parentReferences, boolean isSettable, String category, String[] filterFlags) {
        this.adapterFactory = adapterFactory;
        this.resourceLocator = resourceLocator;
        this.itemDelegator = new ItemDelegator(adapterFactory, resourceLocator);
        this.displayName = displayName;
        this.description = description;
        this.parentReferences = parentReferences;
        this.isSettable = isSettable;
        this.category = category;
        this.filterFlags = filterFlags;
    }

    @Override
    public String getCategory(Object object) {
        return this.category;
    }

    @Override
    public String getDescription(Object object) {
        return this.description;
    }

    @Override
    public String getDisplayName(Object object) {
        return this.displayName;
    }

    @Override
    public String[] getFilterFlags(Object object) {
        return this.filterFlags;
    }

    @Override
    public String getId(Object object) {
        if (this.property != null) {
            return ItemPropertyDescriptor.getDefaultId(this.property);
        }
        if (this.parentReferences != null && this.parentReferences.length != 0) {
            StringBuffer result = new StringBuffer(ItemPropertyDescriptor.getDefaultId(this.parentReferences[0]));
            for (int i = 1; i < this.parentReferences.length; ++i) {
                result.append('-');
                result.append(ItemPropertyDescriptor.getDefaultId(this.parentReferences[i]));
            }
            return result.toString();
        }
        return this.displayName;
    }

    @Override
    public Object getHelpContextIds(Object object) {
        return null;
    }

    protected Collection<?> getComboBoxObjects(Object object) {
        if (object instanceof IObject) {
            IModel model = ((IObject)object).getModel();
            if (this.parentReferences != null) {
                LinkedHashSet result = new LinkedHashSet();
                for (int i = 0; i < this.parentReferences.length; ++i) {
                    this.parentReferences[i] = (IProperty)model.resolve(this.parentReferences[i]);
                    result.addAll(KommaUtil.getInstances((IEntityManager)model.getManager(), (Collection)((IProperty)this.parentReferences[i]).getNamedRanges((IEntity)((IObject)object), true).toSet()));
                }
                return result;
            }
            if (this.property != null) {
                Collection instances = KommaUtil.getInstances((IEntityManager)model.getManager(), (Collection)((IProperty)this.property).getNamedRanges((IEntity)((IResource)object), true).toSet());
                if ((Integer)((IObject)object).getApplicableCardinality(this.property).getSecond() == 1 && !instances.contains(null)) {
                    instances.add(null);
                }
                return instances;
            }
        }
        return null;
    }

    @Override
    public IItemLabelProvider getLabelProvider(Object object) {
        return this.itemDelegator;
    }

    protected Object createPropertyValueWrapper(Object object, Object propertyValue) {
        return new PropertyValueWrapper(this.adapterFactory, object, propertyValue, null);
    }

    protected Object getValue(IResource object, IReference property) {
        try {
            return object.get(property);
        }
        catch (Throwable exception) {
            return null;
        }
    }

    @Override
    public Object getPropertyValue(Object object) {
        if (this.property instanceof DatatypeProperty) {
            Object result = this.getValue((IResource)object, (IReference)((DatatypeProperty)this.property));
            if (result == null) {
                return null;
            }
            return this.createPropertyValueWrapper(object, result);
        }
        if (this.parentReferences != null) {
            for (int i = 0; i < this.parentReferences.length; ++i) {
                Object result = this.getValue((IResource)object, this.parentReferences[i]);
                if (result == null) continue;
                return this.createPropertyValueWrapper(object, result);
            }
            return "";
        }
        return this.createPropertyValueWrapper(object, this.getValue((IResource)object, this.property));
    }

    @Override
    public boolean isPropertySet(Object object) {
        if (this.parentReferences != null) {
            for (int i = 0; i < this.parentReferences.length; ++i) {
                Object value = ((IResource)object).get(this.parentReferences[i]);
                if (value == null || value instanceof Collection && ((Collection)value).isEmpty()) continue;
                return true;
            }
            return false;
        }
        Object value = ((IResource)object).get(this.property);
        return value != null && (!(value instanceof Collection) || !((Collection)value).isEmpty());
    }

    @Override
    public boolean canSetProperty(Object object) {
        if (this.isSettable) {
            IEditingDomain editingDomain = this.getEditingDomain(object);
            if (editingDomain != null) {
                return !editingDomain.isReadOnly((IEntity)object);
            }
            return true;
        }
        return false;
    }

    @Override
    public void setCommandOwner(Object commandOwner) {
        this.commandOwner = commandOwner;
    }

    @Override
    public Object getCommandOwner() {
        return this.commandOwner;
    }

    protected Object getCommandOwner(Object fallback) {
        return this.commandOwner != null ? this.commandOwner : fallback;
    }

    @Override
    public void resetPropertyValue(Object object) {
        block8: {
            IObject iObject = (IObject)object;
            IEditingDomain editingDomain = this.getEditingDomain(object);
            try {
                if (this.parentReferences != null) {
                    for (int i = 0; i < this.parentReferences.length; ++i) {
                        IReference parentReference = this.parentReferences[i];
                        if (!iObject.isPropertySet(parentReference, true)) continue;
                        if (editingDomain == null) {
                            iObject.set(this.parentReferences[i], null);
                        } else {
                            editingDomain.getCommandStack().execute(SetCommand.create(editingDomain, this.getCommandOwner(iObject), parentReference, SetCommand.UNSET_VALUE), null, null);
                        }
                        break block8;
                    }
                    break block8;
                }
                if (editingDomain == null) {
                    iObject.set(this.property, null);
                } else {
                    editingDomain.getCommandStack().execute(SetCommand.create(editingDomain, this.getCommandOwner(iObject), this.property, SetCommand.UNSET_VALUE), null, null);
                }
            }
            catch (ExecutionException e) {
                KommaEditPlugin.getPlugin().log(new Status(4, "net.enilink.komma.edit", "Error while resetting property value", (Throwable)e));
            }
        }
    }

    public IEditingDomain getEditingDomain(Object object) {
        IEditingDomain result = AdapterFactoryEditingDomain.getEditingDomainFor(object);
        if (result == null) {
            IComposeableAdapterFactory rootAdapterFactory;
            if (this.adapterFactory instanceof IEditingDomainProvider) {
                result = ((IEditingDomainProvider)this.adapterFactory).getEditingDomain();
            }
            if (result == null && this.adapterFactory instanceof IComposeableAdapterFactory && (rootAdapterFactory = ((IComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory()) instanceof IEditingDomainProvider) {
                result = ((IEditingDomainProvider)((Object)rootAdapterFactory)).getEditingDomain();
            }
        }
        return result;
    }

    @Override
    public void setPropertyValue(Object object, Object value) {
        block16: {
            IResource resource = (IResource)object;
            IEditingDomain editingDomain = this.getEditingDomain(object);
            try {
                if (this.parentReferences != null) {
                    int i;
                    ICommand removeCommand = null;
                    for (i = 0; i < this.parentReferences.length; ++i) {
                        Object oldValue = resource.get(this.parentReferences[i]);
                        if (oldValue == null) continue;
                        IProperty parentReference = (IProperty)resource.getEntityManager().find(this.parentReferences[i]);
                        if (oldValue == value) {
                            return;
                        }
                        if (parentReference.isRangeCompatible(value)) {
                            if (editingDomain == null) {
                                resource.set((IReference)parentReference, value);
                            } else {
                                editingDomain.getCommandStack().execute(SetCommand.create(editingDomain, this.getCommandOwner(resource), parentReference, value), null, null);
                            }
                            return;
                        }
                        if (editingDomain == null) {
                            resource.set((IReference)parentReference, null);
                            break;
                        }
                        removeCommand = SetCommand.create(editingDomain, this.getCommandOwner(resource), parentReference, null);
                        break;
                    }
                    for (i = 0; i < this.parentReferences.length; ++i) {
                        IProperty parentReference = (IProperty)resource.getEntityManager().find(this.parentReferences[i]);
                        if (!parentReference.isRangeCompatible(value)) continue;
                        if (editingDomain == null) {
                            resource.set(this.parentReferences[i], value);
                        } else if (removeCommand != null) {
                            ExtendedCompositeCommand compoundCommand = new ExtendedCompositeCommand(Integer.MIN_VALUE);
                            compoundCommand.add(removeCommand);
                            compoundCommand.add((IUndoableOperation)SetCommand.create(editingDomain, this.getCommandOwner(resource), parentReference, value));
                            editingDomain.getCommandStack().execute((ICommand)compoundCommand, null, null);
                        } else {
                            editingDomain.getCommandStack().execute(SetCommand.create(editingDomain, this.getCommandOwner(resource), parentReference, value), null, null);
                        }
                        break block16;
                    }
                    break block16;
                }
                if (editingDomain == null) {
                    resource.set(this.property, value);
                } else {
                    editingDomain.getCommandStack().execute(SetCommand.create(editingDomain, this.getCommandOwner(resource), this.property, value), null, null);
                }
            }
            catch (ExecutionException e) {
                KommaEditPlugin.getPlugin().log(new Status(4, "net.enilink.komma.edit", "Error while setting property value", (Throwable)e));
            }
        }
    }

    @Override
    public Object getProperty(Object object) {
        if (this.property != null) {
            return this.property;
        }
        if (this.parentReferences != null) {
            return this.parentReferences;
        }
        return null;
    }

    @Override
    public boolean isMany(Object object) {
        return this.parentReferences == null && this.property != null && object instanceof IResource && (Integer)((IResource)object).getApplicableCardinality(this.property).getSecond() > 1;
    }

    @Override
    public Collection<?> getChoiceOfValues(Object object) {
        return this.getComboBoxObjects(object);
    }

    @Override
    public boolean isMultiLine(Object object) {
        return this.multiLine;
    }

    @Override
    public boolean isSortChoices(Object object) {
        return this.sortChoices;
    }

    public static class PropertyValueWrapper
    implements IItemLabelProvider,
    IItemPropertySource {
        protected Object object;
        protected Object propertyValue;
        protected Object nestedPropertySource;
        protected AdapterFactoryItemDelegator itemDelegator;

        public PropertyValueWrapper(IAdapterFactory adapterFactory, Object object, Object propertyValue, Object nestedPropertySource) {
            this.object = object;
            this.propertyValue = propertyValue;
            this.nestedPropertySource = nestedPropertySource;
            this.itemDelegator = new AdapterFactoryItemDelegator(adapterFactory);
        }

        @Override
        public String getText(Object thisObject) {
            return this.itemDelegator.getText(this.propertyValue);
        }

        @Override
        public Object getImage(Object thisObject) {
            return this.itemDelegator.getImage(this.propertyValue);
        }

        @Override
        public List<IItemPropertyDescriptor> getPropertyDescriptors(Object thisObject) {
            List<IItemPropertyDescriptor> list;
            if (this.nestedPropertySource != null && (list = this.itemDelegator.getPropertyDescriptors(this.nestedPropertySource)) != null) {
                ArrayList<IItemPropertyDescriptor> result = new ArrayList<IItemPropertyDescriptor>(list.size());
                for (IItemPropertyDescriptor itemPropertyDescriptor : list) {
                    result.add(this.createPropertyDescriptorDecorator(this.nestedPropertySource, itemPropertyDescriptor));
                }
                return result;
            }
            return Collections.emptyList();
        }

        @Override
        public IItemPropertyDescriptor getPropertyDescriptor(Object thisObject, Object propertyId) {
            return this.createPropertyDescriptorDecorator(this.nestedPropertySource, this.itemDelegator.getPropertyDescriptor(this.nestedPropertySource, propertyId));
        }

        @Override
        public Object getEditableValue(Object thisObject) {
            return this.propertyValue;
        }

        protected IItemPropertyDescriptor createPropertyDescriptorDecorator(Object object, IItemPropertyDescriptor itemPropertyDescriptor) {
            return new ItemPropertyDescriptorDecorator(object, itemPropertyDescriptor);
        }
    }

    protected class ItemDelegator
    extends AdapterFactoryItemDelegator {
        protected IResourceLocator resourceLocator;

        public ItemDelegator(IAdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public ItemDelegator(IAdapterFactory adapterFactory, IResourceLocator resourceLocator) {
            super(adapterFactory);
            this.resourceLocator = resourceLocator;
        }

        @Override
        public String getText(Object object) {
            if (ItemPropertyDescriptor.this.property instanceof DatatypeProperty) {
                if (ItemPropertyDescriptor.this.isMany(object)) {
                    if (object instanceof Collection) {
                        StringBuffer result = new StringBuffer();
                        Iterator i = ((Collection)object).iterator();
                        while (i.hasNext()) {
                            Object value = i.next();
                            result.append(ModelUtil.getLabel(value));
                            if (!i.hasNext()) continue;
                            result.append(", ");
                        }
                        return result.toString();
                    }
                } else {
                    return ModelUtil.getLabel((Object)object);
                }
            }
            return super.getText(object);
        }

        protected String crop(String text) {
            if (text != null) {
                char[] chars = text.toCharArray();
                for (int i = 0; i < chars.length; ++i) {
                    if (!Character.isISOControl(chars[i])) continue;
                    return text.substring(0, i) + "...";
                }
            }
            return text;
        }

        @Override
        public Object getImage(Object object) {
            return ItemPropertyDescriptor.this.staticImage == null ? super.getImage(object) : ItemPropertyDescriptor.this.staticImage;
        }
    }
}

