/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.edit.provider;

import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import net.enilink.komma.common.adapter.IAdapter;
import net.enilink.komma.common.adapter.IAdapterFactory;
import net.enilink.komma.common.command.AbortExecutionException;
import net.enilink.komma.common.command.CommandResult;
import net.enilink.komma.common.command.CommandWrapper;
import net.enilink.komma.common.command.CompositeCommand;
import net.enilink.komma.common.command.ExtendedCompositeCommand;
import net.enilink.komma.common.command.ICommand;
import net.enilink.komma.common.command.IdentityCommand;
import net.enilink.komma.common.command.UnexecutableCommand;
import net.enilink.komma.common.notify.INotification;
import net.enilink.komma.common.notify.INotificationBroadcaster;
import net.enilink.komma.common.notify.INotificationListener;
import net.enilink.komma.common.notify.IPropertyNotification;
import net.enilink.komma.common.notify.NotificationFilter;
import net.enilink.komma.common.notify.NotificationSupport;
import net.enilink.komma.common.util.ExtensibleList;
import net.enilink.komma.common.util.ICollector;
import net.enilink.komma.common.util.IList;
import net.enilink.komma.common.util.IResourceLocator;
import net.enilink.komma.core.IEntity;
import net.enilink.komma.core.IReference;
import net.enilink.komma.core.URI;
import net.enilink.komma.core.URIs;
import net.enilink.komma.edit.KommaEditPlugin;
import net.enilink.komma.edit.command.AddCommand;
import net.enilink.komma.edit.command.CommandParameter;
import net.enilink.komma.edit.command.CopyCommand;
import net.enilink.komma.edit.command.CreateChildCommand;
import net.enilink.komma.edit.command.CreateCopyCommand;
import net.enilink.komma.edit.command.DragAndDropCommand;
import net.enilink.komma.edit.command.ICommandActionDelegate;
import net.enilink.komma.edit.command.IInputCallback;
import net.enilink.komma.edit.command.InitializeCopyCommand;
import net.enilink.komma.edit.command.MoveCommand;
import net.enilink.komma.edit.command.RemoveCommand;
import net.enilink.komma.edit.command.ReplaceCommand;
import net.enilink.komma.edit.command.SetCommand;
import net.enilink.komma.edit.domain.IEditingDomain;
import net.enilink.komma.edit.provider.DelegatingWrapperItemProvider;
import net.enilink.komma.edit.provider.Disposable;
import net.enilink.komma.edit.provider.IChildCreationExtender;
import net.enilink.komma.edit.provider.IComposeableAdapterFactory;
import net.enilink.komma.edit.provider.IDisposable;
import net.enilink.komma.edit.provider.IEditingDomainItemProvider;
import net.enilink.komma.edit.provider.IItemLabelProvider;
import net.enilink.komma.edit.provider.IItemPropertyDescriptor;
import net.enilink.komma.edit.provider.ITreeItemContentProvider;
import net.enilink.komma.edit.provider.IViewerNotification;
import net.enilink.komma.edit.provider.IWrapperItemProvider;
import net.enilink.komma.edit.provider.ItemPropertyDescriptor;
import net.enilink.komma.edit.provider.LiteralValueWrapperItemProvider;
import net.enilink.komma.em.concepts.IClass;
import net.enilink.komma.em.concepts.IProperty;
import net.enilink.komma.em.concepts.IResource;
import net.enilink.komma.model.IModel;
import net.enilink.komma.model.IModelAware;
import net.enilink.komma.model.IModelSet;
import net.enilink.komma.model.IObject;
import net.enilink.komma.model.ModelUtil;
import net.enilink.komma.model.event.IStatementNotification;
import net.enilink.vocab.owl.DatatypeProperty;
import net.enilink.vocab.owl.OWL;
import net.enilink.vocab.rdfs.Class;
import net.enilink.vocab.rdfs.RDFS;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;

public class ItemProviderAdapter
extends NotificationSupport<IViewerNotification>
implements IDisposable,
CreateChildCommand.IHelper,
IResourceLocator,
IAdapter,
INotificationListener<INotification> {
    protected IAdapterFactory adapterFactory;
    protected Set<IProperty> childrenProperties;
    protected Map<Object, ChildrenStore> childrenStoreMap;
    protected List<IItemPropertyDescriptor> itemPropertyDescriptors;
    protected volatile Set<IModelSet> trackedModelSets = Collections.synchronizedSet(new HashSet());
    protected volatile Map<IReference, IEntity> targets;
    protected Disposable wrappers;
    protected Boolean wrappingNeeded;

    public ItemProviderAdapter(IAdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTarget(Object target) {
        IModelSet modelSet;
        if (!(target instanceof IEntity)) {
            return;
        }
        if (this.targets == null) {
            ItemProviderAdapter itemProviderAdapter = this;
            synchronized (itemProviderAdapter) {
                if (this.targets == null) {
                    this.targets = Collections.synchronizedMap(new WeakHashMap());
                }
            }
        }
        this.targets.put(((IEntity)target).getReference(), (IEntity)target);
        if (target instanceof IModelAware && this.trackedModelSets.add(modelSet = ((IModelAware)target).getModel().getModelSet())) {
            modelSet.addListener((INotificationListener)this);
        }
    }

    protected void adjustWrapperIndex(Object object, int increment) {
        IWrapperItemProvider wrapper;
        int index;
        if (object instanceof IWrapperItemProvider && (index = (wrapper = (IWrapperItemProvider)object).getIndex()) != -1) {
            wrapper.setIndex(index + increment);
        }
    }

    protected void adjustWrapperIndices(List<Object> objects, int from, int increment) {
        ListIterator<Object> i = objects.listIterator(from);
        while (i.hasNext()) {
            this.adjustWrapperIndex(i.next(), increment);
        }
    }

    protected void adjustWrapperIndices(List<Object> objects, int from, int to, int increment) {
        ListIterator<Object> i = objects.listIterator(from);
        while (from < to && i.hasNext()) {
            this.adjustWrapperIndex(i.next(), increment);
            ++from;
        }
    }

    protected void collectChildrenProperties(Object object, Collection<IProperty> childrenProperties) {
        if (object instanceof IResource) {
            childrenProperties.addAll(((IResource)object).getApplicableChildProperties().toSet());
        }
    }

    protected void collectNewChildDescriptors(ICollector<Object> newChildDescriptors, Object object) {
        this.collectNewChildDescriptors(newChildDescriptors, object, false);
    }

    protected void collectNewChildDescriptors(ICollector<Object> newChildDescriptors, Object object, boolean includeOnlyDirectClasses) {
        if (object instanceof IResource) {
            for (IProperty property : ((IResource)object).getApplicableChildProperties()) {
                if (newChildDescriptors.cancelled()) {
                    return;
                }
                if ((Integer)((IResource)object).getApplicableCardinality((IReference)property).getSecond() <= 0) continue;
                HashSet ranges = new HashSet(property.getNamedRanges((IEntity)((IResource)object), includeOnlyDirectClasses).toList());
                IClass[] rangeArray = ranges.toArray(new IClass[ranges.size()]);
                Arrays.sort(rangeArray, new Comparator<IClass>(){

                    @Override
                    public int compare(IClass c1, IClass c2) {
                        String label1 = ModelUtil.getLabel((Object)c1);
                        String label2 = ModelUtil.getLabel((Object)c2);
                        if (label1 == null) {
                            if (label2 == null) {
                                return 0;
                            }
                            return 1;
                        }
                        if (label2 == null) {
                            return -1;
                        }
                        return label1.compareTo(label2);
                    }
                });
                for (IClass rangeClass : rangeArray) {
                    newChildDescriptors.add((Object)this.createChildParameter(property, new ChildDescriptor(Arrays.asList(rangeClass), this.childRequiresName((IResource)object, (IReference)property, (Class)rangeClass))));
                }
            }
        }
    }

    protected boolean childRequiresName(IResource subject, IReference property, Class rangeClass) {
        return false;
    }

    protected ICommand createAddCommand(IEditingDomain domain, IResource owner, IReference property, Collection<?> collection, int index) {
        return new AddCommand(domain, owner, property, collection, index);
    }

    @Override
    public Object createChild(Object owner, Object property, Object childDescription, IAdaptable info) {
        IInputCallback input;
        IClass firstType;
        URI parentType;
        ChildDescriptor childDescriptor = (ChildDescriptor)childDescription;
        Collection childTypes = (Collection)childDescriptor.getValue();
        IModel model = owner instanceof IModel ? (IModel)owner : ((IObject)owner).getModel();
        Object object = parentType = childTypes.isEmpty() ? OWL.TYPE_THING : null;
        if (parentType == null && childTypes.size() == 1 && (firstType = (IClass)model.getManager().find((IReference)childTypes.iterator().next(), IClass.class, new java.lang.Class[0])).isAbstract()) {
            parentType = firstType.getURI();
        }
        URI name = null;
        boolean requiresName = childDescriptor.requiresName();
        if ((requiresName || parentType != null) && (input = (IInputCallback)info.getAdapter(IInputCallback.class)) != null) {
            URI nameInput = URIs.createURI((String)"input:name");
            URI typeInput = URIs.createURI((String)"input:type");
            if (requiresName) {
                input.require(nameInput, new Object[0]);
            }
            if (parentType != null) {
                input.require(typeInput, parentType);
            }
            if (input.ask(model)) {
                if (requiresName) {
                    name = (URI)input.get(nameInput);
                }
                if (parentType != null) {
                    childTypes = (Collection)input.get(typeInput);
                }
            } else {
                throw new AbortExecutionException();
            }
        }
        if (name == null) {
            name = model.getURI().appendLocalPart("entity_" + UUID.randomUUID().toString());
        }
        return model.getManager().createNamed(name, childTypes.toArray(new IReference[childTypes.size()]));
    }

    protected CommandParameter createChildParameter(Object property, Object childDescription) {
        return new CommandParameter(null, property, childDescription);
    }

    protected ChildrenStore createChildrenStore(Object object) {
        ChildrenStore store = null;
        if (this.isWrappingNeeded(object)) {
            if (this.childrenStoreMap == null) {
                this.childrenStoreMap = new HashMap<Object, ChildrenStore>();
            }
            store = new ChildrenStore((IResource)object, this.getChildrenProperties(object));
            this.childrenStoreMap.put(object, store);
        }
        return store;
    }

    public ICommand createCommand(Object object, IEditingDomain domain, java.lang.Class<? extends ICommand> commandClass, CommandParameter commandParameter) {
        CommandParameter oldCommandParameter = commandParameter;
        commandParameter = this.unwrapCommandValues(commandParameter, commandClass);
        UnexecutableCommand result = UnexecutableCommand.INSTANCE;
        if (commandClass == SetCommand.class) {
            result = this.createSetCommand(domain, commandParameter.getOwnerResource(), commandParameter.getProperty() != null ? (IReference)commandParameter.getProperty() : this.getSetProperty(commandParameter.getOwner(), commandParameter.getValue()), commandParameter.getValue(), commandParameter.getIndex());
        } else if (commandClass == CopyCommand.class) {
            result = this.createCopyCommand(domain, commandParameter.getOwnerResource(), (CopyCommand.Helper)commandParameter.getValue());
        } else if (commandClass == CreateCopyCommand.class) {
            result = this.createCreateCopyCommand(domain, commandParameter.getOwnerResource(), (CopyCommand.Helper)commandParameter.getValue());
        } else if (commandClass == InitializeCopyCommand.class) {
            result = this.createInitializeCopyCommand(domain, commandParameter.getOwnerResource(), (CopyCommand.Helper)commandParameter.getValue());
        } else if (commandClass == RemoveCommand.class) {
            result = commandParameter.getProperty() != null ? this.createRemoveCommand(domain, commandParameter.getOwnerResource(), (IReference)((IProperty)commandParameter.getProperty()), commandParameter.getCollection()) : this.factorRemoveCommand(domain, commandParameter);
        } else if (commandClass == AddCommand.class) {
            result = commandParameter.getProperty() != null ? this.createAddCommand(domain, commandParameter.getOwnerResource(), (IReference)((IProperty)commandParameter.getProperty()), commandParameter.getCollection(), commandParameter.getIndex()) : this.factorAddCommand(domain, commandParameter);
        } else if (commandClass == MoveCommand.class) {
            result = commandParameter.getProperty() != null ? this.createMoveCommand(domain, commandParameter.getOwnerResource(), (IReference)((IProperty)commandParameter.getProperty()), commandParameter.getValue(), commandParameter.getIndex()) : this.factorMoveCommand(domain, commandParameter);
        } else if (commandClass == ReplaceCommand.class) {
            result = this.createReplaceCommand(domain, commandParameter.getOwnerResource(), (IReference)((IProperty)commandParameter.getProperty()), (IResource)commandParameter.getValue(), commandParameter.getCollection());
        } else if (commandClass == DragAndDropCommand.class) {
            DragAndDropCommand.Detail detail = (DragAndDropCommand.Detail)commandParameter.getProperty();
            result = this.createDragAndDropCommand(domain, commandParameter.getOwner(), detail.location, detail.operations, detail.operation, commandParameter.getCollection());
        } else if (commandClass == CreateChildCommand.class) {
            CommandParameter newChildParameter = (CommandParameter)commandParameter.getValue();
            result = this.createCreateChildCommand(domain, commandParameter.getOwnerResource(), (IReference)newChildParameter.getProperty(), newChildParameter.getValue(), newChildParameter.getIndex(), commandParameter.getCollection());
        }
        return this.wrapCommand((ICommand)result, object, commandClass, commandParameter, oldCommandParameter);
    }

    protected ICommand createCopyCommand(IEditingDomain domain, IResource owner, CopyCommand.Helper helper) {
        return new CopyCommand(domain, owner, helper);
    }

    protected ICommand createCreateChildCommand(IEditingDomain domain, IResource owner, IReference property, Object value, int index, Collection<?> collection) {
        return new CreateChildCommand(domain, owner, property, value, index, collection, this);
    }

    protected ICommand createCreateCopyCommand(IEditingDomain domain, IResource owner, CopyCommand.Helper helper) {
        return new CreateCopyCommand(domain, owner, helper);
    }

    protected ICommand createDragAndDropCommand(IEditingDomain domain, Object owner, float location, int operations, int operation, Collection<?> collection) {
        return new DragAndDropCommand(domain, owner, location, operations, operation, collection);
    }

    protected ICommand createInitializeCopyCommand(IEditingDomain domain, IResource owner, CopyCommand.Helper helper) {
        return new InitializeCopyCommand(domain, owner, helper);
    }

    protected ItemPropertyDescriptor createItemPropertyDescriptor(IAdapterFactory adapterFactory, IResourceLocator resourceLocator, String displayName, String description, IReference property, boolean isSettable, boolean multiLine, boolean sortChoices, Object staticImage, String category, String[] filterFlags) {
        return new ItemPropertyDescriptor(adapterFactory, resourceLocator, displayName, description, property, isSettable, multiLine, sortChoices, staticImage, category, filterFlags);
    }

    protected ICommand createMoveCommand(IEditingDomain domain, IResource owner, IReference feature, Object value, int index) {
        return new MoveCommand(domain, owner, feature, value, index);
    }

    protected ICommand createRemoveCommand(IEditingDomain domain, IResource owner, IReference feature, Collection<?> collection) {
        return new RemoveCommand(domain, owner, feature, collection);
    }

    protected ICommand createReplaceCommand(IEditingDomain domain, IResource owner, IReference feature, IResource value, Collection<?> collection) {
        return new ReplaceCommand(domain, owner, feature, (Object)value, collection);
    }

    protected ICommand createSetCommand(IEditingDomain domain, IResource owner, IReference feature, Object value) {
        return new SetCommand(domain, owner, feature, value);
    }

    protected ICommand createSetCommand(IEditingDomain domain, IResource owner, IReference feature, Object value, int index) {
        if (index == -1) {
            return this.createSetCommand(domain, owner, feature, value);
        }
        return new SetCommand(domain, owner, feature, value, index);
    }

    protected Object createWrapper(IResource object, IProperty property, Object value, int index) {
        if (!this.isWrappingNeeded(object)) {
            return value;
        }
        if (property instanceof DatatypeProperty) {
            value = new LiteralValueWrapperItemProvider(value, (IEntity)object, (IReference)property, index, this.getRootAdapterFactory(), this.getResourceLocator());
        } else if (!property.isContainment()) {
            value = new DelegatingWrapperItemProvider(value, object, (IReference)property, index, this.getRootAdapterFactory());
        }
        return value;
    }

    public String crop(String text) {
        if (text != null) {
            char[] chars = text.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                if (!Character.isISOControl(chars[i])) continue;
                return text.substring(0, i) + "...";
            }
        }
        return text;
    }

    @Override
    public void dispose() {
        Map<IReference, IEntity> oldTargets = this.targets;
        this.targets = null;
        if (oldTargets != null) {
            for (IEntity otherTarget : oldTargets.values()) {
                if (!(otherTarget instanceof IModelAware)) continue;
                for (IModelSet modelSet : new ArrayList<IModelSet>(this.trackedModelSets)) {
                    modelSet.removeListener((INotificationListener)this);
                }
            }
        }
        if (this.wrappers != null) {
            this.wrappers.dispose();
        }
    }

    protected void disposeWrapper(Object object) {
        if (object instanceof IWrapperItemProvider) {
            ((IWrapperItemProvider)object).dispose();
            if (this.wrappers != null) {
                this.wrappers.remove(object);
            }
        }
    }

    protected void disposeWrappers(List<?> objects) {
        for (Object object : objects) {
            this.disposeWrapper(object);
        }
    }

    protected ICommand factorAddCommand(IEditingDomain domain, CommandParameter commandParameter) {
        ListIterator children;
        Object firstChild;
        IProperty childProperty;
        if (commandParameter.getCollection() == null || commandParameter.getCollection().isEmpty()) {
            return UnexecutableCommand.INSTANCE;
        }
        final IResource object = commandParameter.getOwnerResource();
        ArrayList list = new ArrayList(commandParameter.getCollection());
        int index = commandParameter.getIndex();
        CompositeCommand addCommand = new CompositeCommand();
        while (!list.isEmpty() && (childProperty = this.getChildProperty(object, firstChild = (children = list.listIterator()).next())) != null) {
            if (childProperty.isMany((IReference)object)) {
                if (index != -1) {
                    for (IProperty iProperty : this.getChildrenProperties(object)) {
                        if (iProperty.equals(childProperty)) break;
                        if (iProperty.isMany((IReference)object)) {
                            Collection values = (Collection)object.get((IReference)iProperty);
                            if (values == null) continue;
                            index -= values.size();
                            continue;
                        }
                        if (object.get((IReference)iProperty) == null) continue;
                        --index;
                    }
                    if (index < 0) break;
                }
                ArrayList childrenOfThisProperty = new ArrayList();
                childrenOfThisProperty.add(firstChild);
                children.remove();
                while (children.hasNext()) {
                    Object e = children.next();
                    if (this.getChildProperty(object, e) != childProperty) continue;
                    childrenOfThisProperty.add(e);
                    children.remove();
                }
                addCommand.add((IUndoableOperation)this.createAddCommand(domain, object, (IReference)childProperty, childrenOfThisProperty, index));
                if (index >= childrenOfThisProperty.size()) {
                    index -= childrenOfThisProperty.size();
                    continue;
                }
                index = -1;
                continue;
            }
            if (object.get((IReference)childProperty) != null) break;
            ICommand setCommand = this.createSetCommand(domain, object, (IReference)childProperty, firstChild);
            addCommand.add((IUndoableOperation)new CommandWrapper(setCommand){
                protected Collection<?> affected;

                protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                    CommandResult result = super.doExecuteWithResult(progressMonitor, info);
                    this.affected = Collections.singleton(firstChild);
                    return result;
                }

                protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                    CommandResult result = super.doRedoWithResult(progressMonitor, info);
                    this.affected = Collections.singleton(firstChild);
                    return result;
                }

                protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                    CommandResult result = super.doUndoWithResult(progressMonitor, info);
                    this.affected = Collections.singleton(object);
                    return result;
                }

                public Collection<?> getAffectedObjects() {
                    return this.affected;
                }
            });
            children.remove();
        }
        if (list.isEmpty()) {
            return addCommand.reduce();
        }
        addCommand.dispose();
        return UnexecutableCommand.INSTANCE;
    }

    protected ICommand factorMoveCommand(IEditingDomain domain, CommandParameter commandParameter) {
        IResource object = commandParameter.getOwnerResource();
        Object value = commandParameter.getValue();
        int index = commandParameter.getIndex();
        IProperty childProperty = this.getChildProperty(object, value);
        if (childProperty != null && childProperty.isMany((IReference)object)) {
            for (IProperty iProperty : this.getChildrenProperties(object)) {
                if (iProperty.equals(childProperty)) break;
                if (iProperty.isMany((IReference)object)) {
                    Collection values = (Collection)object.get((IReference)iProperty);
                    if (values == null) continue;
                    index -= values.size();
                    continue;
                }
                if (object.get((IReference)iProperty) == null) continue;
                --index;
            }
            return this.createMoveCommand(domain, object, (IReference)childProperty, value, index);
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected ICommand factorRemoveCommand(IEditingDomain domain, CommandParameter commandParameter) {
        if (commandParameter.getCollection() == null || commandParameter.getCollection().isEmpty()) {
            return UnexecutableCommand.INSTANCE;
        }
        final IResource object = commandParameter.getOwnerResource();
        ArrayList list = new ArrayList(commandParameter.getCollection());
        if (object == null) {
            return IdentityCommand.INSTANCE;
        }
        if (list.size() == 1 && object != null && object.equals(list.get(0))) {
            return IdentityCommand.INSTANCE;
        }
        CompositeCommand removeCommand = new CompositeCommand();
        block0: for (IReference iReference : this.getChildrenProperties(object)) {
            Object value;
            IProperty resolvedProperty = (IProperty)object.getEntityManager().find(iReference);
            if (resolvedProperty.isMany((IReference)object)) {
                value = (Collection)this.getPropertyValue(object, (IReference)resolvedProperty);
                ArrayList childrenOfThisProperty = new ArrayList();
                ListIterator objects = list.listIterator();
                while (objects.hasNext()) {
                    Object o = objects.next();
                    if (!value.contains(o)) continue;
                    childrenOfThisProperty.add(o);
                    objects.remove();
                }
                if (childrenOfThisProperty.isEmpty()) continue;
                removeCommand.add((IUndoableOperation)this.createRemoveCommand(domain, object, iReference, childrenOfThisProperty));
                continue;
            }
            value = this.getPropertyValue(object, iReference);
            ListIterator objects = list.listIterator();
            while (objects.hasNext()) {
                Object o = objects.next();
                if (!o.equals(value)) continue;
                ICommand setCommand = this.createSetCommand(domain, object, iReference, null);
                removeCommand.add((IUndoableOperation)new CommandWrapper(setCommand){
                    protected Collection<?> affected;

                    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                        CommandResult result = super.doExecuteWithResult(progressMonitor, info);
                        this.affected = Collections.singleton(object);
                        return result;
                    }

                    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                        CommandResult result = super.doRedoWithResult(progressMonitor, info);
                        this.affected = Collections.singleton(object);
                        return result;
                    }

                    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                        CommandResult result = super.doUndoWithResult(progressMonitor, info);
                        this.affected = Collections.singleton(value);
                        return result;
                    }

                    public Collection<?> getAffectedObjects() {
                        return this.affected;
                    }
                });
                objects.remove();
                continue block0;
            }
        }
        if (list.isEmpty()) {
            return removeCommand.reduce();
        }
        removeCommand.dispose();
        return UnexecutableCommand.INSTANCE;
    }

    public void fireNotifications(Collection<? extends IViewerNotification> notifications) {
        super.fireNotifications(notifications);
        if (this.adapterFactory instanceof INotificationBroadcaster) {
            ((INotificationBroadcaster)this.adapterFactory).fireNotifications(notifications);
        }
    }

    public IAdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public Object getBackground(Object object) {
        return null;
    }

    public Object getBackground(Object object, int columnIndex) {
        return null;
    }

    public URL getBaseURL() {
        return this.getResourceLocator().getBaseURL();
    }

    protected IProperty getChildProperty(Object object, Object child) {
        for (IProperty iProperty : this.getChildrenProperties(object)) {
            int maxCard = (Integer)((IResource)object).getApplicableCardinality((IReference)iProperty).getSecond();
            if (maxCard <= 0 || !this.isValidValue(object, child, (IReference)iProperty)) continue;
            return iProperty;
        }
        return null;
    }

    public Collection<?> getChildren(Object object) {
        ChildrenStore store = this.getChildrenStore(object);
        if (store != null) {
            return store.getChildren();
        }
        store = this.createChildrenStore(object);
        LinkedHashSet<Object> result = store != null ? null : new LinkedHashSet<Object>();
        IResource resource = (IResource)object;
        for (IProperty iProperty : this.getChildrenProperties(object)) {
            Object oneOrMultipleChildren = resource.get((IReference)iProperty);
            if (oneOrMultipleChildren instanceof Collection) {
                Collection children = (Collection)oneOrMultipleChildren;
                int index = 0;
                for (Object unwrappedChild : children) {
                    Object child = this.wrap(resource, iProperty, unwrappedChild, index);
                    if (store != null) {
                        store.getList(iProperty).add(child);
                    } else {
                        result.add(child);
                    }
                    ++index;
                }
                continue;
            }
            Object child = oneOrMultipleChildren;
            if (child == null) continue;
            child = this.wrap(resource, iProperty, child, -1);
            if (store != null) {
                store.setValue(iProperty, child);
                continue;
            }
            result.add(child);
        }
        return store != null ? store.getChildren() : result;
    }

    protected Collection<? extends IProperty> getChildrenProperties(Object object) {
        if (this.childrenProperties == null) {
            this.childrenProperties = new LinkedHashSet<IProperty>();
            this.collectChildrenProperties(object, this.childrenProperties);
        }
        return this.childrenProperties;
    }

    protected ChildrenStore getChildrenStore(Object object) {
        return this.childrenStoreMap == null ? null : this.childrenStoreMap.get(object);
    }

    public Object getColumnImage(Object object, int columnIndex) {
        return null;
    }

    public String getColumnText(Object object, int columnIndex) {
        return "";
    }

    @Override
    public String getCreateChildDescription(Object owner, Object property, Object child, Collection<?> selection) {
        Object selectionObject;
        IProperty resolvedProperty;
        if (child instanceof ChildDescriptor) {
            child = ((ChildDescriptor)child).getValue();
        }
        String childType = (resolvedProperty = (IProperty)((IResource)owner).getEntityManager().find((IReference)property)) instanceof DatatypeProperty ? this.getTypeText(resolvedProperty) : this.getTypeText(child);
        Object v0 = selectionObject = selection == null || selection.isEmpty() ? null : selection.iterator().next();
        if (owner.equals(selectionObject)) {
            return this.getResourceLocator().getString("_UI_CreateChild_description", new Object[]{childType, this.getPropertyText(resolvedProperty), this.getTypeText(owner)});
        }
        Object sibling = selectionObject;
        IProperty siblingProperty = this.getChildProperty(owner, sibling);
        String siblingType = siblingProperty instanceof DatatypeProperty ? this.getTypeText(siblingProperty) : this.getTypeText((Object)sibling);
        return this.getResourceLocator().getString("_UI_CreateSibling_description", new Object[]{childType, this.getPropertyText(resolvedProperty), siblingType});
    }

    @Override
    public Object getCreateChildImage(Object owner, Object feature, Object child, Collection<?> selection) {
        return KommaEditPlugin.INSTANCE.getImage("full/ctool16/CreateChild");
    }

    @Override
    public Collection<?> getCreateChildResult(Object child) {
        return Collections.singletonList(child);
    }

    @Override
    public String getCreateChildText(Object owner, Object property, Object childDescription, Collection<?> selection) {
        IProperty resolvedProperty;
        if (childDescription instanceof ChildDescriptor) {
            childDescription = ((ChildDescriptor)childDescription).getValue();
        }
        String childType = (resolvedProperty = (IProperty)((IResource)owner).getEntityManager().find((IReference)property)) instanceof DatatypeProperty ? this.getTypeText(resolvedProperty) : this.getTypeText(childDescription);
        return this.getResourceLocator().getString(property instanceof DatatypeProperty ? "_UI_CreateChild_text3" : "_UI_CreateChild_text", new Object[]{childType, this.getPropertyText(resolvedProperty), this.getTypeText(owner)});
    }

    @Override
    public String getCreateChildToolTipText(Object owner, Object feature, Object childDescription, Collection<?> selection) {
        IProperty resolvedProperty;
        if (childDescription instanceof ChildDescriptor) {
            childDescription = ((ChildDescriptor)childDescription).getValue();
        }
        String childType = (resolvedProperty = (IProperty)((IResource)owner).getEntityManager().find((IReference)feature)) instanceof DatatypeProperty ? this.getTypeText((IProperty)feature) : this.getTypeText(childDescription);
        return this.getResourceLocator().getString("_UI_CreateChild_tooltip", new Object[]{childType, this.getPropertyText(resolvedProperty), this.getTypeText(owner)});
    }

    public Object getEditableValue(Object object) {
        return object;
    }

    public Collection<?> getElements(Object object) {
        return this.getChildren(object);
    }

    public NotificationFilter<INotification> getFilter() {
        return null;
    }

    public Object getFont(Object object) {
        return null;
    }

    public Object getFont(Object object, int columnIndex) {
        return null;
    }

    public Object getForeground(Object object) {
        return null;
    }

    public Object getForeground(Object object, int columnIndex) {
        return null;
    }

    public Object getImage(Object object) {
        return null;
    }

    public Object getImage(String key) {
        return this.getResourceLocator().getImage(key);
    }

    public void getNewChildDescriptors(Object object, IEditingDomain editingDomain, Object sibling, final ICollector<Object> descriptors) {
        if (object instanceof IResource) {
            IResource resource = (IResource)object;
            final ArrayList newChildDescriptors = new ArrayList();
            this.collectNewChildDescriptors(new ICollector<Object>(){

                public void add(Iterable<Object> elements) {
                    for (Object element : elements) {
                        this.add(element);
                    }
                }

                public void add(Object element) {
                    newChildDescriptors.add(element);
                }

                public boolean cancelled() {
                    return descriptors.cancelled();
                }
            }, object);
            if (this.adapterFactory instanceof IChildCreationExtender) {
                newChildDescriptors.addAll(((IChildCreationExtender)this.adapterFactory).getNewChildDescriptors(object, editingDomain));
            }
            if (sibling != null) {
                sibling = this.unwrap(sibling);
                Collection<? extends IProperty> childrenProperties = this.getChildrenProperties(object);
                int siblingPropertyIndex = -1;
                int i = 0;
                block0: for (IProperty iProperty : childrenProperties) {
                    Object propertyValue = resource.get((IReference)iProperty);
                    if (iProperty.isMany((IReference)resource)) {
                        for (Object value : (Collection)propertyValue) {
                            if (!this.isEquivalentValue(sibling, value)) continue;
                            siblingPropertyIndex = i;
                            break block0;
                        }
                    } else if (this.isEquivalentValue(sibling, propertyValue)) {
                        siblingPropertyIndex = i;
                        break;
                    }
                    ++i;
                }
                block2: for (Object object2 : newChildDescriptors) {
                    CommandParameter parameter;
                    IProperty childProperty;
                    if (!(object2 instanceof CommandParameter) || (childProperty = (IProperty)(parameter = (CommandParameter)object2).getObjectProperty()) == null || !childProperty.isMany((IReference)resource)) continue;
                    i = 0;
                    for (Object e : (Collection)resource.get((IReference)childProperty)) {
                        if (this.isEquivalentValue(sibling, e)) {
                            parameter.index = i + 1;
                            continue block2;
                        }
                        ++i;
                    }
                    if (siblingPropertyIndex == -1) continue;
                    i = 0;
                    for (IProperty iProperty : childrenProperties) {
                        if (iProperty.equals(childProperty)) {
                            if (i <= siblingPropertyIndex) continue block2;
                            parameter.index = 0;
                            continue block2;
                        }
                        ++i;
                    }
                }
            }
            descriptors.add(newChildDescriptors);
        }
    }

    public Object getParent(Object object) {
        if (!(object instanceof IResource)) {
            return null;
        }
        return ((IResource)object).getContainer();
    }

    public IItemPropertyDescriptor getPropertyDescriptor(Object object, Object propertyId) {
        for (IItemPropertyDescriptor itemPropertyDescriptor : this.getPropertyDescriptors(object)) {
            if (!propertyId.equals(itemPropertyDescriptor.getId(object)) && !propertyId.equals(itemPropertyDescriptor.getProperty(object))) continue;
            return itemPropertyDescriptor;
        }
        return null;
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            this.itemPropertyDescriptors = new ArrayList<IItemPropertyDescriptor>();
            if (object instanceof IResource) {
                for (IProperty property : ((IResource)object).getRelevantProperties()) {
                    this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor(this.getRootAdapterFactory(), this, ModelUtil.getLabel((Object)property), "", (IReference)property, true, false, true, null, null, null));
                }
            }
        }
        return this.itemPropertyDescriptors;
    }

    protected String getPropertyText(IProperty property) {
        return ModelUtil.getLabel((Object)property);
    }

    protected Object getPropertyValue(IResource object, IReference feature) {
        return object.get(feature);
    }

    public Object getPropertyValue(Object object, String property) {
        return this.getPropertyDescriptor(object, property).getPropertyValue(object);
    }

    protected IResourceLocator getResourceLocator() {
        return KommaEditPlugin.INSTANCE;
    }

    protected IResourceLocator getResourceLocator(Object anyObject) {
        Object adapter;
        if (this.adapterFactory instanceof IComposeableAdapterFactory && (adapter = ((IComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory().adapt(anyObject, IItemLabelProvider.class)) instanceof IResourceLocator) {
            return (IResourceLocator)adapter;
        }
        return this.getResourceLocator();
    }

    protected IAdapterFactory getRootAdapterFactory() {
        if (this.adapterFactory instanceof IComposeableAdapterFactory) {
            return ((IComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory();
        }
        return this.adapterFactory;
    }

    protected Collection<? extends IReference> getSetProperties(Object object) {
        return Collections.emptyList();
    }

    protected IReference getSetProperty(Object object, Object value) {
        for (IReference iReference : this.getSetProperties(object)) {
            if (!this.isValidValue(object, value, iReference)) continue;
            return iReference;
        }
        return null;
    }

    public String getString(String key) {
        return this.getString(key, this.shouldTranslate());
    }

    public String getString(String key, boolean translate) {
        return this.getResourceLocator().getString(key, translate);
    }

    public String getString(String key, Object ... substitutions) {
        return this.getString(key, substitutions, this.shouldTranslate());
    }

    public String getString(String key, Object[] substitutions, boolean translate) {
        return this.getResourceLocator().getString(key, substitutions, translate);
    }

    protected String getString(String key, String s0) {
        return this.getString(key, s0, this.shouldTranslate());
    }

    protected String getString(String key, String s0, boolean translate) {
        IResourceLocator resourceLocator = this.getResourceLocator();
        return resourceLocator.getString(key, new Object[]{resourceLocator.getString(s0, translate)}, translate);
    }

    protected String getString(String key, String s0, String s1) {
        return this.getString(key, s0, s1, this.shouldTranslate());
    }

    protected String getString(String key, String s0, String s1, boolean translate) {
        IResourceLocator resourceLocator = this.getResourceLocator();
        return resourceLocator.getString(key, new Object[]{resourceLocator.getString(s0, translate), resourceLocator.getString(s1, translate)}, translate);
    }

    public String getText(Object object) {
        return object.toString();
    }

    protected String getTypeText(IProperty property) {
        StringBuilder rangeSb = new StringBuilder();
        for (Class rangeClass : property.getRdfsRanges()) {
            if (rangeSb.length() > 0) {
                rangeSb.append(", ");
            }
            rangeSb.append(ModelUtil.getLabel((Object)rangeClass));
        }
        return this.getString("_UI_Unknown_datatype");
    }

    protected String getTypeText(Object object) {
        if (object instanceof Collection) {
            StringBuilder typesSb = new StringBuilder();
            for (Object type : (Collection)object) {
                if (typesSb.length() > 0) {
                    typesSb.append(", ");
                }
                typesSb.append(ModelUtil.getLabel(type));
            }
            return typesSb.toString();
        }
        if (object instanceof IResource) {
            StringBuilder typesSb = new StringBuilder();
            for (IClass typeClass : ((IResource)object).getDirectNamedClasses()) {
                if (typesSb.length() > 0) {
                    typesSb.append(", ");
                }
                typesSb.append(ModelUtil.getLabel((Object)typeClass));
            }
            return typesSb.toString();
        }
        return ModelUtil.getLabel((Object)object);
    }

    public String getUpdateableText(Object object) {
        return this.getText(object);
    }

    protected Collection<? extends IWrapperItemProvider> getWrappedValues(CommandParameter commandParameter) {
        Collection<?> collection = commandParameter.getCollection();
        Object value = commandParameter.getValue();
        if (collection != null) {
            ArrayList<IWrapperItemProvider> result = new ArrayList<IWrapperItemProvider>(collection.size() + 1);
            for (Object o : collection) {
                if (!(o instanceof IWrapperItemProvider)) continue;
                result.add((IWrapperItemProvider)o);
            }
            if (value instanceof IWrapperItemProvider) {
                result.add((IWrapperItemProvider)value);
            }
            return result;
        }
        if (value instanceof IWrapperItemProvider) {
            return Collections.singletonList((IWrapperItemProvider)value);
        }
        return Collections.emptyList();
    }

    public boolean hasChildren(Object object) {
        return this.hasChildren(object, false);
    }

    protected boolean hasChildren(Object object, boolean optimized) {
        if (!optimized) {
            return !this.getChildren(object).isEmpty();
        }
        if (object instanceof IResource) {
            IResource resource = (IResource)object;
            for (IProperty iProperty : this.getChildrenProperties(object)) {
                Collection children;
                if (!(iProperty.isMany((IReference)resource) ? (children = (Collection)resource.get((IReference)iProperty)) != null && !children.isEmpty() : resource.get((IReference)iProperty) != null)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isAdapterForType(Object type) {
        return type == this.adapterFactory;
    }

    protected boolean isEquivalentValue(Object value, Object referenceValue) {
        return value.equals(referenceValue);
    }

    public boolean isPropertySet(Object object, String property) {
        return this.getPropertyDescriptor(object, property).isPropertySet(object);
    }

    protected boolean isValidValue(Object object, Object value, IReference property) {
        IProperty resolvedProperty = (IProperty)((IResource)object).getEntityManager().find(property);
        return resolvedProperty.isRangeCompatible((IResource)object, value);
    }

    protected boolean isWrappingNeeded(Object object) {
        if (this.wrappingNeeded == null) {
            this.wrappingNeeded = Boolean.FALSE;
            for (IProperty iProperty : this.getChildrenProperties(object)) {
                if (!(iProperty instanceof DatatypeProperty)) continue;
                this.wrappingNeeded = Boolean.TRUE;
            }
        }
        return this.wrappingNeeded;
    }

    public void notifyChanged(Collection<? extends INotification> notifications) {
        this.updateChildren(notifications);
    }

    protected Object overlayImage(Object object, Object image) {
        return image;
    }

    public void removeTarget(Object target) {
        ChildrenStore store;
        if (this.targets != null) {
            this.targets.remove(target);
        }
        if (this.childrenStoreMap != null && (store = this.childrenStoreMap.remove(target)) != null && this.wrappers != null) {
            for (Object child : store.getChildren()) {
                if (!this.wrappers.remove(child)) continue;
                ((IDisposable)child).dispose();
            }
        }
    }

    public void resetPropertyValue(Object object, String property) {
        this.getPropertyDescriptor(object, property).resetPropertyValue(object);
    }

    protected IEntity resolveReference(Object reference) {
        IEntity result;
        if (this.targets != null && (result = this.targets.get(reference)) != null) {
            return result;
        }
        return (IEntity)(reference instanceof IEntity ? reference : null);
    }

    public void setPropertyValue(Object object, String property, Object value) {
        this.getPropertyDescriptor(object, property).setPropertyValue(object, value);
    }

    protected boolean shouldTranslate() {
        return true;
    }

    protected Object unwrap(Object object) {
        while (object instanceof IWrapperItemProvider) {
            object = ((IWrapperItemProvider)object).getValue();
        }
        return object;
    }

    protected CommandParameter unwrapCommandValues(CommandParameter commandParameter, java.lang.Class<? extends ICommand> commandClass) {
        if (commandClass == DragAndDropCommand.class) {
            return commandParameter;
        }
        ArrayList newCollection = null;
        Collection<?> oldCollection = commandParameter.getCollection();
        if (oldCollection != null) {
            for (Object oldValue : oldCollection) {
                Object newValue = this.unwrap(oldValue);
                if (newValue != oldValue && newCollection == null) {
                    newCollection = new ArrayList(oldCollection.size());
                    for (Object o : oldCollection) {
                        if (o == oldValue) break;
                        newCollection.add(o);
                    }
                }
                if (newCollection == null) continue;
                newCollection.add(newValue);
            }
        }
        Object oldValue = commandParameter.getValue();
        Object newValue = this.unwrap(oldValue);
        if (newCollection != null || newValue != oldValue) {
            commandParameter = new CommandParameter(commandParameter.owner, commandParameter.property, newValue, newCollection, commandParameter.index);
        }
        return commandParameter;
    }

    protected void updateChildren(Collection<? extends INotification> notifications) {
        block9: for (INotification iNotification : notifications) {
            IProperty property;
            ChildrenStore childrenStore;
            if (iNotification instanceof IStatementNotification && ((IStatementNotification)iNotification).getPredicate().equals(RDFS.PROPERTY_SUBPROPERTYOF)) {
                this.childrenProperties = null;
            }
            if ((childrenStore = this.getChildrenStore(iNotification.getSubject())) == null) continue;
            if (iNotification instanceof IStatementNotification) {
                IStatementNotification stmtNotification = (IStatementNotification)iNotification;
                property = (IProperty)childrenStore.getOwner().getEntityManager().find(stmtNotification.getPredicate());
                childrenStore.getOwner().refresh((IReference)property);
                continue;
            }
            if (!(iNotification instanceof IPropertyNotification)) continue;
            IPropertyNotification propertyNotification = (IPropertyNotification)iNotification;
            property = (IProperty)childrenStore.getOwner().getEntityManager().find((IReference)propertyNotification.getProperty());
            childrenStore.getOwner().refresh((IReference)property);
            IList<Object> children = childrenStore.getList(property);
            if (children == null) continue;
            int index = propertyNotification.getPosition();
            switch (propertyNotification.getEventType()) {
                case 2: {
                    if (property.isMany((IReference)childrenStore.getOwner())) break;
                }
                case 1: {
                    Object oldChild = childrenStore.get(property, index);
                    Object newValue = propertyNotification.getNewValue();
                    if (!this.unwrap(oldChild).equals(newValue)) break;
                    if (property.isMany((IReference)childrenStore.getOwner()) && index == -1) {
                        this.disposeWrappers((List)oldChild);
                    } else {
                        this.disposeWrapper(oldChild);
                    }
                    Object newChild = newValue == null && index == -1 ? null : this.wrap(childrenStore.getOwner(), property, newValue, index);
                    childrenStore.set(property, index, newChild);
                    break;
                }
                case 3: {
                    Collection values = (Collection)childrenStore.getOwner().get((IReference)property);
                    if (children.size() == values.size()) break;
                    Object newValue = propertyNotification.getNewValue();
                    this.adjustWrapperIndices((List<Object>)children, index, 1);
                    children.add(index, this.wrap(childrenStore.getOwner(), property, newValue, index));
                    break;
                }
                case 4: {
                    Collection values = (Collection)childrenStore.getOwner().get((IReference)property);
                    if (children.size() == values.size()) break;
                    this.disposeWrapper(children.remove(index));
                    this.adjustWrapperIndices((List<Object>)children, index, -1);
                    break;
                }
                case 5: {
                    Collection values = (Collection)childrenStore.getOwner().get((IReference)property);
                    if (children.size() == values.size()) break;
                    if (propertyNotification.getOldValue() != null) {
                        throw new IllegalArgumentException("No old value expected");
                    }
                    List newValues = (List)propertyNotification.getNewValue();
                    ArrayList<Object> newChildren = new ArrayList<Object>(newValues.size());
                    int offset = 0;
                    for (Object newValue : newValues) {
                        newChildren.add(this.wrap(childrenStore.getOwner(), property, newValue, index + offset++));
                    }
                    this.adjustWrapperIndices((List<Object>)children, index, offset);
                    children.addAll(index, newChildren);
                    break;
                }
                case 6: {
                    if (index == -1) {
                        index = 0;
                    }
                    Collection values = (Collection)childrenStore.getOwner().get((IReference)property);
                    if (children.size() == values.size()) break;
                    if (propertyNotification.getNewValue() instanceof int[]) {
                        int[] indices = (int[])propertyNotification.getNewValue();
                        for (int i = indices.length - 1; i >= 0; --i) {
                            this.disposeWrapper(children.remove(indices[i]));
                            this.adjustWrapperIndices((List<Object>)children, indices[i], -1);
                        }
                        continue block9;
                    }
                    int len = ((List)propertyNotification.getOldValue()).size();
                    List sl = children.subList(index, index + len);
                    this.disposeWrappers(sl);
                    sl.clear();
                    this.adjustWrapperIndices((List<Object>)children, index, -len);
                    break;
                }
                case 7: {
                    int oldIndex = (Integer)propertyNotification.getOldValue();
                    List values = (List)childrenStore.getOwner().get((IReference)property);
                    boolean didMove = true;
                    int end = Math.max(oldIndex, index);
                    for (int i = Math.min(oldIndex, index); didMove && i <= end; ++i) {
                        didMove = this.unwrap(children.get(i)).equals(values.get(i));
                    }
                    if (didMove) break;
                    int delta = index - oldIndex;
                    if (delta < 0) {
                        this.adjustWrapperIndices((List<Object>)children, index, oldIndex, 1);
                    }
                    children.move(index, oldIndex);
                    this.adjustWrapperIndex(children.get(index), delta);
                    if (delta <= 0) continue block9;
                    this.adjustWrapperIndices((List<Object>)children, oldIndex, index, -1);
                    break;
                }
            }
        }
    }

    protected Object wrap(IResource object, IProperty property, Object value, int index) {
        Object wrapper;
        if (!property.isMany((IReference)object) && index != -1) {
            System.out.println("Bad wrap index.");
            System.out.println("  object: " + object);
            System.out.println("  property: " + property);
            System.out.println("  value: " + value);
            System.out.println("  index: " + index);
            new IllegalArgumentException("Bad wrap index.").printStackTrace();
        }
        if ((wrapper = this.createWrapper(object, property, value, index)) == null) {
            wrapper = value;
        } else if (wrapper != value) {
            if (this.wrappers == null) {
                this.wrappers = new Disposable();
            }
            this.wrappers.add(wrapper);
        }
        return wrapper;
    }

    protected ICommand wrapCommand(ICommand command, Object object, java.lang.Class<? extends ICommand> commandClass, CommandParameter commandParameter, CommandParameter oldCommandParameter) {
        if (this.isWrappingNeeded(object) && commandClass != DragAndDropCommand.class) {
            Collection<Object> oldWrappers = commandParameter != oldCommandParameter ? this.getWrappedValues(oldCommandParameter) : Collections.emptyList();
            command = command instanceof ICommandActionDelegate ? new ResultAndAffectedObjectsWrappingCommandActionDelegate((ICommandActionDelegate)command, oldWrappers) : new ResultAndAffectedObjectsWrappingCommand((ICommand)command, (Collection<? extends IWrapperItemProvider>)oldWrappers);
        }
        return command;
    }

    public class ResultAndAffectedObjectsWrappingCommandActionDelegate
    extends ResultAndAffectedObjectsWrappingCommand
    implements ICommandActionDelegate {
        ICommandActionDelegate commandActionDelegate;

        public ResultAndAffectedObjectsWrappingCommandActionDelegate(ICommandActionDelegate command) {
            super((ICommand)command);
            this.commandActionDelegate = command;
        }

        public ResultAndAffectedObjectsWrappingCommandActionDelegate(ICommandActionDelegate command, Collection<? extends IWrapperItemProvider> additionalWrappers) {
            super((ICommand)command, additionalWrappers);
            this.commandActionDelegate = command;
        }

        @Override
        public String getDescription() {
            return this.commandActionDelegate.getDescription();
        }

        @Override
        public Object getImage() {
            return this.commandActionDelegate.getImage();
        }

        @Override
        public String getText() {
            return this.commandActionDelegate.getText();
        }

        @Override
        public String getToolTipText() {
            return this.commandActionDelegate.getToolTipText();
        }
    }

    public class ResultAndAffectedObjectsWrappingCommand
    extends CommandWrapper {
        protected Collection<? extends IWrapperItemProvider> additionalWrappers;
        protected Set<Object> owners;

        public ResultAndAffectedObjectsWrappingCommand(ICommand command) {
            super(command);
        }

        public ResultAndAffectedObjectsWrappingCommand(ICommand command, Collection<? extends IWrapperItemProvider> additionalResultWrappers) {
            super(command);
            this.additionalWrappers = additionalResultWrappers;
        }

        protected void addOwners(ICommand command) {
            if (command instanceof CommandWrapper) {
                this.addOwners(((CommandWrapper)command).getCommand());
            } else if (command instanceof ExtendedCompositeCommand) {
                ExtendedCompositeCommand compoundCommand = (ExtendedCompositeCommand)command;
                List commandList = compoundCommand.getCommandList();
                int resultIndex = compoundCommand.getResultIndex();
                if (resultIndex == Integer.MAX_VALUE) {
                    for (ICommand childCommand : commandList) {
                        this.addOwners(childCommand);
                    }
                } else {
                    if (resultIndex == Integer.MIN_VALUE) {
                        resultIndex = commandList.size() - 1;
                    }
                    if (resultIndex >= 0) {
                        this.addOwners((ICommand)commandList.get(resultIndex));
                    }
                }
            } else if (command instanceof AddCommand) {
                this.owners.add(((AddCommand)command).getOwner());
            } else if (command instanceof CreateCopyCommand) {
                this.owners.add(((CreateCopyCommand)command).getOwner());
            } else if (command instanceof InitializeCopyCommand) {
                this.owners.add(((InitializeCopyCommand)command).getOwner());
            } else if (command instanceof MoveCommand) {
                this.owners.add(((MoveCommand)command).getOwner());
            } else if (command instanceof RemoveCommand) {
                this.owners.add(((RemoveCommand)command).getOwner());
            } else if (command instanceof ReplaceCommand) {
                this.owners.add(((ReplaceCommand)command).getOwner());
            } else if (command instanceof SetCommand) {
                this.owners.add(((SetCommand)command).getOwner());
            }
        }

        public Collection<?> getAffectedObjects() {
            return this.wrapValues(super.getAffectedObjects(), false);
        }

        public CommandResult getCommandResult() {
            CommandResult result = this.getCommandResult();
            if (result != null) {
                return new CommandResult(result.getStatus(), this.wrapValues(result.getReturnValue(), true));
            }
            return null;
        }

        public Collection<Object> getOwners() {
            if (this.owners == null) {
                this.owners = new LinkedHashSet<Object>();
                this.addOwners(this.getCommand());
            }
            return this.owners;
        }

        protected Collection<? extends IWrapperItemProvider> wrapValues(Object unwrappedValue, boolean useAdditionalWrappers) {
            ArrayList<Object> result;
            if (unwrappedValue instanceof Collection) {
                result = new ArrayList((Collection)unwrappedValue);
            } else {
                result = new ArrayList<Object>();
                result.add(unwrappedValue);
            }
            ArrayList<? extends IWrapperItemProvider> wrappers = new ArrayList<IWrapperItemProvider>();
            IAdapterFactory af = ItemProviderAdapter.this.adapterFactory instanceof IComposeableAdapterFactory ? ((IComposeableAdapterFactory)ItemProviderAdapter.this.adapterFactory).getRootAdapterFactory() : ItemProviderAdapter.this.adapterFactory;
            for (Object owner : this.getOwners()) {
                Collection<Object> children = Collections.EMPTY_LIST;
                Object object = af.adapt(owner, IEditingDomainItemProvider.class);
                if (object instanceof IEditingDomainItemProvider) {
                    children = ((IEditingDomainItemProvider)object).getChildren(owner);
                } else {
                    Object object2 = af.adapt(owner, ITreeItemContentProvider.class);
                    if (object2 instanceof ITreeItemContentProvider) {
                        children = ((ITreeItemContentProvider)object2).getChildren(owner);
                    }
                }
                for (Object child : children) {
                    if (!(child instanceof IWrapperItemProvider)) continue;
                    wrappers.add((IWrapperItemProvider)child);
                }
            }
            if (useAdditionalWrappers && this.additionalWrappers != null) {
                wrappers.addAll(this.additionalWrappers);
            }
            ListIterator<IWrapperItemProvider> i = result.listIterator();
            block2: while (i.hasNext()) {
                Object resultObject = i.next();
                for (IWrapperItemProvider iWrapperItemProvider : wrappers) {
                    if (!ItemProviderAdapter.this.isEquivalentValue(ItemProviderAdapter.this.unwrap(iWrapperItemProvider), resultObject)) continue;
                    i.set(iWrapperItemProvider);
                    continue block2;
                }
            }
            ArrayList<Object> collection = result;
            return collection;
        }
    }

    protected static class ModifiableSingletonEList<E>
    extends AbstractList<E>
    implements IList<E> {
        private E singleElement;

        ModifiableSingletonEList() {
            this.singleElement = null;
        }

        ModifiableSingletonEList(E element) {
            this.singleElement = element;
        }

        @Override
        public boolean contains(Object o) {
            return o == null ? this.singleElement == null : o.equals(this.singleElement);
        }

        @Override
        public E get(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException("index=" + index + ", size=1");
            }
            return this.singleElement;
        }

        public void move(int index, E o) {
            if (index != 0 || !this.contains(o)) {
                throw new IndexOutOfBoundsException("index=" + index + ", size=1");
            }
        }

        public E move(int targetIndex, int sourceIndex) {
            if (targetIndex != 0) {
                throw new IndexOutOfBoundsException("targetIndex=" + targetIndex + ", size=1");
            }
            if (sourceIndex != 0) {
                throw new IndexOutOfBoundsException("sourceIndex=" + sourceIndex + ", size=1");
            }
            return this.singleElement;
        }

        @Override
        public E set(int index, E element) {
            if (index != 0) {
                throw new IndexOutOfBoundsException("index=" + index + ", size=1");
            }
            E oldElement = this.singleElement;
            this.singleElement = element;
            return oldElement;
        }

        @Override
        public int size() {
            return 1;
        }
    }

    protected static class ChildrenStore {
        protected Map<IProperty, IList<Object>> map;
        protected IResource owner;
        protected Collection<? extends IProperty> properties;

        ChildrenStore(IResource owner, Collection<? extends IProperty> properties) {
            this.owner = owner;
            this.properties = properties;
        }

        public void clear() {
            for (Map.Entry<IProperty, IList<Object>> entry : this.map.entrySet()) {
                if (entry.getKey().isMany((IReference)this.owner)) {
                    ((List)entry.getValue()).clear();
                    continue;
                }
                ((List)entry.getValue()).set(0, null);
            }
        }

        protected IList<Object> createList(IProperty property) {
            return property.isMany((IReference)this.owner) ? new ExtensibleList() : new ModifiableSingletonEList();
        }

        public List<Object> ensureList(IProperty property) {
            IList<Object> list;
            if (this.map == null) {
                this.map = new HashMap<IProperty, IList<Object>>();
            }
            if ((list = this.map.get(property)) == null) {
                list = this.createList(property);
                this.map.put(property, list);
            }
            return list;
        }

        public Object get(IProperty property, int index) {
            if (index == -1) {
                return this.getValue(property);
            }
            IList<Object> list = this.getList(property);
            return list != null ? list.get(index) : null;
        }

        public List<Object> getChildren() {
            ArrayList<Object> result = new ArrayList<Object>();
            for (IProperty iProperty : this.properties) {
                IList<Object> children = this.getList(iProperty);
                if (children == null) continue;
                if (iProperty.isMany((IReference)this.owner)) {
                    result.addAll((Collection<Object>)children);
                    continue;
                }
                if (children.get(0) == null) continue;
                result.add(children.get(0));
            }
            return result;
        }

        public IList<Object> getList(IProperty property) {
            return this.map == null ? null : this.map.get(property);
        }

        public IResource getOwner() {
            return this.owner;
        }

        public Object getValue(IProperty property) {
            IList<Object> list = this.getList(property);
            if (property.isMany((IReference)this.owner)) {
                return list;
            }
            return list.get(0);
        }

        public boolean set(IProperty property, int index, Object object) {
            if (index == -1) {
                return this.setValue(property, object);
            }
            IList<Object> list = this.getList(property);
            if (list != null) {
                list.set(index, object);
                return true;
            }
            return false;
        }

        public boolean setValue(IProperty property, Object value) {
            if (value != null) {
                IList<Object> list = this.getList(property);
                if (property.isMany((IReference)this.owner)) {
                    if (list != null) {
                        list.clear();
                    }
                    if (value != null) {
                        this.ensureList(property).addAll((Collection)value);
                    }
                } else {
                    list.set(0, value);
                }
            }
            return true;
        }
    }

    public static class ChildDescriptor {
        protected final boolean requiresName;
        protected final Object value;

        public ChildDescriptor(Object value) {
            this(value, false);
        }

        public ChildDescriptor(Object value, boolean requiresName) {
            this.value = value;
            this.requiresName = requiresName;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean requiresName() {
            return this.requiresName;
        }
    }
}

