/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.edit.provider;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.enilink.commons.util.Pair;
import net.enilink.komma.common.notify.INotification;
import net.enilink.komma.common.notify.INotificationBroadcaster;
import net.enilink.komma.common.notify.INotificationListener;
import net.enilink.komma.common.notify.NotificationSupport;
import net.enilink.komma.common.util.IResourceLocator;
import net.enilink.komma.core.URI;
import net.enilink.komma.edit.provider.AdapterFactory;
import net.enilink.komma.edit.provider.ComposedAdapterFactory;
import net.enilink.komma.edit.provider.IComposeableAdapterFactory;
import net.enilink.komma.edit.provider.IDisposable;
import net.enilink.komma.edit.provider.IEditingDomainItemProvider;
import net.enilink.komma.edit.provider.IItemColorProvider;
import net.enilink.komma.edit.provider.IItemFontProvider;
import net.enilink.komma.edit.provider.IItemLabelProvider;
import net.enilink.komma.edit.provider.IItemPropertySource;
import net.enilink.komma.edit.provider.ISearchableItemProvider;
import net.enilink.komma.edit.provider.IStructuredItemContentProvider;
import net.enilink.komma.edit.provider.ITableItemLabelProvider;
import net.enilink.komma.edit.provider.ITreeItemContentProvider;
import net.enilink.komma.model.IModel;
import net.enilink.komma.model.IObject;

public abstract class ItemProviderAdapterFactory<T>
extends AdapterFactory
implements IComposeableAdapterFactory,
IDisposable,
INotificationBroadcaster<INotification> {
    private Set<URI> namespaceURIs;
    protected Map<Pair<IModel, Collection<? extends T>>, Object> providers = new HashMap<Pair<IModel, Collection<? extends T>>, Object>();
    protected IResourceLocator resourceLocator;
    protected NotificationSupport<INotification> notificationSupport = new NotificationSupport();
    protected ComposedAdapterFactory parentAdapterFactory;
    protected Collection<Object> supportedTypes = new ArrayList<Object>();
    @Inject
    protected Injector injector;

    public ItemProviderAdapterFactory(IResourceLocator resourceLocator, URI ... namespaceURIs) {
        this.namespaceURIs = new HashSet<URI>(Arrays.asList(namespaceURIs));
        this.resourceLocator = resourceLocator;
        this.supportedTypes.add(IEditingDomainItemProvider.class);
        this.supportedTypes.add(IStructuredItemContentProvider.class);
        this.supportedTypes.add(ITreeItemContentProvider.class);
        this.supportedTypes.add(IItemColorProvider.class);
        this.supportedTypes.add(IItemFontProvider.class);
        this.supportedTypes.add(IItemLabelProvider.class);
        this.supportedTypes.add(IItemPropertySource.class);
        this.supportedTypes.add(ITableItemLabelProvider.class);
        this.supportedTypes.add(ISearchableItemProvider.class);
    }

    @Override
    public Object adapt(Object object, Object type) {
        if (type instanceof Class && ((Class)type).isAssignableFrom(object.getClass())) {
            return object;
        }
        return this.doAdapt(object, this);
    }

    protected Object doAdapt(Object object, Object type) {
        return super.adapt(object, type);
    }

    public void addListener(INotificationListener<INotification> notificationListener) {
        this.notificationSupport.addListener(notificationListener);
    }

    @Override
    protected Object createAdapter(Object object, Object type) {
        Collection<T> types;
        Pair key = new Pair((Object)(object instanceof IObject ? ((IObject)object).getModel() : null), types = this.getTypes(object));
        Object provider = this.providers.get(key);
        if (provider == null) {
            provider = this.createItemProvider(object, types, type);
            if (provider != null && this.injector != null) {
                this.injector.injectMembers(provider);
            }
            this.providers.put(key, provider);
        }
        return provider;
    }

    protected abstract Collection<T> getTypes(Object var1);

    protected abstract Object createItemProvider(Object var1, Collection<T> var2, Object var3);

    @Override
    public void dispose() {
        for (Object provider : this.providers.values()) {
            if (!(provider instanceof IDisposable)) continue;
            ((IDisposable)provider).dispose();
        }
        this.providers.clear();
    }

    public void fireNotifications(Collection<? extends INotification> notifications) {
        this.notificationSupport.fireNotifications(notifications);
        if (this.parentAdapterFactory != null) {
            this.parentAdapterFactory.fireNotifications(notifications);
        }
    }

    @Override
    public IComposeableAdapterFactory getRootAdapterFactory() {
        return this.parentAdapterFactory == null ? this : this.parentAdapterFactory.getRootAdapterFactory();
    }

    @Override
    public boolean isFactoryForType(Object type) {
        return type instanceof URI && this.namespaceURIs.contains(type) || this.supportedTypes.contains(type) || super.isFactoryForType(type);
    }

    public void removeListener(INotificationListener<INotification> notificationListener) {
        this.notificationSupport.removeListener(notificationListener);
    }

    @Override
    public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }
}

