/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.edit.provider;

import java.util.Collections;
import java.util.List;
import net.enilink.komma.common.adapter.IAdapterFactory;
import net.enilink.komma.common.command.ICommand;
import net.enilink.komma.common.util.IResourceLocator;
import net.enilink.komma.core.IEntity;
import net.enilink.komma.core.IReference;
import net.enilink.komma.edit.command.CopyCommand;
import net.enilink.komma.edit.command.SetCommand;
import net.enilink.komma.edit.domain.IEditingDomain;
import net.enilink.komma.edit.provider.IEditingDomainItemProvider;
import net.enilink.komma.edit.provider.IItemLabelProvider;
import net.enilink.komma.edit.provider.IItemPropertyDescriptor;
import net.enilink.komma.edit.provider.IItemPropertySource;
import net.enilink.komma.edit.provider.IStructuredItemContentProvider;
import net.enilink.komma.edit.provider.ITreeItemContentProvider;
import net.enilink.komma.edit.provider.IWrapperItemProvider;
import net.enilink.komma.edit.provider.WrapperItemProvider;
import net.enilink.komma.model.IObject;
import net.enilink.komma.model.ModelUtil;

public class LiteralValueWrapperItemProvider
extends WrapperItemProvider
implements IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource,
IEditingDomainItemProvider {
    protected IResourceLocator resourceLocator;
    protected List<IItemPropertyDescriptor> propertyDescriptors;

    public LiteralValueWrapperItemProvider(Object value, IEntity owner, IReference property, IAdapterFactory adapterFactory, IResourceLocator resourceLocator) {
        super(value, owner, property, -1, adapterFactory);
        this.resourceLocator = resourceLocator;
    }

    public LiteralValueWrapperItemProvider(Object value, IEntity owner, IReference property, int index, IAdapterFactory adapterFactory, IResourceLocator resourceLocator) {
        super(value, owner, property, index, adapterFactory);
        this.resourceLocator = resourceLocator;
    }

    @Override
    public String getText(Object object) {
        return this.value != null ? ModelUtil.getLabel((Object)this.value) : "null";
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.propertyDescriptors == null) {
            this.propertyDescriptors = Collections.singletonList(new WrapperItemProvider.WrapperItemPropertyDescriptor(this, this.resourceLocator, this.property));
        }
        return this.propertyDescriptors;
    }

    @Override
    protected ICommand createSetCommand(IEditingDomain domain, Object owner, Object feature, Object value, int index) {
        return new WrapperItemProvider.ReplacementAffectedObjectCommand(this, SetCommand.create(domain, this.owner, this.property, value, this.index));
    }

    @Override
    protected ICommand createCopyCommand(IEditingDomain domain, Object owner, CopyCommand.Helper helper) {
        return new WrapperItemProvider.SimpleCopyCommand(domain){

            @Override
            public IWrapperItemProvider copy() {
                Object valueCopy = null;
                if (LiteralValueWrapperItemProvider.this.value != null) {
                    // empty if block
                }
                return new LiteralValueWrapperItemProvider(valueCopy, (IEntity)((IObject)LiteralValueWrapperItemProvider.this.owner), LiteralValueWrapperItemProvider.this.property, LiteralValueWrapperItemProvider.this.index, LiteralValueWrapperItemProvider.this.adapterFactory, LiteralValueWrapperItemProvider.this.resourceLocator);
            }
        };
    }
}

