/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.edit.provider.komma;

import java.util.Collection;
import net.enilink.komma.common.adapter.IAdapterFactory;
import net.enilink.komma.common.util.ICollector;
import net.enilink.komma.common.util.IResourceLocator;
import net.enilink.komma.core.IEntity;
import net.enilink.komma.core.IReference;
import net.enilink.komma.edit.provider.ISearchableItemProvider;
import net.enilink.komma.edit.provider.IViewerNotification;
import net.enilink.komma.edit.provider.ReflectiveItemProvider;
import net.enilink.komma.edit.provider.SparqlSearchableItemProvider;
import net.enilink.komma.edit.provider.ViewerNotification;
import net.enilink.komma.em.concepts.IOntology;
import net.enilink.komma.em.concepts.IProperty;
import net.enilink.komma.model.IObject;
import net.enilink.komma.model.event.IStatementNotification;
import net.enilink.vocab.komma.KOMMA;
import net.enilink.vocab.rdfs.RDFS;

public class KommaRootPropertyItemProvider
extends ReflectiveItemProvider {
    public KommaRootPropertyItemProvider(IAdapterFactory adapterFactory, IResourceLocator resourceLocator, Collection<? extends IReference> targetTypes) {
        super(adapterFactory, resourceLocator, targetTypes);
    }

    @Override
    protected void addViewerNotifications(Collection<IViewerNotification> viewerNotifications, IStatementNotification notification) {
        if (RDFS.PROPERTY_SUBPROPERTYOF.equals((Object)notification.getPredicate())) {
            IEntity object = this.resolveReference(notification.getObject());
            if (object != null) {
                viewerNotifications.add(new ViewerNotification(object));
            }
            return;
        }
        super.addViewerNotifications(viewerNotifications, notification);
    }

    @Override
    public Collection<?> getChildren(Object object) {
        if (object instanceof IObject && KOMMA.PROPERTY_ROOTPROPERTY.equals(object)) {
            IOntology ontology = ((IObject)object).getModel().getOntology();
            return ontology.getRootProperties().toList();
        }
        return super.getChildren(object);
    }

    @Override
    protected void collectChildrenProperties(Object object, Collection<IProperty> childrenProperties) {
    }

    @Override
    protected ISearchableItemProvider getSearchableItemProvider() {
        return new SparqlSearchableItemProvider(){

            @Override
            protected String getQueryFindPatterns(Object parent) {
                if (KOMMA.PROPERTY_ROOTPROPERTY.equals(parent)) {
                    return "?s a ?type { ?type rdfs:subClassOf rdf:Property } UNION { ?s a rdf:Property } FILTER (?type = owl:AnnotationProperty || !regex(str(?type), 'http://www.w3.org/2002/07/owl#'))";
                }
                return super.getQueryFindPatterns(parent);
            }
        };
    }

    @Override
    public boolean hasChildren(Object object) {
        return true;
    }

    @Override
    protected void collectNewChildDescriptors(ICollector<Object> newChildDescriptors, Object object) {
    }
}

