/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.edit.provider.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.enilink.komma.common.adapter.IAdapterFactory;
import net.enilink.komma.common.command.CommandResult;
import net.enilink.komma.common.command.ICommand;
import net.enilink.komma.common.command.SimpleCommand;
import net.enilink.komma.common.command.UnexecutableCommand;
import net.enilink.komma.common.util.ICollector;
import net.enilink.komma.common.util.IResourceLocator;
import net.enilink.komma.core.IEntity;
import net.enilink.komma.core.IReference;
import net.enilink.komma.core.URI;
import net.enilink.komma.core.URIs;
import net.enilink.komma.edit.KommaEditPlugin;
import net.enilink.komma.edit.command.CommandParameter;
import net.enilink.komma.edit.command.CreateChildCommand;
import net.enilink.komma.edit.command.ICommandActionDelegate;
import net.enilink.komma.edit.domain.IEditingDomain;
import net.enilink.komma.edit.provider.IEditingDomainItemProvider;
import net.enilink.komma.edit.provider.IItemLabelProvider;
import net.enilink.komma.edit.provider.IItemPropertyDescriptor;
import net.enilink.komma.edit.provider.IItemPropertySource;
import net.enilink.komma.edit.provider.IStructuredItemContentProvider;
import net.enilink.komma.edit.provider.ITreeItemContentProvider;
import net.enilink.komma.edit.provider.ItemProvider;
import net.enilink.komma.edit.provider.ItemProviderAdapter;
import net.enilink.komma.em.concepts.IClass;
import net.enilink.komma.em.concepts.IProperty;
import net.enilink.komma.model.IModel;
import net.enilink.komma.model.IModelAware;
import net.enilink.komma.model.IObject;
import net.enilink.komma.model.ModelUtil;
import net.enilink.vocab.owl.OWL;
import net.enilink.vocab.rdfs.RDFS;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;

public class ModelItemProvider
extends ItemProviderAdapter
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    static String QUERY_PROPERTIES = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX owl: <http://www.w3.org/2002/07/owl#> PREFIX komma: <http://enilink.net/vocab/komma#> SELECT DISTINCT ?r WHERE {?r a rdf:Property OPTIONAL {?r rdfs:subPropertyOf ?other FILTER(!sameTerm(?r, ?other) && isIRI(?other))} FILTER (!bound(?other) && isIRI(?r)) }";

    public ModelItemProvider(IAdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        return super.getPropertyDescriptors(object);
    }

    @Override
    public Collection<?> getChildren(Object object) {
        ArrayList<ItemProvider> children = new ArrayList<ItemProvider>();
        if (object instanceof IModel) {
            List<IObject> classes = Arrays.asList((IObject)((IModel)object).getManager().find((IReference)RDFS.TYPE_RESOURCE));
            children.add(new ItemProvider(this.getRootAdapterFactory(), "Classes", (Object)URIs.createURI((String)this.getResourceLocator().getImage("full/obj16/Classes.png").toString()), classes));
        }
        return children;
    }

    @Override
    public Object createChild(Object owner, Object property, Object childDescription, IAdaptable info) {
        return super.createChild(owner, property, childDescription, info);
    }

    @Override
    protected void collectChildrenProperties(Object object, Collection<IProperty> childrenProperties) {
    }

    @Override
    public Object getParent(Object object) {
        if (object instanceof IModel) {
            return ((IModel)object).getModelSet();
        }
        return null;
    }

    @Override
    public Object getImage(Object object) {
        URI uri = object instanceof IModel ? ((IModel)object).getURI() : ((IEntity)object).getURI();
        URI image = URIs.createURI((String)(this.getResourceLocator().getImage("full/obj16/Model").toString() + "#" + uri.fileExtension()));
        return image;
    }

    @Override
    public boolean hasChildren(Object object) {
        if (object instanceof IModel) {
            return true;
        }
        return this.hasChildren(object, false);
    }

    @Override
    public String getText(Object object) {
        return ModelUtil.getLabel((Object)object);
    }

    @Override
    protected void collectNewChildDescriptors(ICollector<Object> newChildDescriptors, Object object) {
        if (object instanceof Instances) {
            newChildDescriptors.add((Object)this.createChildParameter((IProperty)((IEntity)object).getEntityManager().find((IReference)RDFS.PROPERTY_SUBCLASSOF), new ItemProviderAdapter.ChildDescriptor(Arrays.asList((IClass)((IObject)object).getModel().resolve((IReference)OWL.TYPE_CLASS)), true)));
        }
    }

    @Override
    public IResourceLocator getResourceLocator() {
        return KommaEditPlugin.INSTANCE;
    }

    class Instances
    extends ItemProvider
    implements IEditingDomainItemProvider,
    IModelAware {
        IModel model;

        public Instances(IModel model, IAdapterFactory adapterFactory, Object image, Collection<?> children) {
            super(adapterFactory, "Instances", image, children);
            this.model = model;
        }

        @Override
        public void getNewChildDescriptors(Object object, IEditingDomain editingDomain, Object sibling, ICollector<Object> descriptors) {
            if (!(object instanceof Instances)) {
                return;
            }
            ItemProviderAdapter.ChildDescriptor childDescription = new ItemProviderAdapter.ChildDescriptor(null, true);
            descriptors.add((Object)ModelItemProvider.this.createChildParameter(null, childDescription));
        }

        @Override
        public ICommand createCommand(Object object, IEditingDomain editingDomain, Class<? extends ICommand> commandClass, CommandParameter commandParameter) {
            CommandParameter oldCommandParameter = commandParameter;
            commandParameter = ModelItemProvider.this.unwrapCommandValues(commandParameter, commandClass);
            UnexecutableCommand result = UnexecutableCommand.INSTANCE;
            if (commandClass == CreateChildCommand.class) {
                CommandParameter newChildParameter = (CommandParameter)commandParameter.getValue();
                result = this.createCreateChildCommand(editingDomain, newChildParameter.getValue());
            }
            return ModelItemProvider.this.wrapCommand((ICommand)result, object, commandClass, commandParameter, oldCommandParameter);
        }

        protected ICommand createCreateChildCommand(IEditingDomain domain, Object value) {
            return new CreateInstanceCommand(domain, value);
        }

        public IModel getModel() {
            return this.model;
        }

        class CreateInstanceCommand
        extends SimpleCommand
        implements ICommandActionDelegate {
            IEditingDomain domain;
            Object value;
            Object child;
            List<Object> affectedObjects = new ArrayList<Object>();

            public CreateInstanceCommand(IEditingDomain domain, Object value) {
                this.domain = domain;
                this.value = value;
            }

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                this.child = ModelItemProvider.this.createChild(Instances.this.getModel(), null, this.value, info);
                this.affectedObjects.add(this.child);
                Instances.this.children.add(this.child);
                return CommandResult.newOKCommandResult((Object)this.child);
            }

            protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                this.affectedObjects.add(this.child);
                Instances.this.children.add(this.child);
                return super.doRedoWithResult(progressMonitor, info);
            }

            protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                this.affectedObjects.clear();
                Instances.this.children.remove(this.child);
                return super.doUndoWithResult(progressMonitor, info);
            }

            public Collection<?> getAffectedObjects() {
                return this.affectedObjects;
            }

            @Override
            public Object getImage() {
                return null;
            }

            @Override
            public String getText() {
                return "Object";
            }

            @Override
            public String getToolTipText() {
                return "Create a new object.";
            }
        }
    }
}

