/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.edit.refactor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.enilink.komma.common.command.AbstractCommand;
import net.enilink.komma.common.command.CommandResult;
import net.enilink.komma.common.command.ICommand;
import net.enilink.komma.core.IQuery;
import net.enilink.komma.core.IReference;
import net.enilink.komma.core.IStatement;
import net.enilink.komma.core.ITransaction;
import net.enilink.komma.core.KommaException;
import net.enilink.komma.core.Statement;
import net.enilink.komma.core.URI;
import net.enilink.komma.edit.domain.AdapterFactoryEditingDomain;
import net.enilink.komma.edit.domain.IEditingDomain;
import net.enilink.komma.edit.refactor.Change;
import net.enilink.komma.em.concepts.IResource;
import net.enilink.komma.model.IModel;
import net.enilink.komma.model.IModelAware;
import net.enilink.komma.model.IModelSet;
import net.enilink.komma.model.IObject;
import net.enilink.vocab.owl.OWL;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class RefactoringProcessor {
    protected IEditingDomain domain;

    public RefactoringProcessor(IEditingDomain domain) {
        this.domain = domain;
    }

    public Collection<Change> createMoveChanges(Collection<?> elements, IModel targetModel, boolean keepNamespace) {
        LinkedHashMap<IModel, Collection<IStatement>> addMap = new LinkedHashMap<IModel, Collection<IStatement>>();
        LinkedHashMap<IModel, Collection<IStatement>> removeMap = new LinkedHashMap<IModel, Collection<IStatement>>();
        LinkedHashMap<IObject, URI> renameMap = new LinkedHashMap<IObject, URI>();
        LinkedHashSet<IModel> models = new LinkedHashSet<IModel>();
        LinkedHashSet<IObject> objects = new LinkedHashSet<IObject>();
        for (Object wrappedObject : elements) {
            Object object = AdapterFactoryEditingDomain.unwrap(wrappedObject);
            if (!(object instanceof IObject)) continue;
            models.add(((IModelAware)object).getModel());
            objects.add((IObject)object);
            LinkedList queue = new LinkedList(((IResource)object).getContents());
            while (!queue.isEmpty()) {
                IResource contentObject = (IResource)queue.remove();
                objects.add((IObject)contentObject);
                queue.addAll(contentObject.getContents());
            }
        }
        if (!keepNamespace) {
            for (IObject object : objects) {
                renameMap.put(object, targetModel.getURI().appendFragment(object.getURI().fragment()));
            }
        }
        LinkedHashSet necessaryImports = new LinkedHashSet();
        for (IModel iModel : models) {
            if (this.domain.isReadOnly(iModel)) continue;
            for (IObject object : objects) {
                IQuery subjectQuery = iModel.getManager().createQuery("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX owl: <http://www.w3.org/2002/07/owl#> PREFIX komma: <http://enilink.net/vocab/komma#> CONSTRUCT {   ?s ?p ?o} WHERE {   GRAPH ?g {     {       bind(?object as ?s)     } union {       ?object (!<a:b>|!<b:a>)+ ?s .       FILTER (isBlank(?s))     }     ?s ?p ?o .  } }", false);
                subjectQuery.setParameter("g", (Object)iModel);
                subjectQuery.setParameter("object", (Object)object);
                Collection<Object> statements = subjectQuery.evaluate(IStatement.class, new Class[0]).toList();
                statements = this.filterCBD(statements, (IReference)object);
                this.addToMap(removeMap, iModel, statements);
                this.addToMap(addMap, targetModel, this.applyRenames(statements, renameMap));
            }
            necessaryImports.addAll(iModel.getImports());
            necessaryImports.remove(targetModel);
            necessaryImports.removeAll(targetModel.getImports());
        }
        LinkedHashSet<IStatement> importStatements = new LinkedHashSet<IStatement>();
        for (Object uri : necessaryImports) {
            importStatements.add((IStatement)new Statement((IReference)targetModel.getURI(), (IReference)OWL.PROPERTY_IMPORTS, uri));
        }
        this.addToMap(addMap, targetModel, importStatements);
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        linkedHashSet.addAll(addMap.keySet());
        linkedHashSet.addAll(removeMap.keySet());
        for (IReference ref : renameMap.keySet()) {
            for (IModel model : linkedHashSet) {
                if (this.domain.isReadOnly(model)) continue;
                IQuery objectQuery = model.getManager().createQuery("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX owl: <http://www.w3.org/2002/07/owl#> PREFIX komma: <http://enilink.net/vocab/komma#> CONSTRUCT {   ?s ?p ?ref .   ?s ?ref ?o .   ?ref ?p ?o . } WHERE {  GRAPH ?g {     {       ?s ?p ?ref .     } UNION {       ?s ?ref ?o .     } UNION {       ?ref ?p ?o .     }   } }", false);
                objectQuery.setParameter("g", (Object)model);
                objectQuery.setParameter("ref", (Object)ref);
                List objectRefStatements = objectQuery.evaluate(IStatement.class, new Class[0]).toList();
                Iterator it = objectRefStatements.iterator();
                while (it.hasNext()) {
                    IStatement st = (IStatement)it.next();
                    if (removeMap.get(model) == null || !((Collection)removeMap.get(model)).contains(st)) continue;
                    it.remove();
                }
                this.addToMap(removeMap, model, objectRefStatements);
                this.addToMap(addMap, model, this.applyRenames(objectRefStatements, renameMap));
            }
        }
        ArrayList<Change> result = new ArrayList<Change>();
        for (IModel model : linkedHashSet) {
            LinkedHashSet<Change.StatementChange> changes = new LinkedHashSet<Change.StatementChange>();
            if (addMap.get(model) != null) {
                for (IStatement st : (Collection)addMap.get(model)) {
                    changes.add(new Change.StatementChange(st, Change.StatementChange.Type.ADD));
                }
            }
            if (removeMap.get(model) != null) {
                for (IStatement st : (Collection)removeMap.get(model)) {
                    changes.add(new Change.StatementChange(st, Change.StatementChange.Type.REMOVE));
                }
            }
            if (changes.isEmpty()) continue;
            result.add(new Change(model, changes));
        }
        return result;
    }

    public Collection<Change> createRenameChanges(Map<?, IReference> elements) {
        LinkedHashMap<IModel, Collection<IStatement>> addMap = new LinkedHashMap<IModel, Collection<IStatement>>();
        LinkedHashMap<IModel, Collection<IStatement>> removeMap = new LinkedHashMap<IModel, Collection<IStatement>>();
        LinkedHashSet<IModel> models = new LinkedHashSet<IModel>();
        LinkedHashMap<IObject, IReference> renameMap = new LinkedHashMap<IObject, IReference>();
        for (Map.Entry<?, IReference> entry : elements.entrySet()) {
            Object wrappedObject = entry.getKey();
            Iterator object = AdapterFactoryEditingDomain.unwrap(wrappedObject);
            if (!(object instanceof IObject)) continue;
            models.add(((IModelAware)object).getModel());
            renameMap.put((IObject)object, entry.getValue());
        }
        LinkedHashSet<IModel> affectedModels = new LinkedHashSet<IModel>();
        for (IModel model : models) {
            affectedModels.add(model);
            for (URI importedModelURI : model.getImportsClosure()) {
                affectedModels.add(model.getModelSet().getModel(importedModelURI, false));
            }
        }
        for (IReference ref : renameMap.keySet()) {
            for (IModel model : affectedModels) {
                if (this.domain.isReadOnly(model)) continue;
                IQuery objectQuery = model.getManager().createQuery("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX owl: <http://www.w3.org/2002/07/owl#> PREFIX komma: <http://enilink.net/vocab/komma#> CONSTRUCT {   ?s ?p ?ref .   ?s ?ref ?o .   ?ref ?p ?o . } WHERE {  GRAPH ?g {     {       ?s ?p ?ref .     } UNION {       ?s ?ref ?o .     } UNION {       ?ref ?p ?o .     }   } }", false);
                objectQuery.setParameter("g", (Object)model);
                objectQuery.setParameter("ref", (Object)ref);
                List objectRefStatements = objectQuery.evaluate(IStatement.class, new Class[0]).toList();
                this.addToMap(removeMap, model, objectRefStatements);
                this.addToMap(addMap, model, this.applyRenames(objectRefStatements, renameMap));
            }
        }
        ArrayList<Change> arrayList = new ArrayList<Change>();
        for (IModel model : affectedModels) {
            LinkedHashSet<Change.StatementChange> changes = new LinkedHashSet<Change.StatementChange>();
            if (addMap.get(model) != null) {
                for (IStatement st : (Collection)addMap.get(model)) {
                    changes.add(new Change.StatementChange(st, Change.StatementChange.Type.ADD));
                }
            }
            if (removeMap.get(model) != null) {
                for (IStatement st : (Collection)removeMap.get(model)) {
                    changes.add(new Change.StatementChange(st, Change.StatementChange.Type.REMOVE));
                }
            }
            if (changes.isEmpty()) continue;
            arrayList.add(new Change(model, changes));
        }
        return arrayList;
    }

    private Collection<IStatement> filterCBD(Collection<IStatement> statements, IReference root) {
        LinkedHashSet<IReference> objects = new LinkedHashSet<IReference>();
        objects.add(root);
        for (IStatement st : statements) {
            if (!(st.getObject() instanceof IReference)) continue;
            objects.add((IReference)st.getObject());
        }
        Iterator<IStatement> it = statements.iterator();
        while (it.hasNext()) {
            IStatement st;
            st = it.next();
            if (objects.contains(st.getSubject())) continue;
            it.remove();
        }
        return statements;
    }

    private boolean addToMap(Map<IModel, Collection<IStatement>> map, IModel model, Collection<IStatement> statements) {
        if (statements == null || statements.isEmpty()) {
            return false;
        }
        Collection<IStatement> mappedStatements = map.get(model);
        if (mappedStatements == null) {
            mappedStatements = new LinkedHashSet<IStatement>();
            map.put(model, mappedStatements);
        }
        return mappedStatements.addAll(statements);
    }

    private Collection<IStatement> applyRenames(Collection<IStatement> statements, Map<? extends IReference, IReference> renameMap) {
        if (statements == null || statements.isEmpty() || renameMap == null || renameMap.isEmpty()) {
            return statements;
        }
        LinkedHashSet<IStatement> result = new LinkedHashSet<IStatement>();
        for (IStatement statement : statements) {
            IReference subject = statement.getSubject();
            IReference predicate = statement.getPredicate();
            Object object = statement.getObject();
            if (renameMap.containsKey(subject)) {
                subject = renameMap.get(subject);
            }
            if (renameMap.containsKey(predicate)) {
                predicate = renameMap.get(predicate);
            }
            if (renameMap.containsKey(object)) {
                object = renameMap.get(object);
            }
            result.add((IStatement)new Statement(subject, predicate, object, statement.getContext()));
        }
        return result;
    }

    public IStatus applyChanges(Collection<Change> changes, IProgressMonitor progressMonitor, IAdaptable info) {
        try {
            return this.domain.getCommandStack().execute((ICommand)new ApplyChangesCommand(changes), progressMonitor, info);
        }
        catch (Exception e) {
            return new Status(4, "net.enilink.komma.edit", e.getMessage(), (Throwable)e);
        }
    }

    private class ApplyChangesCommand
    extends AbstractCommand
    implements AbstractCommand.INoChangeRecording {
        protected Collection<Change> changes;

        public ApplyChangesCommand(Collection<Change> changes) {
            this.changes = changes;
        }

        protected boolean prepare() {
            return true;
        }

        public Collection<?> getAffectedResources(Object type) {
            if (IModel.class.equals(type)) {
                LinkedHashSet<IModel> models = new LinkedHashSet<IModel>();
                for (Change change : this.changes) {
                    models.add(change.getModel());
                }
                return models;
            }
            if (IModelSet.class.equals(type)) {
                LinkedHashSet<IModelSet> modelSets = new LinkedHashSet<IModelSet>();
                for (Change change : this.changes) {
                    IModel model = change.getModel();
                    if (modelSets.contains(model.getModelSet())) continue;
                    modelSets.add(model.getModelSet());
                }
                return modelSets;
            }
            return super.getAffectedResources(type);
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            return this.internalApplyChanges(progressMonitor, info, false);
        }

        protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            return this.internalApplyChanges(progressMonitor, info, false);
        }

        protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            return this.internalApplyChanges(progressMonitor, info, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected CommandResult internalApplyChanges(IProgressMonitor progressMonitor, IAdaptable info, boolean revert) throws ExecutionException {
            Iterator<Object> iterator;
            LinkedHashSet<IModelSet> modelSets = new LinkedHashSet<IModelSet>();
            ArrayList<ITransaction> transactions = new ArrayList<ITransaction>();
            for (Change change : this.changes) {
                IModel model = change.getModel();
                if (modelSets.contains(model.getModelSet())) continue;
                model.getModelSet().getUnitOfWork().begin();
                modelSets.add(model.getModelSet());
                transactions.add(model.getManager().getTransaction());
            }
            ArrayList<ITransaction> startedTransactions = new ArrayList<ITransaction>();
            for (ITransaction t : transactions) {
                if (t.isActive()) continue;
                t.begin();
                startedTransactions.add(t);
            }
            try {
                LinkedHashSet<IReference> linkedHashSet = new LinkedHashSet<IReference>();
                for (Change change : this.changes) {
                    LinkedHashSet<IStatement> remove = new LinkedHashSet<IStatement>();
                    LinkedHashSet<IStatement> add = new LinkedHashSet<IStatement>();
                    for (Change.StatementChange statementChange : change.getStatementChanges()) {
                        linkedHashSet.add(statementChange.getStatement().getSubject());
                        if (statementChange.getType() == Change.StatementChange.Type.REMOVE) {
                            remove.add(statementChange.getStatement());
                        }
                        if (statementChange.getType() != Change.StatementChange.Type.ADD) continue;
                        add.add(statementChange.getStatement());
                    }
                    change.getModel().getManager().remove(revert ? add : remove);
                    change.getModel().getManager().add(revert ? remove : add, true);
                }
                for (ITransaction iTransaction : startedTransactions) {
                    iTransaction.commit();
                }
                iterator = CommandResult.newOKCommandResult(linkedHashSet);
                return iterator;
            }
            catch (KommaException kommaException) {
                for (ITransaction iTransaction : startedTransactions) {
                    if (!iTransaction.isActive()) continue;
                    iTransaction.rollback();
                }
                iterator = CommandResult.newErrorCommandResult((Throwable)kommaException);
                return iterator;
            }
            finally {
                for (IModelSet modelSet : modelSets) {
                    modelSet.getUnitOfWork().end();
                }
            }
        }
    }
}

