/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.internal.model.extensions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.enilink.komma.internal.model.extensions.KommaRegistryReader;
import net.enilink.komma.model.IContentHandler;
import net.enilink.komma.model.ModelPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ContentHandlerRegistryReader
extends KommaRegistryReader {
    static final String TAG_HANDLER = "contentHandler";
    static final String ATT_CLASS = "class";
    static final String ATT_PRIORITY = "priority";
    protected IContentHandler.Registry contentHandlerRegistry;
    private final Map<String, List<IContentHandler>> CONTRIBUTION_MAP = new HashMap<String, List<IContentHandler>>();

    public ContentHandlerRegistryReader(IContentHandler.Registry contentHandlerRegistry) {
        super("net.enilink.komma.model", "contentHandlers");
        this.contentHandlerRegistry = contentHandlerRegistry;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean readElement(IConfigurationElement element, boolean add) {
        if (element.getName().equals(TAG_HANDLER)) {
            String contributorClassName;
            int priority = 0;
            if (element.getAttribute(ATT_PRIORITY) != null) {
                priority = Integer.parseInt(element.getAttribute(ATT_PRIORITY));
            }
            if ((contributorClassName = element.getAttribute(ATT_CLASS)) == null) {
                ContentHandlerRegistryReader.logMissingAttribute((IConfigurationElement)element, (String)ATT_CLASS);
                return false;
            }
            String contributorName = element.getContributor().getName();
            if (add) {
                try {
                    void var6_8;
                    Optional optional = Optional.empty();
                    if (ModelPlugin.IS_OSGI_RUNNING) {
                        Optional<Bundle> optional2 = Stream.of(FrameworkUtil.getBundle(ModelPlugin.class).getBundleContext().getBundles()).filter(b -> b.getSymbolicName().equals(element.getNamespaceIdentifier())).findFirst();
                    }
                    Class contributorHandlerClass = var6_8.isPresent() ? ((Bundle)var6_8.get()).loadClass(contributorClassName) : Class.forName(contributorClassName);
                    HashMap<String, String> parameters = new HashMap<String, String>();
                    for (IConfigurationElement parameter : element.getChildren("parameter")) {
                        parameters.put(parameter.getAttribute("name"), parameter.getAttribute("value"));
                    }
                    IContentHandler contentHandler = parameters.isEmpty() ? (IContentHandler)contributorHandlerClass.newInstance() : (IContentHandler)contributorHandlerClass.getConstructor(Map.class).newInstance(parameters);
                    this.contentHandlerRegistry.put(priority, contentHandler);
                    List<IContentHandler> contributions = this.CONTRIBUTION_MAP.get(contributorName);
                    if (contributions == null) {
                        contributions = new ArrayList<IContentHandler>();
                        this.CONTRIBUTION_MAP.put(contributorName, contributions);
                    }
                    contributions.add(contentHandler);
                    return true;
                }
                catch (Exception exception) {
                    ModelPlugin.log(exception);
                }
                return true;
            }
            List<IContentHandler> list = this.CONTRIBUTION_MAP.get(contributorName);
            if (list != null) {
                for (List values : this.contentHandlerRegistry.values()) {
                    values.removeAll(list);
                }
            }
            this.CONTRIBUTION_MAP.remove(contributorName);
            return true;
        }
        if (!element.getName().equals("parameter")) return false;
        return true;
    }
}

