/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.internal.model.extensions;

import net.enilink.komma.internal.model.extensions.KommaRegistryReader;
import net.enilink.komma.model.IModel;
import net.enilink.komma.model.ModelPlugin;
import org.eclipse.core.runtime.IConfigurationElement;

public class ProtocolFactoriesRegistryReader
extends KommaRegistryReader {
    static final String TAG_FACTORY = "factory";
    static final String ATT_PROTOCOLNAME = "protocolName";
    static final String ATT_CLASS = "class";
    private IModel.Factory.Registry modelFactoryRegistry;

    public ProtocolFactoriesRegistryReader(IModel.Factory.Registry ontologyFactoryRegistry) {
        super("net.enilink.komma.model", "protocolFactories");
        this.modelFactoryRegistry = ontologyFactoryRegistry;
    }

    protected boolean readElement(IConfigurationElement element, boolean add) {
        if (element.getName().equals(TAG_FACTORY)) {
            String protocolName = element.getAttribute(ATT_PROTOCOLNAME);
            if (protocolName == null) {
                ProtocolFactoriesRegistryReader.logMissingAttribute((IConfigurationElement)element, (String)ATT_PROTOCOLNAME);
            } else if (element.getAttribute(ATT_CLASS) == null) {
                ProtocolFactoriesRegistryReader.logMissingAttribute((IConfigurationElement)element, (String)ATT_CLASS);
            } else {
                if (add) {
                    Object previous = this.modelFactoryRegistry.getProtocolToFactoryMap().put(protocolName, new KommaRegistryReader.ModelFactoryDescriptor(element, ATT_CLASS));
                    if (previous instanceof KommaRegistryReader.ModelFactoryDescriptor) {
                        KommaRegistryReader.ModelFactoryDescriptor descriptor = (KommaRegistryReader.ModelFactoryDescriptor)previous;
                        ModelPlugin.logErrorMessage("Both '" + descriptor.element.getContributor().getName() + "' and '" + element.getContributor().getName() + "' register a protocol parser for '" + protocolName + "'");
                    }
                    return true;
                }
                this.modelFactoryRegistry.getProtocolToFactoryMap().remove(protocolName);
                return true;
            }
        }
        return false;
    }
}

