/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.internal.model.extensions;

import net.enilink.komma.internal.model.extensions.KommaRegistryReader;
import net.enilink.komma.model.base.IURIMapRuleSet;
import net.enilink.komma.model.base.RegExURIMapRule;
import org.eclipse.core.runtime.IConfigurationElement;

public class URIMappingRegistryReader
extends KommaRegistryReader {
    static final String TAG_MAPPING = "rule";
    static final String ATT_PRIORITY = "priority";
    static final String ATT_PATTERN = "pattern";
    static final String ATT_REPLACEMENT = "replacement";
    static final String ATT_IFPATTERN = "ifPattern";
    static final String ATT_UNLESSPATTERN = "unlessPattern";
    private IURIMapRuleSet uriMap;

    public URIMappingRegistryReader(IURIMapRuleSet uriMap) {
        super("net.enilink.komma.model", "uriMapRules");
        this.uriMap = uriMap;
    }

    protected boolean readElement(IConfigurationElement element, boolean add) {
        if (element.getName().equals(TAG_MAPPING)) {
            String pattern = element.getAttribute(ATT_PATTERN);
            if (pattern == null) {
                URIMappingRegistryReader.logMissingAttribute((IConfigurationElement)element, (String)ATT_PATTERN);
            } else {
                String replacement = element.getAttribute(ATT_REPLACEMENT);
                if (replacement == null) {
                    URIMappingRegistryReader.logMissingAttribute((IConfigurationElement)element, (String)ATT_REPLACEMENT);
                } else {
                    String priority = element.getAttribute(ATT_PRIORITY);
                    if (priority == null) {
                        URIMappingRegistryReader.logMissingAttribute((IConfigurationElement)element, (String)ATT_PRIORITY);
                    } else {
                        String unlessPattern;
                        RegExURIMapRule rule = new RegExURIMapRule(pattern, replacement, Integer.parseInt(priority));
                        String ifPattern = element.getAttribute(ATT_IFPATTERN);
                        if (ifPattern != null) {
                            rule.setIfPattern(ifPattern);
                        }
                        if ((unlessPattern = element.getAttribute(ATT_UNLESSPATTERN)) != null) {
                            rule.setUnlessPattern(unlessPattern);
                        }
                        if (add) {
                            this.uriMap.addRule(rule);
                        } else {
                            this.uriMap.removeRule(rule);
                        }
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

