/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.model;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.Set;
import net.enilink.komma.core.BlankNode;
import net.enilink.komma.core.IEntityManager;
import net.enilink.komma.core.IEntityManagerFactory;
import net.enilink.komma.core.IGraph;
import net.enilink.komma.core.IReference;
import net.enilink.komma.core.LinkedHashGraph;
import net.enilink.komma.core.URI;
import net.enilink.komma.core.URIs;
import net.enilink.komma.em.util.UnitOfWork;
import net.enilink.komma.model.IModelSet;
import net.enilink.komma.model.IModelSetFactory;
import net.enilink.komma.model.MODELS;
import net.enilink.vocab.rdf.RDF;
import net.enilink.vocab.rdfs.RDFS;

class ModelSetFactory
implements IModelSetFactory {
    @Inject
    private IEntityManagerFactory metaDataManagerFactory;

    ModelSetFactory() {
    }

    @Override
    public IModelSet createModelSet(URI ... modelSetTypes) {
        LinkedHashGraph config = new LinkedHashGraph();
        BlankNode modelSet = new BlankNode();
        config.add((IReference)modelSet, (IReference)RDF.PROPERTY_TYPE, (Object)MODELS.TYPE_MODELSET, new IReference[0]);
        config.add((IReference)modelSet, (IReference)RDF.PROPERTY_TYPE, (Object)RDFS.TYPE_RESOURCE, new IReference[0]);
        for (URI type : modelSetTypes) {
            config.add((IReference)modelSet, (IReference)RDF.PROPERTY_TYPE, (Object)type, new IReference[0]);
        }
        return this.createModelSet(null, (IGraph)config);
    }

    @Override
    public IModelSet createModelSet(URI name, IGraph config) {
        Set modelSets;
        IEntityManager metaDataManager = this.metaDataManagerFactory.get();
        URI ms = name;
        if (ms == null && !(modelSets = config.filter(null, (IReference)RDF.PROPERTY_TYPE, (Object)MODELS.TYPE_MODELSET, new IReference[0]).subjects()).isEmpty()) {
            ms = (IReference)modelSets.iterator().next();
        }
        if (ms == null) {
            throw new IllegalArgumentException("No model set defined in config.");
        }
        LinkedHashGraph fullConfig = new LinkedHashGraph((Collection)config);
        fullConfig.add((IReference)ms, (IReference)RDF.PROPERTY_TYPE, (Object)MODELS.TYPE_MODELSET, new IReference[0]);
        fullConfig.add((IReference)ms, (IReference)RDF.PROPERTY_TYPE, (Object)RDFS.TYPE_RESOURCE, new IReference[0]);
        if (ms.getURI() == null) {
            URI msUri = URIs.createURI((String)BlankNode.generateId());
            fullConfig.rename((IReference)ms, (IReference)msUri);
            ms = msUri;
        }
        metaDataManager.add((Iterable)fullConfig);
        IModelSet modelSet = (IModelSet)metaDataManager.find((IReference)ms, IModelSet.class, new Class[0]);
        if (modelSet instanceof IModelSet.Internal) {
            modelSet = ((IModelSet.Internal)modelSet).create();
        }
        return modelSet;
    }

    @Inject
    protected void setUnitOfWork(UnitOfWork unitOfWork) {
        if (!unitOfWork.isActive()) {
            unitOfWork.begin();
        }
    }
}

