/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.model;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import net.enilink.komma.common.util.BasicDiagnostic;
import net.enilink.komma.common.util.Diagnostic;
import net.enilink.komma.core.BlankNode;
import net.enilink.komma.core.IEntity;
import net.enilink.komma.core.ILiteral;
import net.enilink.komma.core.INamespace;
import net.enilink.komma.core.IStatement;
import net.enilink.komma.core.KommaException;
import net.enilink.komma.core.Namespace;
import net.enilink.komma.core.URI;
import net.enilink.komma.core.URIs;
import net.enilink.komma.core.visitor.IDataAndNamespacesVisitor;
import net.enilink.komma.core.visitor.IDataVisitor;
import net.enilink.komma.model.IModel;
import net.enilink.komma.model.IObject;
import net.enilink.komma.model.IURIConverter;
import net.enilink.komma.model.ModelPlugin;
import net.enilink.komma.rdf4j.RDF4JValueConverter;
import net.enilink.vocab.rdf.Property;
import net.enilink.vocab.rdfs.Class;
import net.enilink.vocab.rdfs.Resource;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.OWL;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.RDFParserRegistry;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.RDFWriterFactory;
import org.eclipse.rdf4j.rio.RDFWriterRegistry;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.helpers.BasicWriterSettings;

public class ModelUtil {
    public static final Collator LABEL_COLLATOR = Collator.getInstance(Locale.GERMAN);

    public static Diagnostic computeDiagnostic(IModel model, boolean includeWarnings) {
        Object diagnostic;
        if (model.getErrors().isEmpty() && (!includeWarnings || model.getWarnings().isEmpty())) {
            return Diagnostic.OK_INSTANCE;
        }
        BasicDiagnostic basicDiagnostic = new BasicDiagnostic();
        for (IModel.IDiagnostic modelDiagnostic : model.getErrors()) {
            diagnostic = null;
            diagnostic = modelDiagnostic instanceof Throwable ? BasicDiagnostic.toDiagnostic((Throwable)((Throwable)((Object)modelDiagnostic)), (Object[])new Object[]{model}) : new BasicDiagnostic(4, "net.enilink.komma.model", 0, modelDiagnostic.getMessage(), new Object[]{model, modelDiagnostic});
            basicDiagnostic.add(diagnostic);
        }
        if (includeWarnings) {
            for (IModel.IDiagnostic modelDiagnostic : model.getWarnings()) {
                diagnostic = null;
                diagnostic = modelDiagnostic instanceof Throwable ? BasicDiagnostic.toDiagnostic((Throwable)((Throwable)((Object)modelDiagnostic)), (Object[])new Object[]{model}) : new BasicDiagnostic(2, "net.enilink.komma.model", 0, modelDiagnostic.getMessage(), new Object[]{model, modelDiagnostic});
                basicDiagnostic.add(diagnostic);
            }
        }
        return basicDiagnostic;
    }

    public static IContentDescription contentDescription(IURIConverter uriConverter, URI uri) throws IOException {
        IContentType contentType;
        String contentTypeId = (String)uriConverter.contentDescription(uri, null).get("net.enilink.komma.model:contentType");
        IContentTypeManager contentTypeManager = ModelPlugin.getContentTypeManager();
        if (contentTypeId != null && contentTypeManager != null && (contentType = contentTypeManager.getContentType(contentTypeId)) != null) {
            return contentType.getDefaultDescription();
        }
        return null;
    }

    private static RDFWriter createWriter(OutputStream os, String baseURI, String mimeType, String charset) throws IOException {
        RDFFormat format = RDFFormat.RDFXML;
        if (mimeType != null) {
            format = Rio.getParserFormatForMIMEType((String)mimeType).orElse(format);
        }
        RDFWriterFactory factory = (RDFWriterFactory)RDFWriterRegistry.getInstance().get((Object)format).orElseThrow(() -> new KommaException("No writer available for " + mimeType));
        RDFWriter writer = factory.getWriter(os);
        writer.set(BasicWriterSettings.PRETTY_PRINT, (Object)false);
        return writer;
    }

    public static IContentDescription determineContentDescription(URI uri, IURIConverter uriConverter, Map<?, ?> options) throws IOException {
        URI normalizedUri;
        String lastSegment;
        IContentTypeManager contentTypeManager = ModelPlugin.getContentTypeManager();
        if (contentTypeManager == null) {
            return null;
        }
        if (options == null) {
            options = Collections.emptyMap();
        }
        IContentDescription contentDescription = null;
        try {
            String contentTypeId = (String)uriConverter.contentDescription(uri, options).get("net.enilink.komma.model:contentType");
            IContentType contentType = null;
            if (contentTypeId != null) {
                contentType = contentTypeManager.getContentType(contentTypeId);
            }
            if (contentType != null) {
                contentDescription = contentType.getDefaultDescription();
            }
        }
        catch (IOException contentTypeId) {
            // empty catch block
        }
        if (contentDescription == null && (lastSegment = (normalizedUri = uriConverter.normalize(uri)).lastSegment()) != null) {
            IContentType[] matchingTypes;
            for (IContentType matchingType : matchingTypes = contentTypeManager.findContentTypesFor(lastSegment)) {
                IContentDescription desc = matchingType.getDefaultDescription();
                if (ModelUtil.mimeType(desc) == null) continue;
                contentDescription = desc;
                break;
            }
        }
        if (contentDescription == null) {
            HashMap optionsExt = new HashMap(options);
            optionsExt.put("requestedAttributes", new HashSet<String>(Arrays.asList("mimeType")));
            Map<String, ?> attributes = uriConverter.getAttributes(uri, optionsExt);
            Object mimeType = attributes.get("mimeType");
            if (mimeType != null) {
                for (IContentType contentType : contentTypeManager.getAllContentTypes()) {
                    if (!mimeType.equals(ModelUtil.mimeType(contentType.getDefaultDescription()))) continue;
                    contentDescription = contentType.getDefaultDescription();
                    break;
                }
            }
        }
        return contentDescription;
    }

    private static RDFFormat determineFormat(String mimeType, InputStream in) {
        RDFFormat format = RDFFormat.RDFXML;
        if (mimeType != null) {
            format = Rio.getParserFormatForMIMEType((String)mimeType).orElse(format);
        } else if (in.markSupported()) {
            in.mark(2048);
            try {
                InputStreamReader r = new InputStreamReader(in, "UTF-8");
                while (((Reader)r).ready()) {
                    int ch = ((Reader)r).read();
                    if (Character.isWhitespace(ch) || ch == 65279) continue;
                    if (ch == 60) {
                        boolean isRdfXml;
                        if (((Reader)r).ready() && (ch = ((Reader)r).read()) == 63) break;
                        StringBuilder tag = new StringBuilder();
                        tag.append((char)ch);
                        int charsAfterColon = -1;
                        while (((Reader)r).ready() && (ch = ((Reader)r).read()) != 62) {
                            tag.append((char)ch);
                            if (charsAfterColon >= 0) {
                                ++charsAfterColon;
                            }
                            if (charsAfterColon > 3 || Character.isWhitespace(ch)) break;
                            if (ch != 58 || charsAfterColon >= 0) continue;
                            charsAfterColon = 0;
                        }
                        if (isRdfXml = Pattern.compile("(^|[^:]+:)rdf\\s+$", 2).matcher(tag.toString()).matches()) break;
                    }
                    format = RDFFormat.TURTLE;
                    break;
                }
            }
            catch (UnsupportedEncodingException r) {
            }
            catch (IOException e) {
                throw new KommaException("Reading RDF data failed.", (Throwable)e);
            }
            try {
                in.reset();
            }
            catch (IOException e) {
                throw new KommaException("Detection of RDF format failed.");
            }
        }
        return format;
    }

    public static List<IObject> filterDescendants(Collection<? extends IObject> objects) {
        ArrayList<IObject> result = new ArrayList<IObject>(objects.size());
        block0: for (IObject iObject : objects) {
            int i = 0;
            int size = result.size();
            while (i < size) {
                IObject rootObject = (IObject)result.get(i);
                if (rootObject.equals(iObject) || rootObject.getAllContents().contains(iObject)) continue block0;
                if (iObject.getAllContents().contains(rootObject)) {
                    result.remove(i);
                    --size;
                    continue;
                }
                ++i;
            }
            result.add(iObject);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String findOntology(InputStream in, String baseURI, String mimeType) throws Exception {
        if (mimeType == null && !in.markSupported()) {
            in = new BufferedInputStream(in);
        }
        final String[] ontology = new String[]{null};
        RDFParser parser = Rio.createParser((RDFFormat)ModelUtil.determineFormat(mimeType, in));
        parser.setRDFHandler(new RDFHandler(){

            public void endRDF() throws RDFHandlerException {
            }

            public void handleComment(String text) throws RDFHandlerException {
            }

            public void handleNamespace(String prefx, String uri) throws RDFHandlerException {
                if (prefx.length() == 0) {
                    ontology[0] = URIs.createURI((String)uri).trimFragment().toString();
                }
            }

            public void handleStatement(Statement stmt) throws RDFHandlerException {
                if (RDF.TYPE.equals((Object)stmt.getPredicate()) && OWL.ONTOLOGY.equals((Object)stmt.getObject()) && stmt.getSubject() instanceof IRI) {
                    ontology[0] = stmt.getSubject().stringValue();
                    throw new RDFHandlerException("found ontology URI");
                }
            }

            public void startRDF() throws RDFHandlerException {
            }
        });
        try {
            parser.parse(in, baseURI);
        }
        catch (RDFHandlerException rDFHandlerException) {
        }
        finally {
            in.close();
        }
        return ontology[0];
    }

    public static String getLabel(Object element) {
        return ModelUtil.getLabel(element, false);
    }

    public static String getLabel(Object element, boolean useLabelForVocab) {
        if (element instanceof IStatement) {
            element = ((IStatement)element).getObject();
        }
        if (element instanceof Resource) {
            Resource resource = (Resource)element;
            String label = null;
            if (!(!useLabelForVocab && (resource instanceof Class || resource instanceof Property || resource instanceof IObject && ((IObject)resource).isOntLanguageTerm()))) {
                label = resource.getRdfsLabel();
            }
            if (label != null) {
                return label;
            }
            return ModelUtil.toPName((IEntity)resource);
        }
        if (element instanceof ILiteral) {
            return ((ILiteral)element).getLabel();
        }
        return element == null ? "" : element.toString();
    }

    public static String getPName(Object element) {
        if (element instanceof IStatement) {
            element = ((IStatement)element).getObject();
        }
        if (element instanceof IEntity) {
            return ModelUtil.toPName((IEntity)element);
        }
        return String.valueOf(element);
    }

    public static Map<String, Double> getSupportedMimeTypes() {
        HashMap<String, Double> mimeTypes = new HashMap<String, Double>();
        IContentTypeManager contentTypeManager = ModelPlugin.getContentTypeManager();
        if (contentTypeManager != null) {
            for (IContentType contentType : contentTypeManager.getAllContentTypes()) {
                String mimeType = ModelUtil.mimeType(contentType.getDefaultDescription());
                if (mimeType == null) continue;
                mimeTypes.put(mimeType.toString(), ModelUtil.priorityForMimeType(mimeType.toString()));
            }
        } else {
            for (RDFFormat format : RDFParserRegistry.getInstance().getKeys()) {
                for (String mimeType : format.getMIMETypes()) {
                    mimeTypes.put(mimeType.toString(), ModelUtil.priorityForMimeType(mimeType.toString()));
                }
            }
        }
        return mimeTypes;
    }

    public static String mimeType(IContentDescription contentDescription) {
        if (contentDescription != null) {
            return (String)contentDescription.getProperty(new QualifiedName("net.enilink.komma.model", "mimeType"));
        }
        return null;
    }

    public static String mimeType(String fileName) {
        Optional format;
        IContentType contentType;
        String mimeType = null;
        IContentTypeManager contentTypeManager = ModelPlugin.getContentTypeManager();
        if (contentTypeManager != null && (contentType = contentTypeManager.findContentTypeFor(fileName)) != null) {
            mimeType = ModelUtil.mimeType(contentType.getDefaultDescription());
        }
        if (mimeType == null && (format = Rio.getParserFormatForFileName((String)fileName)).isPresent()) {
            mimeType = ((RDFFormat)format.get()).getDefaultMIMEType();
        }
        return mimeType;
    }

    private static double priorityForMimeType(String mimeType) {
        if ("text/plain".equals(mimeType)) {
            return 0.5;
        }
        if ("text/html".equals(mimeType)) {
            return 0.3;
        }
        return 1.0;
    }

    public static <V extends IDataVisitor<?>> void readData(InputStream in, String baseURI, String mimeType, final boolean preserveBNodeIDs, final V dataVisitor) {
        if (mimeType == null && !in.markSupported()) {
            in = new BufferedInputStream(in);
        }
        SimpleValueFactory valueFactory = new SimpleValueFactory(){

            public synchronized BNode createBNode() {
                return super.createBNode(BlankNode.generateId((String)"new-").substring(2));
            }

            public synchronized BNode createBNode(String nodeID) {
                if (preserveBNodeIDs) {
                    return super.createBNode(nodeID);
                }
                return super.createBNode("new-" + nodeID);
            }
        };
        final RDF4JValueConverter valueConverter = new RDF4JValueConverter((ValueFactory)valueFactory);
        final boolean handleNamespaces = dataVisitor instanceof IDataAndNamespacesVisitor;
        RDFParser parser = Rio.createParser((RDFFormat)ModelUtil.determineFormat(mimeType, in), (ValueFactory)valueFactory);
        parser.setPreserveBNodeIDs(preserveBNodeIDs);
        parser.setRDFHandler(new RDFHandler(){

            public void endRDF() throws RDFHandlerException {
                dataVisitor.visitEnd();
            }

            public void handleComment(String text) throws RDFHandlerException {
            }

            public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
                if (handleNamespaces) {
                    ((IDataAndNamespacesVisitor)dataVisitor).visitNamespace((INamespace)new Namespace(prefix, URIs.createURI((String)uri)));
                }
            }

            public void handleStatement(Statement stmt) throws RDFHandlerException {
                dataVisitor.visitStatement((IStatement)new net.enilink.komma.core.Statement(valueConverter.fromRdf4j(stmt.getSubject()), valueConverter.fromRdf4j((org.eclipse.rdf4j.model.Resource)stmt.getPredicate()), (Object)valueConverter.fromRdf4j(stmt.getObject())));
            }

            public void startRDF() throws RDFHandlerException {
                dataVisitor.visitBegin();
            }
        });
        try {
            parser.parse(in, baseURI);
        }
        catch (RDFParseException e) {
            throw new KommaException("Invalid RDF data:\n" + e.getMessage(), (Throwable)e);
        }
        catch (RDFHandlerException e) {
            throw new KommaException("Loading RDF failed", (Throwable)e);
        }
        catch (IOException e) {
            throw new KommaException("Cannot access RDF data", (Throwable)e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                throw new KommaException("Unable to close input stream", (Throwable)e);
            }
        }
    }

    public static <V extends IDataVisitor<?>> void readData(InputStream in, String baseURI, String mimeType, V dataVisitor) {
        ModelUtil.readData(in, baseURI, mimeType, false, dataVisitor);
    }

    private static String toPName(IEntity resource) {
        URI uri = resource.getURI();
        if (uri != null) {
            String prefix = resource.getEntityManager().getPrefix(uri.namespace());
            String localPart = uri.localPart();
            boolean hasLocalPart = localPart != null && localPart.length() > 0;
            StringBuilder text = new StringBuilder();
            if (prefix != null && prefix.length() > 0 && hasLocalPart) {
                text.append(prefix).append(":");
            }
            if (hasLocalPart && prefix != null) {
                text.append(localPart);
            } else {
                text.append("<").append(uri).append(">");
            }
            return text.toString();
        }
        return resource.toString();
    }

    public static IDataAndNamespacesVisitor<Void> writeData(OutputStream os, String baseURI, String mimeType, String charset) {
        try {
            final RDFWriter writer = ModelUtil.createWriter(os, baseURI, mimeType, charset);
            return new IDataAndNamespacesVisitor<Void>(){
                final RDF4JValueConverter valueConverter = new RDF4JValueConverter((ValueFactory)SimpleValueFactory.getInstance());

                void throwException(Exception e) {
                    throw new KommaException("Saving RDF failed", (Throwable)e);
                }

                public Void visitBegin() {
                    try {
                        writer.startRDF();
                    }
                    catch (RDFHandlerException e) {
                        this.throwException((Exception)((Object)e));
                    }
                    return null;
                }

                public Void visitEnd() {
                    try {
                        writer.endRDF();
                    }
                    catch (RDFHandlerException e) {
                        this.throwException((Exception)((Object)e));
                    }
                    return null;
                }

                public Void visitNamespace(INamespace namespace) {
                    try {
                        writer.handleNamespace(namespace.getPrefix(), namespace.getURI().toString());
                    }
                    catch (RDFHandlerException e) {
                        this.throwException((Exception)((Object)e));
                    }
                    return null;
                }

                public Void visitStatement(IStatement stmt) {
                    try {
                        writer.handleStatement(this.valueConverter.toRdf4j(stmt));
                    }
                    catch (RDFHandlerException e) {
                        this.throwException((Exception)((Object)e));
                    }
                    return null;
                }
            };
        }
        catch (IOException e) {
            throw new KommaException("Creating RDF writer failed", (Throwable)e);
        }
    }

    static {
        LABEL_COLLATOR.setStrength(1);
    }
}

