/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.model.base;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.enilink.komma.core.URI;
import net.enilink.komma.model.IContentHandler;
import net.enilink.komma.model.IURIConverter;
import net.enilink.komma.model.IURIHandler;
import net.enilink.komma.model.ModelPlugin;
import net.enilink.komma.model.base.CompoundURIMapRuleSet;
import net.enilink.komma.model.base.FileURIHandler;
import net.enilink.komma.model.base.IURIMapRuleSet;
import net.enilink.komma.model.base.URIHandler;
import net.enilink.komma.model.base.URIMapRuleSet;

public class ExtensibleURIConverter
implements IURIConverter {
    protected List<IURIHandler> uriHandlers;
    protected List<IContentHandler> contentHandlers;
    protected IURIMapRuleSet uriMap;
    protected static List<IURIHandler> DEFAULT_URI_HANDLERS = Collections.unmodifiableList(Arrays.asList(new FileURIHandler(), new URIHandler()));
    protected static List<IURIHandler> sharedHandlers = new ArrayList<IURIHandler>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtensibleURIConverter() {
        List<IURIHandler> list = sharedHandlers;
        synchronized (list) {
            this.getURIHandlers().addAll(sharedHandlers);
        }
        this.getURIHandlers().addAll(DEFAULT_URI_HANDLERS);
        this.getContentHandlers().addAll(ModelPlugin.getDefault().getContentHandlerRegistry().getContentHandlers());
    }

    public ExtensibleURIConverter(Collection<IURIHandler> uriHandlers, Collection<IContentHandler> contentHandlers) {
        this.getURIHandlers().addAll(uriHandlers);
        this.getContentHandlers().addAll(contentHandlers);
    }

    @Override
    public Collection<IURIHandler> getURIHandlers() {
        if (this.uriHandlers == null) {
            this.uriHandlers = new ArrayList<IURIHandler>();
        }
        return this.uriHandlers;
    }

    @Override
    public IURIHandler getURIHandler(URI uri) {
        for (IURIHandler uriHandler : this.uriHandlers) {
            if (!uriHandler.canHandle(uri)) continue;
            return uriHandler;
        }
        throw new RuntimeException("There is no URIHandler to handle " + uri);
    }

    public List<IContentHandler> getContentHandlers() {
        if (this.contentHandlers == null) {
            this.contentHandlers = new ArrayList<IContentHandler>();
        }
        return this.contentHandlers;
    }

    @Override
    public OutputStream createOutputStream(URI uri) throws IOException {
        return this.createOutputStream(uri, null);
    }

    @Override
    public OutputStream createOutputStream(URI uri, Map<?, ?> options) throws IOException {
        URI normalizedURI = this.normalize(uri);
        return this.getURIHandler(normalizedURI).createOutputStream(normalizedURI, new OptionsMap("URI_CONVERTER", this, options));
    }

    @Override
    public InputStream createInputStream(URI uri) throws IOException {
        return this.createInputStream(uri, null);
    }

    @Override
    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
        URI normalizedURI = this.normalize(uri);
        return this.getURIHandler(normalizedURI).createInputStream(normalizedURI, new OptionsMap("URI_CONVERTER", this, options));
    }

    @Override
    public void delete(URI uri, Map<?, ?> options) throws IOException {
        URI normalizedURI = this.normalize(uri);
        this.getURIHandler(normalizedURI).delete(normalizedURI, new OptionsMap("URI_CONVERTER", this, options));
    }

    @Override
    public Map<String, ?> contentDescription(URI uri, Map<?, ?> options) throws IOException {
        URI normalizedURI = this.normalize(uri);
        return this.getURIHandler(normalizedURI).contentDescription(normalizedURI, new OptionsMap("URI_CONVERTER", this, options));
    }

    @Override
    public boolean exists(URI uri, Map<?, ?> options) {
        URI normalizedURI = this.normalize(uri);
        return this.getURIHandler(normalizedURI).exists(normalizedURI, new OptionsMap("URI_CONVERTER", this, options));
    }

    @Override
    public Map<String, ?> getAttributes(URI uri, Map<?, ?> options) {
        URI normalizedURI = this.normalize(uri);
        return this.getURIHandler(normalizedURI).getAttributes(normalizedURI, new OptionsMap("URI_CONVERTER", this, options));
    }

    @Override
    public void setAttributes(URI uri, Map<String, ?> attributes, Map<?, ?> options) throws IOException {
        URI normalizedURI = this.normalize(uri);
        this.getURIHandler(normalizedURI).setAttributes(normalizedURI, attributes, new OptionsMap("URI_CONVERTER", this, options));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerSharedUriHandler(IURIHandler handler) {
        List<IURIHandler> list = sharedHandlers;
        synchronized (list) {
            sharedHandlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterSharedUriHandler(IURIHandler handler) {
        List<IURIHandler> list = sharedHandlers;
        synchronized (list) {
            sharedHandlers.remove(handler);
        }
    }

    @Override
    public URI normalize(URI uri) {
        URI oldUri;
        boolean changed;
        while (changed = !(oldUri = uri).equals((Object)(uri = this.getURIMapRules().map(uri)))) {
        }
        return uri;
    }

    @Override
    public IURIMapRuleSet getURIMapRules() {
        if (this.uriMap == null) {
            this.uriMap = new CompoundURIMapRuleSet(new URIMapRuleSet(), ModelPlugin.getDefault().getURIMap());
        }
        return this.uriMap;
    }

    @Override
    public void setURIMapRules(IURIMapRuleSet uriMapRules) {
        this.uriMap = uriMapRules;
    }

    static class OptionsMap
    implements Map<Object, Object> {
        protected Object key;
        protected Object value;
        protected Map<?, ?> options;
        protected Map<Object, Object> mergedMap;

        public OptionsMap(Object key, Object value, Map<?, ?> options) {
            this.options = options == null ? Collections.EMPTY_MAP : options;
            this.key = key;
            this.value = value;
        }

        protected Map<Object, Object> mergedMap() {
            if (this.mergedMap == null) {
                this.mergedMap = new LinkedHashMap(this.options);
                this.mergedMap.put(this.key, this.value);
            }
            return this.mergedMap;
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.key == key || this.key.equals(key) || this.options.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.value == value || this.options.containsValue(value);
        }

        @Override
        public Set<Map.Entry<Object, Object>> entrySet() {
            return this.mergedMap().entrySet();
        }

        @Override
        public Object get(Object key) {
            return this.key == key || this.key.equals(key) ? this.value : this.options.get(key);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Set<Object> keySet() {
            return this.mergedMap().keySet();
        }

        @Override
        public Object put(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends Object, ? extends Object> t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.mergedMap().size();
        }

        @Override
        public Collection<Object> values() {
            return this.mergedMap().values();
        }

        @Override
        public int hashCode() {
            return this.mergedMap().hashCode();
        }

        @Override
        public boolean equals(Object o) {
            return this.mergedMap().equals(0);
        }
    }
}

