/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.model.base;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.enilink.komma.core.URI;
import net.enilink.komma.model.IModel;
import net.enilink.komma.model.IURIConverter;

public class ModelFactoryRegistry
implements IModel.Factory.Registry {
    protected Map<String, Object> protocolToFactoryMap = new HashMap<String, Object>();
    protected Map<String, Object> extensionToFactoryMap = new HashMap<String, Object>();
    protected Map<String, Object> contentTypeIdentifierToFactoryMap = new HashMap<String, Object>();
    protected static final Map<?, ?> CONTENT_DESCRIPTION_OPTIONS;

    @Override
    public IModel.Factory getFactory(URI uri) {
        return ModelFactoryRegistry.convert(this.getFactory(uri, this.protocolToFactoryMap, this.extensionToFactoryMap, this.contentTypeIdentifierToFactoryMap, "", true));
    }

    @Override
    public IModel.Factory getFactory(URI uri, String contentType) {
        return ModelFactoryRegistry.convert(this.getFactory(uri, this.protocolToFactoryMap, this.extensionToFactoryMap, this.contentTypeIdentifierToFactoryMap, contentType, true));
    }

    public static IModel.Factory convert(Object ontModelFactory) {
        return ontModelFactory instanceof IModel.Factory.IDescriptor ? ((IModel.Factory.IDescriptor)ontModelFactory).createFactory() : (IModel.Factory)ontModelFactory;
    }

    protected Object getFactory(URI uri, Map<String, Object> protocolToFactoryMap, Map<String, Object> extensionToFactoryMap, Map<String, Object> contentTypeIdentifierToFactoryMap, String contentTypeIdentifier, boolean delegate) {
        Object modelFactory = null;
        if (!protocolToFactoryMap.isEmpty()) {
            modelFactory = protocolToFactoryMap.get(uri.scheme());
        }
        if (modelFactory == null) {
            boolean extensionToFactoryMapIsEmpty = extensionToFactoryMap.isEmpty();
            if (!extensionToFactoryMapIsEmpty) {
                modelFactory = extensionToFactoryMap.get(uri.fileExtension());
            }
            if (modelFactory == null) {
                boolean contentTypeIdentifierToFactoryMapIsEmpty = contentTypeIdentifierToFactoryMap.isEmpty();
                if (!contentTypeIdentifierToFactoryMapIsEmpty) {
                    if ("".equals(contentTypeIdentifier)) {
                        contentTypeIdentifier = this.getContentTypeIdentifier(uri);
                    }
                    if (contentTypeIdentifier != null) {
                        modelFactory = contentTypeIdentifierToFactoryMap.get(contentTypeIdentifier);
                    }
                }
                if (modelFactory == null) {
                    if (!extensionToFactoryMapIsEmpty) {
                        modelFactory = extensionToFactoryMap.get("*");
                    }
                    if (modelFactory == null) {
                        if (!contentTypeIdentifierToFactoryMapIsEmpty) {
                            modelFactory = contentTypeIdentifierToFactoryMap.get("*");
                        }
                        if (modelFactory == null && delegate) {
                            modelFactory = this.delegatedGetFactory(uri, contentTypeIdentifier);
                        }
                    }
                }
            }
        }
        return modelFactory;
    }

    protected String getContentTypeIdentifier(URI uri) {
        try {
            Map<String, ?> contentDescription = this.getURIConverter().contentDescription(uri, this.getContentDescriptionOptions());
            return (String)contentDescription.get("net.enilink.komma.model:contentType");
        }
        catch (IOException e) {
            return null;
        }
    }

    protected IURIConverter getURIConverter() {
        return null;
    }

    protected Map<?, ?> getContentDescriptionOptions() {
        return CONTENT_DESCRIPTION_OPTIONS;
    }

    protected IModel.Factory delegatedGetFactory(URI uri, String contentTypeIdentifier) {
        return null;
    }

    @Override
    public Map<String, Object> getExtensionToFactoryMap() {
        return this.extensionToFactoryMap;
    }

    @Override
    public Map<String, Object> getProtocolToFactoryMap() {
        return this.protocolToFactoryMap;
    }

    @Override
    public Map<String, Object> getContentTypeToFactoryMap() {
        return this.contentTypeIdentifierToFactoryMap;
    }

    static {
        HashMap contentDescriptionOptions = new HashMap();
        HashSet<String> requestedProperties = new HashSet<String>();
        requestedProperties.add("net.enilink.komma.model:contentType");
        contentDescriptionOptions.put("REQUESTED_PROPERTIES", requestedProperties);
        CONTENT_DESCRIPTION_OPTIONS = Collections.unmodifiableMap(contentDescriptionOptions);
    }
}

