/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.model.base;

import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import net.enilink.commons.util.extensions.RegistryFactoryHelper;
import net.enilink.composition.properties.PropertySetFactory;
import net.enilink.composition.traits.Behaviour;
import net.enilink.komma.common.adapter.AdapterSet;
import net.enilink.komma.common.adapter.IAdapterFactory;
import net.enilink.komma.common.adapter.IAdapterSet;
import net.enilink.komma.common.notify.FilterUtil;
import net.enilink.komma.common.notify.INotification;
import net.enilink.komma.common.notify.INotificationListener;
import net.enilink.komma.common.notify.NotificationFilter;
import net.enilink.komma.common.notify.NotificationSupport;
import net.enilink.komma.core.BlankNode;
import net.enilink.komma.core.EntityVar;
import net.enilink.komma.core.IEntityManager;
import net.enilink.komma.core.IEntityManagerFactory;
import net.enilink.komma.core.IProvider;
import net.enilink.komma.core.IQuery;
import net.enilink.komma.core.IReference;
import net.enilink.komma.core.IUnitOfWork;
import net.enilink.komma.core.KommaException;
import net.enilink.komma.core.KommaModule;
import net.enilink.komma.core.URI;
import net.enilink.komma.dm.IDataManager;
import net.enilink.komma.dm.IDataManagerFactory;
import net.enilink.komma.dm.change.IDataChange;
import net.enilink.komma.dm.change.IDataChangeListener;
import net.enilink.komma.dm.change.IDataChangeSupport;
import net.enilink.komma.dm.change.INamespaceChange;
import net.enilink.komma.dm.change.IStatementChange;
import net.enilink.komma.em.CacheModule;
import net.enilink.komma.em.CachingEntityManagerModule;
import net.enilink.komma.em.EntityManagerFactoryModule;
import net.enilink.komma.em.ThreadLocalDataManager;
import net.enilink.komma.em.util.KommaUtil;
import net.enilink.komma.model.IModel;
import net.enilink.komma.model.IModelSet;
import net.enilink.komma.model.IObject;
import net.enilink.komma.model.IURIConverter;
import net.enilink.komma.model.ModelPlugin;
import net.enilink.komma.model.base.DiagnosticWrappedException;
import net.enilink.komma.model.base.ExtensibleURIConverter;
import net.enilink.komma.model.base.ModelFactoryRegistry;
import net.enilink.komma.model.concepts.ModelSet;
import net.enilink.komma.model.event.IStatementNotification;
import net.enilink.komma.model.event.NamespaceNotification;
import net.enilink.komma.model.event.StatementNotification;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ModelSetSupport
implements IModelSet.Internal,
ModelSet,
Behaviour<IModelSet.Internal> {
    private static final Logger log = LoggerFactory.getLogger(ModelSetSupport.class);
    protected EntityVar<State> state;
    @Inject
    private IUnitOfWork unitOfWork;
    @Inject
    private IDataManagerFactory metaDataManagerFactory;
    @Inject
    private Injector injector;
    @Inject
    private Provider<Locale> locale;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected State state() {
        EntityVar<State> entityVar = this.state;
        synchronized (entityVar) {
            State s = (State)this.state.get();
            if (s == null) {
                s = new State();
                this.state.set((Object)s);
            }
            return s;
        }
    }

    @Override
    public synchronized IAdapterSet adapters() {
        if (this.state().adapterSet == null) {
            this.state().adapterSet = (IAdapterSet)new AdapterSet(this.getBehaviourDelegate());
        }
        return this.state().adapterSet;
    }

    public void addListener(INotificationListener<INotification> listener) {
        this.state().notificationSupport.addListener(listener);
    }

    @Override
    public void addMetaDataListener(INotificationListener<INotification> listener) {
        this.state().metaDataNotificationSupport.addListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSubjectListener(IReference subject, INotificationListener<INotification> listener) {
        CopyOnWriteArraySet<Object> listeners;
        Map<IReference, CopyOnWriteArraySet<INotificationListener<INotification>>> subjectListeners;
        Map<IReference, CopyOnWriteArraySet<INotificationListener<INotification>>> map = subjectListeners = this.state().subjectListeners;
        synchronized (map) {
            listeners = subjectListeners.get(subject);
            if (listeners == null) {
                listeners = new CopyOnWriteArraySet();
                subjectListeners.put(subject, listeners);
            }
        }
        listeners.add(listener);
    }

    @Override
    public void collectInjectionModules(Collection<Module> modules) {
        modules.add((Module)new CacheModule(BlankNode.generateId()));
        modules.add((Module)new AbstractModule(){

            protected void configure() {
                this.bind(IDataManager.class).to(ThreadLocalDataManager.class).in(Singleton.class);
            }
        });
        modules.add((Module)new EntityManagerFactoryModule(this.getModule(), (IProvider)new IProvider<Locale>(){

            public Locale get() {
                return (Locale)ModelSetSupport.this.locale.get();
            }
        }, (Module)new CachingEntityManagerModule(){

            protected Class<? extends PropertySetFactory> getPropertySetFactoryClass() {
                Class factoryClass = ((IModelSet.Internal)ModelSetSupport.this.getBehaviourDelegate()).getPropertySetFactoryClass();
                return factoryClass != null ? factoryClass : super.getPropertySetFactoryClass();
            }
        }));
    }

    @Override
    public URI getDefaultGraph() {
        return null;
    }

    @Override
    public Class<? extends PropertySetFactory> getPropertySetFactoryClass() {
        return null;
    }

    @Override
    public IModel createModel(URI uri) {
        return ((IModelSet.Internal)this.getBehaviourDelegate()).createModel(uri, null);
    }

    @Override
    public IModel createModel(URI uri, String contentType) {
        IModel.Factory modelFactory = this.getModelFactoryRegistry().getFactory(uri, contentType);
        if (modelFactory != null) {
            IModel result = modelFactory.createModel((IModelSet)this.getBehaviourDelegate(), uri);
            this.getModels().add(result);
            return result;
        }
        return null;
    }

    protected IModel demandCreateModel(URI uri) {
        return ((IModelSet.Internal)this.getBehaviourDelegate()).createModel(uri, "");
    }

    protected void demandLoad(IModel model) throws IOException {
        model.load(this.getLoadOptions());
    }

    protected void demandLoadHelper(IModel model) {
        try {
            this.demandLoad(model);
        }
        catch (IOException exception) {
            this.handleDemandLoadException(model, exception);
        }
    }

    @Override
    public void dispose() {
        State theState = (State)this.state.get();
        if (theState != null) {
            this.getUnitOfWork().end();
            theState.dispose();
            try {
                this.metaDataManagerFactory.close();
            }
            catch (Exception e) {
                ModelPlugin.log(e);
            }
            this.state.remove();
        }
    }

    private <K, T> List<T> ensureList(Map<K, List<T>> map, K key) {
        List<T> list = map.get(key);
        if (list == null) {
            list = new ArrayList<T>();
            map.put(key, list);
        }
        return list;
    }

    protected Map<Object, List<INotification>> addNotification(Map<Object, List<INotification>> groupedNotifications, INotification notification, Object target) {
        if (groupedNotifications == null) {
            groupedNotifications = new HashMap<Object, List<INotification>>();
        }
        this.ensureList(groupedNotifications, target).add(notification);
        return groupedNotifications;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireNotifications(Collection<? extends INotification> notifications) {
        Map<IReference, CopyOnWriteArraySet<INotificationListener<INotification>>> subjectListeners;
        this.state().notificationSupport.fireNotifications(notifications);
        Map<IReference, CopyOnWriteArraySet<INotificationListener<INotification>>> map = subjectListeners = this.state().subjectListeners;
        synchronized (map) {
            if (subjectListeners.isEmpty()) {
                return;
            }
        }
        Map<Object, List<INotification>> groupedNotifications = null;
        for (INotification iNotification : notifications) {
            boolean notify;
            Object subject = iNotification.getSubject();
            Object object = subjectListeners;
            synchronized (object) {
                notify = subjectListeners.containsKey(subject);
            }
            if (notify) {
                groupedNotifications = this.addNotification(groupedNotifications, iNotification, subject);
            }
            if (!(iNotification instanceof IStatementNotification)) continue;
            subject = ((IStatementNotification)iNotification).getObject();
            object = subjectListeners;
            synchronized (object) {
                notify = subjectListeners.containsKey(subject);
            }
            if (!notify) continue;
            groupedNotifications = this.addNotification(groupedNotifications, iNotification, subject);
        }
        if (groupedNotifications != null) {
            for (Map.Entry entry : groupedNotifications.entrySet()) {
                Collection listeners;
                Map<IReference, CopyOnWriteArraySet<INotificationListener<INotification>>> notify = subjectListeners;
                synchronized (notify) {
                    listeners = subjectListeners.get(entry.getKey());
                }
                if (listeners == null) continue;
                ArrayList cache = new ArrayList();
                for (INotificationListener listener : listeners) {
                    Collection filtered = FilterUtil.select(notifications, (NotificationFilter)listener.getFilter(), cache);
                    if (filtered.isEmpty()) continue;
                    listener.notifyChanged((Collection)entry.getValue());
                }
            }
        }
    }

    public List<IAdapterFactory> getAdapterFactories() {
        return this.state().adapterFactories;
    }

    @Override
    public IDataChangeSupport getDataChangeSupport() {
        return this.state().dataChangeSupport;
    }

    @Override
    public Injector getInjector() {
        return this.state().injector;
    }

    @Override
    public IDataManagerFactory getDataManagerFactory() {
        return this.state().getDmFactory();
    }

    @Override
    public IEntityManagerFactory getEntityManagerFactory() {
        return this.state().getEmFactory();
    }

    @Override
    public Map<Object, Object> getLoadOptions() {
        if (this.state().loadOptions == null) {
            this.state().loadOptions = new HashMap<Object, Object>();
        }
        return this.state().loadOptions;
    }

    @Override
    public IEntityManager getMetaDataManager() {
        return this.getEntityManager();
    }

    @Override
    public IModel getModel(URI uri, boolean loadOnDemand) {
        List result = ((IQuery)this.getMetaDataManager().createQuery("SELECT DISTINCT ?m WHERE { ?ms <http://enilink.net/vocab/komma/models#model> ?m }").setParameter("m", (Object)uri)).evaluate(IModel.class, new Class[0]).toList();
        if (!result.isEmpty()) {
            IModel model = (IModel)result.get(0);
            if (loadOnDemand && !model.isLoaded()) {
                this.demandLoadHelper(model);
            }
            return model;
        }
        if (loadOnDemand) {
            IModel model = this.demandCreateModel(uri);
            if (model == null) {
                throw new RuntimeException("Cannot create a model for '" + uri + "'; a registered model factory is needed");
            }
            if (!model.isLoaded()) {
                this.demandLoadHelper(model);
            }
            return model;
        }
        return null;
    }

    @Override
    public IModel.Factory.Registry getModelFactoryRegistry() {
        if (this.state().modelFactoryRegistry == null) {
            this.state().modelFactoryRegistry = new ModelFactoryRegistry(){

                @Override
                protected IModel.Factory delegatedGetFactory(URI uri, String contentTypeIdentifier) {
                    IModel.Factory.Registry defaultModelFactoryRegistry = ModelPlugin.getDefault().getModelFactoryRegistry();
                    return 4.convert(this.getFactory(uri, defaultModelFactoryRegistry.getProtocolToFactoryMap(), defaultModelFactoryRegistry.getExtensionToFactoryMap(), defaultModelFactoryRegistry.getContentTypeToFactoryMap(), contentTypeIdentifier, false));
                }

                @Override
                protected Map<?, ?> getContentDescriptionOptions() {
                    return ModelSetSupport.this.getLoadOptions();
                }

                @Override
                protected IURIConverter getURIConverter() {
                    return ((IModelSet.Internal)ModelSetSupport.this.getBehaviourDelegate()).getURIConverter();
                }
            };
        }
        return this.state().modelFactoryRegistry;
    }

    @Override
    public KommaModule getModule() {
        if (this.state().module == null) {
            IExtensionPoint extensionPoint;
            KommaModule module = new KommaModule(ModelSetSupport.class.getClassLoader());
            module.includeModule(KommaUtil.getCoreModule());
            IExtensionRegistry registry = RegistryFactoryHelper.getRegistry();
            if (registry != null && (extensionPoint = registry.getExtensionPoint("net.enilink.komma.model", "modules")) != null) {
                for (IConfigurationElement cfgElement : extensionPoint.getConfigurationElements()) {
                    String namespace;
                    if (!cfgElement.isValid() || (namespace = cfgElement.getAttribute("uri")) != null && !namespace.trim().isEmpty()) continue;
                    try {
                        KommaModule extensionModule = (KommaModule)cfgElement.createExecutableExtension("class");
                        module.includeModule(extensionModule);
                    }
                    catch (CoreException e) {
                        throw new KommaException("Unable to instantiate extension module", (Throwable)e);
                    }
                }
            }
            module.addReadableGraph(((IModelSet.Internal)this.getBehaviourDelegate()).getDefaultGraph());
            this.state().module = module;
        }
        return this.state().module;
    }

    @Override
    public IObject getObject(URI uri, boolean loadOnDemand) {
        IModel model = this.getModel(uri.trimFragment(), loadOnDemand);
        if (model != null) {
            return (IObject)model.getManager().find((IReference)uri, IObject.class, new Class[0]);
        }
        return null;
    }

    @Override
    public IUnitOfWork getUnitOfWork() {
        return this.unitOfWork;
    }

    @Override
    public IURIConverter getURIConverter() {
        if (this.state().uriConverter == null) {
            this.state().uriConverter = new ExtensibleURIConverter();
        }
        return this.state().uriConverter;
    }

    protected void handleDemandLoadException(IModel model, IOException exception) {
        String location = model.getURI() == null ? null : model.getURI().toString();
        IOException cause = exception instanceof IModel.IOWrappedException ? (Exception)exception.getCause() : exception;
        DiagnosticWrappedException wrappedException = new DiagnosticWrappedException(location, cause);
        if (model.getErrors().isEmpty()) {
            try {
                model.getErrors().add(exception instanceof IModel.IDiagnostic ? (IModel.IDiagnostic)((Object)exception) : wrappedException);
            }
            catch (Exception e) {
                wrappedException = new DiagnosticWrappedException(location, new RuntimeException(cause.getMessage()));
                model.getErrors().add(wrappedException);
            }
        }
        throw wrappedException;
    }

    @Override
    public IModelSet.Internal create() {
        ArrayList<Module> modules = new ArrayList<Module>();
        ((IModelSet.Internal)this.getBehaviourDelegate()).collectInjectionModules(modules);
        Injector modelSetInjector = this.injector.getParent().getParent().createChildInjector(modules);
        IModelSet.Internal result = (IModelSet.Internal)this.getBehaviourDelegate();
        URI metaDataContext = this.getMetaDataContext();
        if (metaDataContext != null) {
            KommaModule module = new KommaModule();
            module.includeModule(this.getEntityManager().getFactory().getModule(), false);
            module.addWritableGraph(metaDataContext);
            module.addReadableGraph(metaDataContext);
            IEntityManager newMetaDataManager = ((IEntityManagerFactory)modelSetInjector.getInstance(IEntityManagerFactory.class)).createChildFactory(new KommaModule[]{module}).get();
            result = (IModelSet.Internal)newMetaDataManager.merge((Object)result);
        }
        result.init(modelSetInjector);
        if (metaDataContext != null) {
            result.createModel(metaDataContext);
        }
        return result;
    }

    @Override
    public void init(Injector injector) {
        this.state().injector = injector;
        this.setDataChangeSupport((IDataChangeSupport)injector.getInstance(IDataChangeSupport.class));
    }

    public void removeListener(INotificationListener<INotification> listener) {
        this.state().notificationSupport.removeListener(listener);
    }

    @Override
    public void removeMetaDataListener(INotificationListener<INotification> listener) {
        this.state().metaDataNotificationSupport.removeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSubjectListener(IReference subject, INotificationListener<INotification> listener) {
        CopyOnWriteArraySet<INotificationListener<INotification>> listeners;
        Map<IReference, CopyOnWriteArraySet<INotificationListener<INotification>>> subjectListeners;
        Map<IReference, CopyOnWriteArraySet<INotificationListener<INotification>>> map = subjectListeners = this.state().subjectListeners;
        synchronized (map) {
            listeners = subjectListeners.get(subject);
        }
        if (listeners != null) {
            listeners.remove(listener);
        }
    }

    public void setDataChangeSupport(IDataChangeSupport changeSupport) {
        this.state().dataChangeSupport = changeSupport;
        this.state().dataChangeSupport.addChangeListener(new IDataChangeListener(){
            URI metaDataContext;
            {
                this.metaDataContext = ModelSetSupport.this.getMetaDataContext();
            }

            public void dataChanged(List<IDataChange> changes) {
                ModelSetSupport.this.fireNotifications(ModelSetSupport.this.transformChanges(changes));
                HashSet<IReference> changedModels = new HashSet<IReference>();
                for (IDataChange change : changes) {
                    IReference context;
                    if (!(change instanceof IStatementChange) || (context = ((IStatementChange)change).getStatement().getContext()) == null) continue;
                    changedModels.add(context);
                }
                for (IReference changedModel : changedModels) {
                    IModel model;
                    if (changedModel.getURI() == null || changedModel.getURI().equals((Object)this.metaDataContext) || (model = ModelSetSupport.this.getModel(changedModel.getURI(), false)) == null || !model.isLoaded()) continue;
                    model.setModified(true);
                }
            }
        });
    }

    @Inject
    protected void setMetaDataChangeSupport(IDataChangeSupport changeSupport) {
        changeSupport.addChangeListener(new IDataChangeListener(){

            public void dataChanged(List<IDataChange> changes) {
                ModelSetSupport.this.state().metaDataNotificationSupport.fireNotifications(ModelSetSupport.this.transformChanges(changes));
            }
        });
    }

    @Override
    public void setModelFactoryRegistry(IModel.Factory.Registry modelFactoryRegistry) {
        this.state().modelFactoryRegistry = modelFactoryRegistry;
    }

    @Override
    public void setURIConverter(IURIConverter uriConverter) {
        this.state().uriConverter = uriConverter;
    }

    protected List<INotification> transformChanges(List<IDataChange> changes) {
        ArrayList<INotification> notifications = new ArrayList<INotification>(changes.size());
        for (IDataChange change : changes) {
            if (change instanceof INotification) {
                notifications.add((INotification)change);
                continue;
            }
            if (change instanceof INamespaceChange) {
                INamespaceChange nsChange = (INamespaceChange)change;
                notifications.add(new NamespaceNotification(nsChange.getPrefix(), nsChange.getOldNS(), nsChange.getNewNS()));
                continue;
            }
            IStatementChange stmtChange = (IStatementChange)change;
            notifications.add(new StatementNotification((IModelSet)this.getBehaviourDelegate(), stmtChange.isAdd(), stmtChange.getStatement()));
        }
        return notifications;
    }

    public static class State {
        protected List<IAdapterFactory> adapterFactories;
        private IAdapterSet adapterSet;
        protected IDataChangeSupport dataChangeSupport;
        protected Map<Object, Object> loadOptions;
        protected NotificationSupport<INotification> metaDataNotificationSupport = new NotificationSupport();
        protected IModel.Factory.Registry modelFactoryRegistry;
        protected KommaModule module;
        protected NotificationSupport<INotification> notificationSupport = new NotificationSupport();
        protected Map<IReference, CopyOnWriteArraySet<INotificationListener<INotification>>> subjectListeners = new HashMap<IReference, CopyOnWriteArraySet<INotificationListener<INotification>>>();
        protected Injector injector;
        protected IURIConverter uriConverter;
        protected volatile IDataManagerFactory dmFactory;
        protected volatile IEntityManagerFactory emFactory;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        IDataManagerFactory getDmFactory() {
            if (this.dmFactory == null) {
                State state = this;
                synchronized (state) {
                    if (this.dmFactory == null) {
                        this.dmFactory = (IDataManagerFactory)this.injector.getInstance(IDataManagerFactory.class);
                    }
                }
            }
            return this.dmFactory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        IEntityManagerFactory getEmFactory() {
            if (this.emFactory == null) {
                State state = this;
                synchronized (state) {
                    if (this.emFactory == null) {
                        this.emFactory = (IEntityManagerFactory)this.injector.getInstance(IEntityManagerFactory.class);
                    }
                }
            }
            return this.emFactory;
        }

        void dispose() {
            if (this.emFactory != null) {
                this.emFactory.close();
                this.emFactory = null;
            }
            if (this.dmFactory != null) {
                this.dmFactory.close();
                this.dmFactory = null;
            }
        }
    }
}

