/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.model.base;

import net.enilink.komma.model.base.IURIMapRule;

public class SimpleURIMapRule
implements IURIMapRule {
    private String pattern;
    private int priority;
    private String replacement;

    public SimpleURIMapRule(int priority, String pattern, String replacement) {
        this.priority = priority;
        this.pattern = pattern;
        this.replacement = replacement;
    }

    public SimpleURIMapRule(String pattern, String replacement) {
        this(0, pattern, replacement);
    }

    @Override
    public String apply(String uri) {
        return this.pattern.equals(uri) ? this.replacement : null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SimpleURIMapRule)) {
            return false;
        }
        SimpleURIMapRule other = (SimpleURIMapRule)obj;
        if (this.pattern == null ? other.pattern != null : !this.pattern.equals(other.pattern)) {
            return false;
        }
        return !(this.replacement == null ? other.replacement != null : !this.replacement.equals(other.replacement));
    }

    public String getPattern() {
        return this.pattern;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public String getReplacement() {
        return this.replacement;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.pattern == null ? 0 : this.pattern.hashCode());
        result = 31 * result + (this.replacement == null ? 0 : this.replacement.hashCode());
        return result;
    }
}

