/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.model.base;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.enilink.komma.core.URI;
import net.enilink.komma.model.IContentHandler;
import net.enilink.komma.model.IModel;
import net.enilink.komma.model.IURIConverter;
import net.enilink.komma.model.IURIHandler;
import net.enilink.komma.model.ModelUtil;

public class URIHandler
implements IURIHandler {
    private static final int TIMEOUT_HARD_IN_MS = 5000;
    private static final int TIMEOUT_SOFT_IN_MS = 4900;

    @Override
    public boolean canHandle(URI uri) {
        return true;
    }

    protected IURIConverter getURIConverter(Map<?, ?> options) {
        return (IURIConverter)options.get("URI_CONVERTER");
    }

    protected Map<Object, Object> getResponse(Map<?, ?> options) {
        return (Map)options.get("RESPONSE");
    }

    protected Set<String> getRequestedAttributes(Map<?, ?> options) {
        return (Set)options.get("requestedAttributes");
    }

    @Override
    public OutputStream createOutputStream(URI uri, Map<?, ?> options) throws IOException {
        try {
            URL url = new URL(uri.toString());
            final URLConnection urlConnection = url.openConnection();
            urlConnection.setDoOutput(true);
            if (urlConnection instanceof HttpURLConnection) {
                final HttpURLConnection httpURLConnection = (HttpURLConnection)urlConnection;
                httpURLConnection.setRequestMethod("PUT");
                return new FilterOutputStream(urlConnection.getOutputStream()){

                    @Override
                    public void close() throws IOException {
                        int responseCode;
                        super.close();
                        try {
                            responseCode = URIHandler.this.getResponseCode(httpURLConnection);
                        }
                        catch (InterruptedException | ExecutionException | TimeoutException e) {
                            throw new IOException(e);
                        }
                        switch (responseCode) {
                            case 200: 
                            case 201: 
                            case 204: {
                                break;
                            }
                            default: {
                                throw new IOException("PUT failed with HTTP response code " + responseCode);
                            }
                        }
                    }
                };
            }
            OutputStream result = urlConnection.getOutputStream();
            final Map<Object, Object> response = this.getResponse(options);
            if (response != null) {
                result = new FilterOutputStream(result){

                    @Override
                    public void close() throws IOException {
                        try {
                            super.close();
                        }
                        finally {
                            response.put("TIME_STAMP", urlConnection.getLastModified());
                        }
                    }
                };
            }
            return result;
        }
        catch (RuntimeException exception) {
            throw new IModel.IOWrappedException(exception);
        }
    }

    protected String acceptHeader() {
        StringBuilder accept = new StringBuilder();
        for (Map.Entry<String, Double> mimeType : ModelUtil.getSupportedMimeTypes().entrySet()) {
            if (accept.length() > 0) {
                accept.append(", ");
            }
            accept.append(mimeType.getKey()).append("; q=").append(String.format("%.2f", mimeType.getValue()));
        }
        return accept.toString();
    }

    @Override
    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
        try {
            URL url = new URL(uri.toString());
            URLConnection urlConnection = url.openConnection();
            urlConnection.setRequestProperty("Accept", this.acceptHeader());
            InputStream result = this.getInputStream(urlConnection);
            Map<Object, Object> response = this.getResponse(options);
            if (response != null) {
                response.put("TIME_STAMP", urlConnection.getLastModified());
                if (urlConnection.getContentType() != null) {
                    response.put("MIME_TYPE", urlConnection.getContentType().replaceAll(";.*$", "").trim());
                }
            }
            return result;
        }
        catch (InterruptedException | RuntimeException | ExecutionException | TimeoutException exception) {
            throw new IModel.IOWrappedException(exception);
        }
    }

    @Override
    public void delete(URI uri, Map<?, ?> options) throws IOException {
        block6: {
            try {
                URL url = new URL(uri.toString());
                URLConnection urlConnection = url.openConnection();
                urlConnection.setDoOutput(true);
                if (urlConnection instanceof HttpURLConnection) {
                    HttpURLConnection httpURLConnection = (HttpURLConnection)urlConnection;
                    httpURLConnection.setRequestMethod("DELETE");
                    int responseCode = this.getResponseCode(httpURLConnection);
                    switch (responseCode) {
                        case 200: 
                        case 202: 
                        case 204: {
                            break;
                        }
                        default: {
                            throw new IOException("DELETE failed with HTTP response code " + responseCode);
                        }
                    }
                    break block6;
                }
                throw new IOException("Delete is not supported for " + uri);
            }
            catch (InterruptedException | RuntimeException | ExecutionException | TimeoutException exception) {
                throw new IModel.IOWrappedException(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, ?> contentDescription(URI uri, Map<?, ?> options) throws IOException {
        IURIConverter uriConverter = (IURIConverter)options.get("URI_CONVERTER");
        InputStream inputStream = null;
        Map<String, ?> result = null;
        HashMap<Object, Object> context = new HashMap<Object, Object>();
        try {
            for (IContentHandler contentHandler : uriConverter.getContentHandlers()) {
                if (!contentHandler.canHandle(uri)) continue;
                if (inputStream == null) {
                    try {
                        inputStream = this.createInputStream(uri, options);
                    }
                    catch (IOException exception) {
                        inputStream = new ByteArrayInputStream(new byte[0]);
                    }
                    if (!inputStream.markSupported()) {
                        inputStream = new BufferedInputStream(inputStream);
                    }
                    inputStream.mark(Integer.MAX_VALUE);
                } else {
                    inputStream.reset();
                }
                context.put("mimeType", options.get("MIME_TYPE"));
                Map<String, ?> contentDescription = contentHandler.contentDescription(uri, inputStream, options, context);
                switch ((IContentHandler.Validity)((Object)contentDescription.get("net.enilink.komma.model:validity"))) {
                    case VALID: {
                        Map<String, ?> map = contentDescription;
                        return map;
                    }
                    case INDETERMINATE: {
                        if (result != null) break;
                        result = contentDescription;
                        break;
                    }
                }
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return result == null ? IContentHandler.INVALID_CONTENT_DESCRIPTION : result;
    }

    @Override
    public boolean exists(URI uri, Map<?, ?> options) {
        try {
            URL url = new URL(uri.toString());
            URLConnection urlConnection = url.openConnection();
            urlConnection.setRequestProperty("Accept", this.acceptHeader());
            if (urlConnection instanceof HttpURLConnection) {
                HttpURLConnection httpURLConnection = (HttpURLConnection)urlConnection;
                httpURLConnection.setRequestMethod("HEAD");
                int responseCode = this.getResponseCode(httpURLConnection);
                return responseCode == 200;
            }
            InputStream inputStream = urlConnection.getInputStream();
            inputStream.close();
            return true;
        }
        catch (Throwable exception) {
            return false;
        }
    }

    @Override
    public Map<String, ?> getAttributes(URI uri, Map<?, ?> options) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Set<String> requestedAttributes = this.getRequestedAttributes(options);
        try {
            HttpURLConnection httpURLConnection;
            URL url = new URL(uri.toString());
            URLConnection urlConnection = null;
            if (requestedAttributes == null || requestedAttributes.contains("readOnly")) {
                urlConnection = url.openConnection();
                urlConnection.setRequestProperty("Accept", this.acceptHeader());
                if (urlConnection instanceof HttpURLConnection) {
                    httpURLConnection = (HttpURLConnection)urlConnection;
                    httpURLConnection.setRequestMethod("OPTIONS");
                    int responseCode = this.getResponseCode(httpURLConnection);
                    if (responseCode == 200) {
                        String allow = httpURLConnection.getHeaderField("Allow");
                        result.put("readOnly", allow == null || !allow.contains("PUT"));
                    }
                    urlConnection = null;
                } else {
                    result.put("readOnly", true);
                }
            }
            if (requestedAttributes == null || requestedAttributes.contains("timeStamp") || requestedAttributes.contains("length") || requestedAttributes.contains("mimeType")) {
                String contentType;
                if (urlConnection == null) {
                    urlConnection = url.openConnection();
                    urlConnection.setRequestProperty("Accept", this.acceptHeader());
                    if (urlConnection instanceof HttpURLConnection) {
                        httpURLConnection = (HttpURLConnection)urlConnection;
                        httpURLConnection.setRequestMethod("HEAD");
                        this.getResponseCode(httpURLConnection);
                    }
                }
                if ((requestedAttributes == null || requestedAttributes.contains("timeStamp")) && urlConnection.getHeaderField("last-modified") != null) {
                    result.put("timeStamp", urlConnection.getLastModified());
                }
                if ((requestedAttributes == null || requestedAttributes.contains("length")) && urlConnection.getHeaderField("content-length") != null) {
                    result.put("length", urlConnection.getContentLength());
                }
                if ((requestedAttributes == null || requestedAttributes.contains("mimeType")) && (contentType = urlConnection.getContentType()) != null) {
                    result.put("mimeType", contentType.replaceAll(";.*$", "").trim());
                }
            }
        }
        catch (IOException | InterruptedException | ExecutionException | TimeoutException exception) {
            // empty catch block
        }
        return result;
    }

    private int getResponseCode(final HttpURLConnection connection) throws InterruptedException, ExecutionException, TimeoutException {
        FutureTask<Integer> futureTask = new FutureTask<Integer>(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                URIHandler.this.setupTimeout(connection);
                return connection.getResponseCode();
            }
        });
        new Thread(futureTask).start();
        return futureTask.get(5000L, TimeUnit.MILLISECONDS);
    }

    private InputStream getInputStream(final URLConnection connection) throws InterruptedException, ExecutionException, TimeoutException {
        FutureTask<InputStream> futureTask = new FutureTask<InputStream>(new Callable<InputStream>(){

            @Override
            public InputStream call() throws Exception {
                URIHandler.this.setupTimeout(connection);
                return connection.getInputStream();
            }
        });
        new Thread(futureTask).start();
        return futureTask.get(5000L, TimeUnit.MILLISECONDS);
    }

    private void setupTimeout(URLConnection connection) {
        connection.setConnectTimeout(4900);
        connection.setReadTimeout(4900);
    }

    @Override
    public void setAttributes(URI uri, Map<String, ?> attributes, Map<?, ?> options) throws IOException {
    }
}

