/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.model.change;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import net.enilink.komma.core.KommaException;
import net.enilink.komma.dm.IDataManager;
import net.enilink.komma.dm.change.IDataChange;
import net.enilink.komma.model.IModelSet;
import net.enilink.komma.model.change.IChangeDescription;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ChangeDescription
implements IChangeDescription {
    private LinkedList<IDataChange> changes = new LinkedList();
    private IModelSet.Internal modelSet;

    public ChangeDescription(IModelSet modelSet) {
        this.modelSet = (IModelSet.Internal)modelSet;
    }

    public void add(IDataChange change) {
        this.changes.add(change);
    }

    public List<IDataChange> getChanges() {
        return this.changes;
    }

    @Override
    public IStatus redo(IProgressMonitor monitor, IAdaptable info) {
        try (IDataManager dm = null;){
            dm = (IDataManager)this.modelSet.getDataManagerFactory().get();
            dm.getTransaction().begin();
            ListIterator<IDataChange> it = this.changes.listIterator(this.changes.size());
            while (it.hasPrevious()) {
                it.previous().redo(dm);
            }
            dm.getTransaction().commit();
        }
        catch (Throwable e) {
            throw new KommaException(e);
        }
        return Status.OK_STATUS;
    }

    @Override
    public IStatus undo(IProgressMonitor monitor, IAdaptable info) {
        try (IDataManager dm = null;){
            dm = (IDataManager)this.modelSet.getDataManagerFactory().get();
            dm.getTransaction().begin();
            ListIterator<IDataChange> it = this.changes.listIterator(this.changes.size());
            while (it.hasPrevious()) {
                it.previous().undo(dm);
            }
            dm.getTransaction().commit();
        }
        catch (Throwable e) {
            throw new KommaException(e);
        }
        return Status.OK_STATUS;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.changes.isEmpty();
    }
}

