/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.model.change;

import java.util.List;
import net.enilink.komma.common.notify.INotification;
import net.enilink.komma.common.notify.INotifier;
import net.enilink.komma.dm.change.IDataChange;
import net.enilink.komma.dm.change.IDataChangeListener;
import net.enilink.komma.model.IModelSet;
import net.enilink.komma.model.change.ChangeDescription;
import net.enilink.komma.model.change.IChangeDescription;

public class ChangeRecorder
implements IDataChangeListener {
    protected ChangeDescription changeDescription;
    protected IModelSet modelSet;
    private boolean paused;
    protected boolean recording;

    public ChangeRecorder(IModelSet modelSet) {
        this.modelSet = modelSet;
    }

    protected void addListener() {
        if (this.modelSet != null) {
            this.modelSet.getDataChangeSupport().addChangeListener((IDataChangeListener)this);
        }
    }

    public void beginRecording() {
        this.changeDescription = this.createChangeDescription();
        this.addListener();
        this.setRecording(true);
    }

    protected ChangeDescription createChangeDescription() {
        return new ChangeDescription(this.modelSet);
    }

    public void dispose() {
        this.setRecording(false);
        this.removeListener();
        this.changeDescription = null;
    }

    public IChangeDescription endRecording() {
        if (this.isRecording()) {
            this.setRecording(false);
            return this.getChangeDescription();
        }
        return null;
    }

    protected IChangeDescription getChangeDescription() {
        return this.changeDescription;
    }

    public INotifier<INotification> getTarget() {
        return this.modelSet;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public boolean isRecording() {
        return this.recording;
    }

    public void pause() {
        assert (this.isRecording()) : "Cannot pause when not recording";
        this.paused = true;
    }

    protected void removeListener() {
        if (this.modelSet != null) {
            this.modelSet.getDataChangeSupport().removeChangeListener((IDataChangeListener)this);
        }
    }

    public void dataChanged(List<IDataChange> changes) {
        if (this.isRecording() && !this.isPaused()) {
            for (IDataChange change : changes) {
                this.changeDescription.add(change);
            }
        }
    }

    public void resume() {
        assert (this.isPaused()) : "Cannot resume when not paused";
        this.paused = false;
    }

    protected void setRecording(boolean recording) {
        this.recording = recording;
    }
}

