/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.model.event;

import net.enilink.komma.common.notify.INotification;
import net.enilink.komma.core.IReference;
import net.enilink.komma.core.IStatement;
import net.enilink.komma.core.Statement;
import net.enilink.komma.model.IModel;
import net.enilink.komma.model.IModelAware;
import net.enilink.komma.model.IModelSet;
import net.enilink.komma.model.event.IStatementNotification;

public class StatementNotification
implements IStatementNotification {
    private IStatement stmt;
    private boolean add;
    private IModelSet modelSet;

    public StatementNotification(boolean add, IStatement stmt) {
        this(null, add, stmt);
    }

    public StatementNotification(IModelSet modelSet, boolean add, IStatement stmt) {
        IReference subj = stmt.getSubject();
        Object obj = stmt.getObject();
        IReference ctx = stmt.getContext();
        if (modelSet == null) {
            IModel model;
            if (subj instanceof IModelAware) {
                model = ((IModelAware)subj).getModel();
            } else if (obj instanceof IModelAware) {
                model = ((IModelAware)obj).getModel();
            } else {
                throw new IllegalArgumentException("The argument modelSet may not be null.");
            }
            modelSet = model.getModelSet();
            if (ctx == null) {
                ctx = model.getURI();
                stmt = new Statement(subj, stmt.getPredicate(), obj, ctx, stmt.isInferred());
            }
        }
        this.stmt = stmt;
        this.modelSet = modelSet;
        this.add = add;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StatementNotification other = (StatementNotification)obj;
        if (this.add != other.add) {
            return false;
        }
        return this.stmt.equals(other.stmt);
    }

    @Override
    public IReference getContext() {
        return this.stmt.getContext();
    }

    @Override
    public IModelSet getModelSet() {
        return this.modelSet;
    }

    @Override
    public Object getObject() {
        return this.stmt.getObject();
    }

    @Override
    public IReference getPredicate() {
        return this.stmt.getPredicate();
    }

    @Override
    public IReference getSubject() {
        return this.stmt.getSubject();
    }

    @Override
    public IStatement getStatement() {
        return this.stmt;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.add ? 1231 : 1237);
        result = 31 * result + this.stmt.hashCode();
        return result;
    }

    @Override
    public boolean isAdd() {
        return this.add;
    }

    public boolean merge(INotification notification) {
        return false;
    }

    public String toString() {
        return "[" + this.getSubject() + ", " + this.getPredicate() + ", " + this.getObject() + "]";
    }
}

