/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.model.rdf4j;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.enilink.komma.common.AbstractKommaPlugin;
import net.enilink.komma.core.KommaException;
import net.enilink.komma.core.URI;
import net.enilink.komma.core.URIs;
import net.enilink.komma.em.KommaEM;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

class RepositoryUtil {
    RepositoryUtil() {
    }

    static void addBasicKnowledge(Repository repository, URI targetGraph, boolean addRdfAndRdfsVocabulary) {
        if (AbstractKommaPlugin.IS_OSGI_RUNNING) {
            HashSet<String> bundleNames = new HashSet<String>(Arrays.asList("net.enilink.vocab.owl", "net.enilink.vocab.rdfs"));
            List bundles = Stream.of(FrameworkUtil.getBundle(RepositoryUtil.class).getBundleContext().getBundles()).filter(b -> bundleNames.contains(b.getSymbolicName())).collect(Collectors.toList());
            RepositoryConnection conn = null;
            try {
                conn = repository.getConnection();
                for (Bundle bundle : bundles) {
                    URL url = bundle.getResource("META-INF/org.openrdf.ontologies");
                    if (url == null) continue;
                    URL resolvedUrl = FileLocator.resolve((URL)url);
                    Properties properties = new Properties();
                    InputStream in = resolvedUrl.openStream();
                    properties.load(in);
                    in.close();
                    URI baseUri = URIs.createURI((String)url.toString()).trimSegments(1);
                    for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                        String file = entry.getKey().toString();
                        if (!addRdfAndRdfsVocabulary && file.contains("rdfs")) continue;
                        URI fileUri = URIs.createFileURI((String)file);
                        resolvedUrl = FileLocator.resolve((URL)new URL((fileUri = fileUri.resolve(baseUri)).toString()));
                        if (resolvedUrl == null) continue;
                        in = resolvedUrl.openStream();
                        if (in != null && in.available() > 0) {
                            Resource[] resourceArray;
                            URI defaultGraph = targetGraph;
                            if (defaultGraph == null) {
                                resourceArray = new Resource[]{};
                            } else {
                                Resource[] resourceArray2 = new Resource[1];
                                resourceArray = resourceArray2;
                                resourceArray2[0] = repository.getValueFactory().createIRI(defaultGraph.toString());
                            }
                            Resource[] contexts = resourceArray;
                            conn.add(in, "", RDFFormat.RDFXML, contexts);
                        }
                        if (in == null) continue;
                        in.close();
                    }
                }
            }
            catch (IOException e) {
                throw new KommaException("Cannot access RDF data", (Throwable)e);
            }
            catch (RepositoryException e) {
                throw new KommaException("Loading RDF failed", (Throwable)e);
            }
            catch (RDFParseException e) {
                throw new KommaException("Invalid RDF data", (Throwable)e);
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (RepositoryException e) {
                        KommaEM.INSTANCE.log((Object)e);
                    }
                }
            }
        }
    }
}

