/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.model.rdf4j;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.enilink.commons.iterator.IExtendedIterator;
import net.enilink.commons.iterator.IMap;
import net.enilink.composition.annotations.Iri;
import net.enilink.composition.traits.Behaviour;
import net.enilink.komma.core.BlankNode;
import net.enilink.komma.core.INamespace;
import net.enilink.komma.core.IReference;
import net.enilink.komma.core.IStatement;
import net.enilink.komma.core.IValue;
import net.enilink.komma.core.KommaException;
import net.enilink.komma.core.Statement;
import net.enilink.komma.core.URI;
import net.enilink.komma.core.visitor.IDataAndNamespacesVisitor;
import net.enilink.komma.dm.IDataManager;
import net.enilink.komma.em.util.KommaUtil;
import net.enilink.komma.model.IModel;
import net.enilink.komma.model.IModelSet;
import net.enilink.komma.model.ModelUtil;
import net.enilink.komma.model.concepts.Model;
import net.enilink.komma.model.concepts.Namespace;
import org.eclipse.core.runtime.content.IContentDescription;

@Iri(value="http://enilink.net/vocab/komma/models#SerializableModel")
public abstract class SerializableModelSupport
implements IModel.Internal,
Model,
Behaviour<IModel> {
    private IContentDescription determineContentDescription(Map<?, ?> options) throws IOException {
        IContentDescription contentDescription;
        if (options == null) {
            options = Collections.emptyMap();
        }
        if ((contentDescription = (IContentDescription)options.get("CONTENT_DESCRIPTION")) == null) {
            contentDescription = ModelUtil.determineContentDescription(this.getURI(), this.getModelSet().getURIConverter(), options);
        }
        return contentDescription;
    }

    @Override
    public void load(final InputStream in, final Map<?, ?> options) throws IOException {
        final ArrayList namespaces = new ArrayList();
        IDataManager dm = (IDataManager)((IModelSet.Internal)this.getModelSet()).getDataManagerFactory().get();
        final ReconstructNodeIds nodeIdMapper = this.getModelSet().isPersistent() ? null : new ReconstructNodeIds();
        this.getModelSet().getDataChangeSupport().setEnabled(dm, false);
        try {
            this.setModelLoading(true);
            if (in != null && in.available() > 0) {
                dm.getTransaction().begin();
                final AtomicBoolean finished = new AtomicBoolean(false);
                final LinkedList queue = new LinkedList();
                final Throwable[] exception = new Throwable[]{null};
                Executors.newSingleThreadExecutor().execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            IDataAndNamespacesVisitor<Void> visitor = new IDataAndNamespacesVisitor<Void>(){

                                public Void visitBegin() {
                                    return null;
                                }

                                public Void visitEnd() {
                                    return null;
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public Void visitStatement(IStatement stmt) {
                                    if (nodeIdMapper != null) {
                                        stmt = nodeIdMapper.map(stmt);
                                    }
                                    Queue queue = queue;
                                    synchronized (queue) {
                                        queue.add(stmt);
                                        queue.notify();
                                    }
                                    return null;
                                }

                                public Void visitNamespace(INamespace namespace) {
                                    namespaces.add(namespace);
                                    return null;
                                }
                            };
                            String mimeType = (String)options.get("MIME_TYPE");
                            if (mimeType == null) {
                                IContentDescription contentDescription = SerializableModelSupport.this.determineContentDescription(options);
                                mimeType = ModelUtil.mimeType(contentDescription);
                            }
                            ModelUtil.readData(in, SerializableModelSupport.this.getURI().toString(), mimeType, nodeIdMapper != null, visitor);
                        }
                        catch (IOException e) {
                            exception[0] = e;
                        }
                        catch (RuntimeException e) {
                            exception[0] = e;
                        }
                        finally {
                            finished.set(true);
                            Queue e = queue;
                            synchronized (e) {
                                queue.notify();
                            }
                        }
                    }
                });
                dm.add(new BlockingIterator(queue, finished), new IReference[]{this.getURI()});
                if (exception[0] != null) {
                    throw exception[0];
                }
                dm.getTransaction().commit();
                for (INamespace ns : namespaces) {
                    if (ns.getPrefix().length() <= 0 || ns.getURI().equals((Object)dm.getNamespace(ns.getPrefix()))) continue;
                    Namespace newNs = (Namespace)this.getEntityManager().create(Namespace.class, new Class[0]);
                    newNs.setPrefix(ns.getPrefix());
                    newNs.setURI(ns.getURI());
                    this.getModelNamespaces().add(newNs);
                }
                if (nodeIdMapper != null) {
                    this.maxNodeId(Math.max(this.maxNodeId(), nodeIdMapper.maxNodeId));
                }
            }
        }
        catch (Throwable e) {
            if (e instanceof KommaException) {
                throw (KommaException)e;
            }
            throw new KommaException("Unable to load model", e);
        }
        finally {
            this.setModelLoading(false);
            this.setModified(false);
            if (dm.getTransaction().isActive()) {
                dm.getTransaction().rollback();
            }
            dm.close();
        }
        this.setModelLoaded(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(OutputStream os, Map<?, ?> options) throws IOException {
        IContentDescription contentDescription;
        String mimeType = (String)options.get("MIME_TYPE");
        String charset = null;
        if (mimeType == null && (contentDescription = this.determineContentDescription(options)) != null) {
            if (mimeType == null) {
                mimeType = ModelUtil.mimeType(contentDescription);
            }
            charset = contentDescription.getCharset();
        }
        IDataAndNamespacesVisitor<Void> dataVisitor = ModelUtil.writeData(os, this.getURI().toString(), mimeType, charset);
        dataVisitor.visitBegin();
        try (IDataManager dm = (IDataManager)((IModelSet.Internal)this.getModelSet()).getDataManagerFactory().get();){
            Set readableGraphs = this.getModuleClosure().getReadableGraphs();
            for (INamespace namespace : this.getManager().getNamespaces()) {
                if (!KommaUtil.isW3cNamespace((URI)namespace.getURI()) && namespace.isDerived() && !readableGraphs.contains(namespace.getURI().trimFragment())) continue;
                dataVisitor.visitNamespace(namespace);
            }
            dataVisitor.visitNamespace((INamespace)new net.enilink.komma.core.Namespace("", this.getURI().appendLocalPart("")));
            int expandDepth = this.getModelSet().isPersistent() ? 0 : 6;
            StringBuilder template = new StringBuilder();
            StringBuilder projection = new StringBuilder();
            StringBuilder patterns = new StringBuilder();
            StringBuilder filterExpanded = new StringBuilder();
            if (expandDepth > 0) {
                int i;
                filterExpanded.append("&& not exists {");
                int filterDepth = expandDepth;
                for (i = 0; i < filterDepth; ++i) {
                    String prevS = "?someS" + (i - 1);
                    if (i > 0) {
                        filterExpanded.append("optional {");
                    }
                    filterExpanded.append("?someS" + i).append(" ?someP" + i);
                    filterExpanded.append(" ").append(i == 0 ? "?s" : prevS).append(" . ");
                    if (i <= 0) continue;
                    filterExpanded.append("filter isBlank(").append(prevS).append(") ");
                }
                for (i = 1; i < filterDepth; ++i) {
                    filterExpanded.append("}");
                }
                filterExpanded.append(" filter(");
                for (i = 0; i < filterDepth; ++i) {
                    filterExpanded.append("isIRI(?someS" + i + ")");
                    if (i >= filterDepth - 1) continue;
                    filterExpanded.append(" || ");
                }
                filterExpanded.append(")");
                filterExpanded.append("}");
                for (i = 0; i < expandDepth; ++i) {
                    String s = "?o" + i;
                    String p = "?p" + (i + 1);
                    String o = "?o" + (i + 1);
                    template.append(s).append(" " + p + " ").append(o).append(" . ");
                    projection.append(p).append(" ").append(o).append(" ");
                    patterns.append("optional {").append(s).append(" " + p + " ").append(o);
                    patterns.append(" filter isBlank(").append(s).append(") ");
                }
                for (i = 0; i < expandDepth; ++i) {
                    patterns.append("}");
                }
            }
            ShortenNodeIds idMapper = new ShortenNodeIds();
            String query = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#> PREFIX owl: <http://www.w3.org/2002/07/owl#> PREFIX komma: <http://enilink.net/vocab/komma#> construct { ?s ?p ?o0 . " + template + "} where { graph ?g { { ?s ?p ?o0 filter isIRI(?s) " + patterns + " bind (1 as ?type) } union { ?s ?p ?o0 filter (isBlank(?s) " + filterExpanded + ")  bind (2 as ?type) } }} order by ?type ?s ?p ?o0 " + projection;
            IExtendedIterator stmts = dm.createQuery(query, this.getURI().trimFragment().toString(), false, new IReference[]{this.getURI()}).setParameter("g", (IValue)this.getURI()).evaluate().mapWith((IMap)idMapper);
            while (stmts.hasNext()) {
                dataVisitor.visitStatement((IStatement)stmts.next());
            }
        }
        dataVisitor.visitEnd();
    }

    @Iri(value="http://enilink.net/vocab/komma/models#maxNodeId")
    public abstract long maxNodeId();

    public abstract void maxNodeId(long var1);

    class ShortenNodeIds
    implements IMap<IStatement, IStatement> {
        final Map<String, IReference> bnodeMap = new HashMap<String, IReference>();
        Pattern idPattern = Pattern.compile("^.*__0*([0-9a-z]+)$");
        long nextNodeId = SerializableModelSupport.this.maxNodeId() + 1L;

        ShortenNodeIds() {
        }

        public IStatement map(IStatement stmt) {
            return new Statement(this.convert(stmt.getSubject()), this.convert(stmt.getPredicate()), (Object)this.convert((IValue)stmt.getObject()));
        }

        <V> V convert(V value) {
            String valueAsString;
            if (value instanceof IReference && ((IReference)value).getURI() == null && (valueAsString = value.toString()).startsWith("_:")) {
                String id = valueAsString.substring(2);
                IReference bnode = this.bnodeMap.get(id);
                if (bnode == null) {
                    Matcher m = this.idPattern.matcher(id);
                    String shortId = m.matches() ? m.group(1) : Long.toString(this.nextNodeId++, 36);
                    String newId = "_:n" + shortId;
                    bnode = new BlankNode(newId);
                    this.bnodeMap.put(id, bnode);
                }
                return (V)bnode;
            }
            return value;
        }
    }

    class ReconstructNodeIds
    implements IMap<IStatement, IStatement> {
        final Map<String, IReference> bnodeMap = new HashMap<String, IReference>();
        Pattern idPattern = Pattern.compile("^_:n([0-9a-z]{1,13})$");
        String prefix = BlankNode.generateId();
        long maxNodeId = 0L;

        ReconstructNodeIds() {
        }

        public IStatement map(IStatement stmt) {
            return new Statement(this.convert(stmt.getSubject()), this.convert(stmt.getPredicate()), (Object)this.convert((IValue)stmt.getObject()));
        }

        <V> V convert(V value) {
            if (value instanceof IReference && ((IReference)value).getURI() == null) {
                String valueAsString = value.toString();
                Matcher m = this.idPattern.matcher(valueAsString);
                if (m.matches()) {
                    String idStr = m.group(1);
                    IReference bnode = this.bnodeMap.get(idStr);
                    if (bnode == null) {
                        long id = Long.parseLong(idStr, 36);
                        this.maxNodeId = Math.max(this.maxNodeId, id);
                        String fixedLenSuffix = ("0000000000000" + idStr).substring(idStr.length());
                        String newId = this.prefix + "__" + fixedLenSuffix;
                        bnode = new BlankNode(newId);
                        this.bnodeMap.put(idStr, bnode);
                    }
                    return (V)bnode;
                }
                return (V)new BlankNode("_:new-" + valueAsString.substring(2));
            }
            return value;
        }
    }

    class BlockingIterator<T>
    implements Iterator<T>,
    Iterable<T> {
        Queue<T> queue;
        AtomicBoolean finished;
        T next;
        boolean nextComputed = false;

        public BlockingIterator(Queue<T> queue, AtomicBoolean finished) {
            this.queue = queue;
            this.finished = finished;
        }

        @Override
        public Iterator<T> iterator() {
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            if (!this.nextComputed) {
                Queue<T> queue = this.queue;
                synchronized (queue) {
                    try {
                        while (!this.finished.get() && this.queue.isEmpty()) {
                            this.queue.wait();
                        }
                        this.next = this.queue.isEmpty() ? null : this.queue.remove();
                    }
                    catch (InterruptedException e) {
                        this.next = null;
                    }
                }
                this.nextComputed = true;
            }
            return this.next != null;
        }

        @Override
        public T next() {
            this.nextComputed = false;
            return this.next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

