/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.model.validation;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import net.enilink.commons.iterator.IExtendedIterator;
import net.enilink.komma.common.util.BasicDiagnostic;
import net.enilink.komma.common.util.Diagnostic;
import net.enilink.komma.common.util.DiagnosticChain;
import net.enilink.komma.core.IReference;
import net.enilink.komma.em.concepts.IClass;
import net.enilink.komma.em.concepts.IProperty;
import net.enilink.komma.em.concepts.IResource;
import net.enilink.komma.model.IObject;
import net.enilink.komma.model.ModelPlugin;
import net.enilink.komma.model.ModelUtil;
import net.enilink.komma.model.validation.IValidator;

public class Diagnostician
implements IValidator.SubstitutionLabelProvider,
IValidator {
    protected IValidator.Registry validatorRegistry;

    public Diagnostician(IValidator.Registry validatorRegistry) {
        this.validatorRegistry = validatorRegistry;
    }

    @Override
    public String getObjectLabel(IResource object) {
        return ModelUtil.getLabel(object);
    }

    @Override
    public String getPropertyLabel(IProperty property) {
        return ModelUtil.getLabel(property);
    }

    @Override
    public String getValueLabel(Object value) {
        return ModelUtil.getLabel(value);
    }

    public Map<Object, Object> createDefaultContext() {
        HashMap<Object, Object> context = new HashMap<Object, Object>();
        context.put(IValidator.SubstitutionLabelProvider.class, this);
        context.put(IValidator.class, this);
        return context;
    }

    public BasicDiagnostic createDefaultDiagnostic(IResource object) {
        return new BasicDiagnostic("net.enilink.komma.model", 0, ModelPlugin.getDefault().getString("DiagnosticRoot_diagnostic", new Object[]{this.getObjectLabel(object)}), new Object[]{object});
    }

    public BasicDiagnostic createDefaultDiagnostic(IReference datatype, Object value) {
        return new BasicDiagnostic("net.enilink.komma.model", 0, ModelPlugin.getDefault().getString("DiagnosticRoot_diagnostic", new Object[]{this.getValueLabel(value)}), new Object[]{value, datatype});
    }

    public Diagnostic validate(IObject object) {
        BasicDiagnostic diagnostics = this.createDefaultDiagnostic(object);
        this.validate(object, (DiagnosticChain)diagnostics, this.createDefaultContext());
        return diagnostics;
    }

    public Diagnostic validate(IResource object, Map<?, ?> contextEntries) {
        BasicDiagnostic diagnostics = this.createDefaultDiagnostic(object);
        Map<Object, Object> context = this.createDefaultContext();
        context.putAll(contextEntries);
        this.validate(object, (DiagnosticChain)diagnostics, context);
        return diagnostics;
    }

    @Override
    public boolean validate(IResource object, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(object.getDirectNamedClasses().toList(), object, diagnostics, context);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean validate(Collection<? extends IClass> classes, IResource object, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        HashSet<IClass> seenClasses = new HashSet<IClass>();
        LinkedList<? extends IClass> classesQueue = new LinkedList<IClass>(classes);
        if (classes.isEmpty()) return true;
        IClass clazz = (IClass)classesQueue.remove();
        seenClasses.add(clazz);
        Object validator = this.validatorRegistry.get(clazz.getURI().trimFragment());
        if (validator == null) {
            IExtendedIterator superClasses = clazz.getDirectNamedSuperClasses();
            if (classes.isEmpty() && !superClasses.hasNext()) {
                validator = this.validatorRegistry.get(null);
                return true;
            }
            for (IClass superClass : superClasses) {
                if (seenClasses.contains(superClass)) continue;
                classesQueue.add((IClass)superClass);
            }
        }
        if (!(result = ((IValidator)validator).validate(Arrays.asList(clazz), object, diagnostics, context))) {
            if (diagnostics == null) return result;
        }
        result &= this.doValidateContents(object, diagnostics, context);
        return result;
    }

    protected boolean doValidateContents(IResource object, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Set contents = object.getContents();
        if (!contents.isEmpty()) {
            boolean result;
            Iterator i = contents.iterator();
            IResource child = (IResource)i.next();
            for (result = this.validate(child, diagnostics, context); i.hasNext() && (result || diagnostics != null); result &= this.validate(child, diagnostics, context)) {
                child = (IResource)i.next();
            }
            return result;
        }
        return true;
    }

    @Override
    public Diagnostic validate(IReference datatype, Object value) {
        BasicDiagnostic diagnostics = this.createDefaultDiagnostic(datatype, value);
        this.validate(datatype, value, (DiagnosticChain)diagnostics, this.createDefaultContext());
        return diagnostics;
    }

    @Override
    public boolean validate(IReference datatype, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Object validator = this.validatorRegistry.get(datatype.getURI().trimFragment());
        if (validator == null) {
            validator = this.validatorRegistry.get(null);
        }
        return ((IValidator)validator).validate(datatype, value, diagnostics, context);
    }
}

