/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.komma.dm.internal.change;

import net.enilink.komma.core.URI;
import net.enilink.komma.dm.IDataManager;
import net.enilink.komma.dm.change.IDataChange;
import net.enilink.komma.dm.change.INamespaceChange;

public class NamespaceChange
implements INamespaceChange,
IDataChange {
    private URI newNS;
    private URI oldNS;
    private String prefix;

    public NamespaceChange(String prefix, URI oldNS, URI newNS) {
        this.prefix = prefix;
        this.oldNS = oldNS;
        this.newNS = newNS;
    }

    @Override
    public URI getNewNS() {
        return this.newNS;
    }

    @Override
    public URI getOldNS() {
        return this.oldNS;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public void redo(IDataManager dm) {
        if (this.newNS == null) {
            dm.removeNamespace(this.prefix);
        } else {
            dm.setNamespace(this.prefix, this.newNS);
        }
    }

    public String toString() {
        return "namespace " + (this.newNS == null ? "deleted" : "added") + " [prefix=" + this.prefix + ", oldNS=" + this.oldNS + ", newNS=" + this.newNS + "]";
    }

    @Override
    public void undo(IDataManager dm) {
        if (this.oldNS == null) {
            dm.removeNamespace(this.prefix);
        } else {
            dm.setNamespace(this.prefix, this.oldNS);
        }
    }
}

