/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.platform.core;

import java.util.Hashtable;
import net.enilink.composition.mappers.DefaultRoleMapper;
import net.enilink.komma.model.IModelSet;
import net.enilink.platform.core.ModelSetManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static Logger logger = LoggerFactory.getLogger(DefaultRoleMapper.class);
    private static BundleContext context;
    private ServiceRegistration<?> modelSetReg;

    public static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        Hashtable props = new Hashtable();
        this.modelSetReg = bundleContext.registerService(IModelSet.class.getName(), (Object)new ServiceFactory<IModelSet>(){

            public IModelSet getService(Bundle bundle, ServiceRegistration<IModelSet> registration) {
                try {
                    return ModelSetManager.INSTANCE.getModelSet();
                }
                catch (Exception e) {
                    logger.error("Unable to create model set", (Throwable)e);
                    return null;
                }
            }

            public void ungetService(Bundle bundle, ServiceRegistration<IModelSet> registration, IModelSet service) {
            }
        }, props);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (this.modelSetReg != null) {
            this.modelSetReg.unregister();
            this.modelSetReg = null;
        }
        ModelSetManager.INSTANCE.shutdown();
        context = null;
    }
}

