/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.platform.core;

import com.google.common.collect.ForwardingSet;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Module;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import net.enilink.komma.core.IGraph;
import net.enilink.komma.core.ILiteral;
import net.enilink.komma.core.ILiteralFactory;
import net.enilink.komma.core.IReference;
import net.enilink.komma.core.IStatement;
import net.enilink.komma.core.IValue;
import net.enilink.komma.core.KommaException;
import net.enilink.komma.core.LinkedHashGraph;
import net.enilink.komma.core.LiteralFactory;
import net.enilink.komma.core.URI;
import net.enilink.komma.core.URIs;
import net.enilink.komma.core.visitor.IDataVisitor;
import net.enilink.komma.literals.LiteralConverter;
import net.enilink.komma.model.ModelUtil;
import net.enilink.komma.model.base.ExtensibleURIConverter;
import net.enilink.platform.core.Config;
import net.enilink.vocab.owl.OWL;
import net.enilink.vocab.xmlschema.XMLSCHEMA;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Config.class})
public class ConfigHashGraph
extends LinkedHashGraph
implements Config {
    public static final String LOCATION_PROPERTY = "net.enilink.config";
    public static final String DEFAULT_CONFIG_FILE = "config.ttl";
    private static final Logger log = LoggerFactory.getLogger(ConfigHashGraph.class);
    private static final long serialVersionUID = 1L;
    private final Config emptyConfig = new EmptyConfig();
    private final LiteralConverter literalConverter = (LiteralConverter)Guice.createInjector((Module[])new Module[]{new AbstractModule(){

        protected void configure() {
            this.bind(ILiteralFactory.class).to(LiteralFactory.class);
            this.bind(ClassLoader.class).toInstance((Object)((Object)((Object)this)).getClass().getClassLoader());
        }
    }}).getInstance(LiteralConverter.class);

    public boolean add(IReference subj, IReference pred, Object obj, IReference ... contexts) {
        return super.add(subj, pred, (Object)this.toValue(obj), contexts);
    }

    public boolean contains(IReference subj, IReference pred, Object obj, IReference ... contexts) {
        return super.contains(subj, pred, (Object)this.toValue(obj), contexts);
    }

    protected IGraph emptyGraph() {
        return this.emptyConfig;
    }

    @Override
    public Config filter(IReference subj, IReference pred, Object obj, IReference ... contexts) {
        return new FilteredConfig(subj, pred, obj, contexts);
    }

    private static URI getConfigFromLocation(Location location) {
        if (Platform.isRunning()) {
            java.net.URI path;
            try {
                path = location.getURL().toURI().resolve(DEFAULT_CONFIG_FILE);
            }
            catch (URISyntaxException e) {
                return null;
            }
            if (Files.exists(Paths.get(path), new LinkOption[0])) {
                return URIs.createFileURI((String)Paths.get(path).toAbsolutePath().toString());
            }
        }
        return null;
    }

    @Activate
    public void load() {
        URI configUri = null;
        String configLocation = System.getProperty(LOCATION_PROPERTY);
        if (configLocation != null) {
            try {
                Path configPath = Paths.get(configLocation, new String[0]);
                if (Files.exists(configPath, new LinkOption[0])) {
                    configUri = URIs.createFileURI((String)configPath.toAbsolutePath().toString());
                } else {
                    log.error("Configuration file not found: {}", (Object)configLocation);
                }
            }
            catch (InvalidPathException configPath) {
                // empty catch block
            }
            if (configUri == null) {
                try {
                    configUri = URIs.createURI((String)configLocation);
                }
                catch (IllegalArgumentException configPath) {
                    // empty catch block
                }
                if (configUri.isRelative()) {
                    configUri = null;
                    log.error("URI of configuration file must be absolute: {}", (Object)configLocation);
                }
            }
        }
        if (Platform.isRunning()) {
            if (configUri == null) {
                configUri = ConfigHashGraph.getConfigFromLocation(Platform.getInstanceLocation());
            }
            if (configUri == null) {
                configUri = ConfigHashGraph.getConfigFromLocation(Platform.getInstallLocation());
            }
        }
        final LinkedList<URI> toLoad = new LinkedList<URI>();
        if (configUri != null) {
            toLoad.add(configUri);
        }
        if (toLoad.isEmpty() || "all".equals(System.getProperty("net.enilink.acl.anonymous"))) {
            toLoad.add(URIs.createURI((String)"platform:/plugin/net.enilink.platform.core/config/acl-anonymous-all.ttl"));
        }
        if (!toLoad.isEmpty()) {
            HashSet<URI> seen = new HashSet<URI>();
            ExtensibleURIConverter uriConverter = new ExtensibleURIConverter();
            while (!toLoad.isEmpty()) {
                URI uri = (URI)toLoad.remove();
                if (!seen.add(uri)) continue;
                try {
                    BufferedInputStream in = new BufferedInputStream(uriConverter.createInputStream(uri));
                    Throwable throwable = null;
                    try {
                        ModelUtil.readData((InputStream)in, (String)uri.toString(), (String)((String)uriConverter.contentDescription(uri, null).get("mimeType")), (IDataVisitor)new IDataVisitor<Void>(){

                            public Void visitBegin() {
                                return null;
                            }

                            public Void visitEnd() {
                                return null;
                            }

                            public Void visitStatement(IStatement stmt) {
                                URI imported;
                                ConfigHashGraph.this.add(stmt);
                                if (OWL.PROPERTY_IMPORTS.equals((Object)stmt.getPredicate()) && stmt.getObject() instanceof IReference && (imported = ((IReference)stmt.getObject()).getURI()) != null) {
                                    toLoad.add(imported);
                                }
                                return null;
                            }
                        });
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (in == null) continue;
                        if (throwable != null) {
                            try {
                                ((InputStream)in).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ((InputStream)in).close();
                    }
                }
                catch (Exception e) {
                    log.error("Unable to read config file", (Throwable)e);
                }
            }
        }
    }

    @Override
    public Object objectInstance() throws KommaException {
        return this.toInstance(super.objectValue());
    }

    @Override
    public Set<Object> objectInstances() {
        return this.objectInstances(null, null, new IReference[0]);
    }

    Set<Object> objectInstances(IReference subj, IReference pred, IReference ... contexts) {
        final Set objects = super.objects();
        return new ForwardingSet<Object>(){

            protected Set<Object> delegate() {
                return objects;
            }

            public Iterator<Object> iterator() {
                final Iterator base = super.iterator();
                return new Iterator<Object>(){

                    @Override
                    public boolean hasNext() {
                        return base.hasNext();
                    }

                    @Override
                    public Object next() {
                        return ConfigHashGraph.this.toInstance(base.next());
                    }

                    @Override
                    public void remove() {
                        base.remove();
                    }
                };
            }
        };
    }

    public boolean remove(IReference subj, IReference pred, Object obj, IReference ... contexts) {
        return super.remove(subj, pred, (Object)this.toValue(obj), contexts);
    }

    private Object toInstance(Object value) {
        if (value instanceof ILiteral) {
            return this.literalConverter.createObject((ILiteral)value);
        }
        return value;
    }

    private IValue toValue(Object instance) {
        if (instance == null) {
            return null;
        }
        if (instance instanceof IValue) {
            return (IValue)instance;
        }
        Class<?> type = instance.getClass();
        if (this.literalConverter.isDatatype(type)) {
            return this.literalConverter.createLiteral(instance, null);
        }
        return this.literalConverter.createLiteral((Object)String.valueOf(instance), XMLSCHEMA.TYPE_STRING);
    }

    class FilteredConfig
    extends LinkedHashGraph.FilteredGraph
    implements Config {
        private static final long serialVersionUID = 1L;

        public FilteredConfig(IReference subj, IReference pred, Object obj, IReference[] contexts) {
            super((LinkedHashGraph)ConfigHashGraph.this, subj, pred, obj, contexts);
        }

        @Override
        public Config filter(IReference s, IReference p, Object o, IReference ... c) {
            return (Config)super.filter(s, p, o, c);
        }

        @Override
        public Object objectInstance() throws KommaException {
            return ConfigHashGraph.this.toInstance(this.objectValue());
        }

        @Override
        public Set<Object> objectInstances() {
            return ConfigHashGraph.this.objectInstances(this.subj, this.pred, this.contexts);
        }
    }

    class EmptyConfig
    extends LinkedHashGraph.EmptyGraph
    implements Config {
        private static final long serialVersionUID = 1L;

        EmptyConfig() {
            super((LinkedHashGraph)ConfigHashGraph.this);
        }

        @Override
        public Config filter(IReference subj, IReference pred, Object obj, IReference ... contexts) {
            return (Config)super.filter(subj, pred, obj, contexts);
        }

        @Override
        public Object objectInstance() throws KommaException {
            return null;
        }

        @Override
        public Set<Object> objectInstances() {
            return Collections.emptySet();
        }
    }
}

