/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.platform.core.blobs;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Hex;

public class FileStore {
    private static final int DIR_LEVELS = 3;
    private static final Pattern KEY_PATTERN = Pattern.compile("(md5|sha1|sha256)-([0-9a-f]{32,})");
    protected Path root;

    public FileStore(Path root) {
        this.root = root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String computeKey(InputStream in, long length) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        try {
            int n = 0;
            byte[] buffer = new byte[8192];
            while (n != -1) {
                n = in.read(buffer);
                if (n <= 0) continue;
                digest.update(buffer, 0, n);
            }
        }
        finally {
            in.close();
        }
        return "sha1" + "-" + Hex.encodeHex((byte[])digest.digest());
    }

    public boolean delete(String key) throws IOException {
        Path path = this.pathForKey(key);
        if (Files.isRegularFile(path, new LinkOption[0]) && Files.deleteIfExists(path)) {
            for (int i = 0; i < 3; ++i) {
                path = path.getParent();
                DirectoryStream<Path> ds = Files.newDirectoryStream(path);
                boolean nonempty = ds.iterator().hasNext();
                ds.close();
                if (nonempty) break;
                Files.delete(path);
            }
            return true;
        }
        return false;
    }

    public boolean exists(String key) {
        return Files.exists(this.pathForKey(key), new LinkOption[0]);
    }

    public Properties getProperties(String key) {
        Path metaPath = this.metaDataPath(this.pathForKey(key));
        Properties properties = new Properties();
        if (Files.exists(metaPath, new LinkOption[0])) {
            try {
                properties.load(new BufferedInputStream(Files.newInputStream(metaPath, new OpenOption[0])));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return properties;
    }

    protected Path metaDataPath(Path path) {
        return path.resolveSibling(path.getFileName().toString() + ".properties");
    }

    public InputStream openStream(String key) throws IOException {
        return new BufferedInputStream(Files.newInputStream(this.pathForKey(key), new OpenOption[0]));
    }

    protected Path pathForKey(String key) {
        Matcher m = KEY_PATTERN.matcher(key);
        if (!m.matches()) {
            throw new IllegalArgumentException("Invalid key: " + key);
        }
        Path dir = this.root.resolve(m.group(1));
        String hashSuffix = m.group(2);
        for (int i = 0; i < 2; ++i) {
            int start = i * 2;
            dir = dir.resolve(hashSuffix.substring(start, start + 2));
        }
        return dir.resolve(key);
    }

    public void setProperties(String key, Properties properties) throws IOException {
        Path metaPath = this.metaDataPath(this.pathForKey(key));
        properties.putAll((Map<?, ?>)this.getProperties(key));
        properties.store(new BufferedOutputStream(Files.newOutputStream(metaPath, new OpenOption[0])), "");
    }

    public long size(String key) throws IOException {
        return Files.size(this.pathForKey(key));
    }

    public String store(byte[] data) throws IOException {
        String key;
        try {
            key = this.computeKey(new ByteArrayInputStream(data), data.length);
        }
        catch (Exception e) {
            throw new IOException("Unable to compute hash for data.", e);
        }
        Path target = this.pathForKey(key);
        if (Files.exists(target, new LinkOption[0])) {
            return key;
        }
        Files.createDirectories(target.getParent(), new FileAttribute[0]);
        try (OutputStream os = Files.newOutputStream(target, new OpenOption[0]);){
            os.write(data, 0, data.length);
        }
        return key;
    }

    public String store(Path file, boolean move) throws IOException {
        String key;
        try {
            key = this.computeKey(Files.newInputStream(file, new OpenOption[0]), Files.size(file));
        }
        catch (Exception e) {
            throw new IOException("Unable to compute hash for file: " + file, e);
        }
        Path target = this.pathForKey(key);
        if (Files.exists(target, new LinkOption[0])) {
            return key;
        }
        Files.createDirectories(target.getParent(), new FileAttribute[0]);
        if (move) {
            try {
                Files.move(file, target, new CopyOption[0]);
                return key;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Files.copy(file, target, new CopyOption[0]);
        return key;
    }
}

