/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.platform.core.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import net.enilink.commons.iterator.IExtendedIterator;
import net.enilink.commons.iterator.IMap;
import net.enilink.commons.iterator.NiceIterator;
import net.enilink.commons.iterator.WrappedIterator;
import net.enilink.komma.core.IBindings;
import net.enilink.komma.core.IReference;
import net.enilink.komma.core.IStatement;
import net.enilink.komma.core.IStatementPattern;
import net.enilink.komma.core.ITransaction;
import net.enilink.komma.core.IValue;
import net.enilink.komma.core.KommaException;
import net.enilink.komma.core.URI;
import net.enilink.komma.dm.IDataManager;
import net.enilink.komma.dm.IDataManagerQuery;
import net.enilink.komma.em.DelegatingDataManager;
import net.enilink.platform.core.security.ISecureModelSet;
import net.enilink.platform.core.security.SecureTransaction;
import net.enilink.platform.core.security.SecurityUtil;
import net.enilink.vocab.acl.ENILINKACL;
import net.enilink.vocab.acl.WEBACL;

public class SecureDataManager
extends DelegatingDataManager {
    static final Set<IReference> removeModes = new HashSet<URI>(Arrays.asList(WEBACL.MODE_WRITE, WEBACL.MODE_CONTROL, ENILINKACL.MODE_WRITERESTRICTED));
    static final Set<IReference> writeModes = new HashSet<URI>(Arrays.asList(WEBACL.MODE_WRITE, WEBACL.MODE_CONTROL, WEBACL.MODE_APPEND, ENILINKACL.MODE_WRITERESTRICTED));
    final IDataManager delegate;
    protected ISecureModelSet modelSet;
    protected SecureTransaction secureTransaction;
    final Map<IReference, SecureOpsInfo> userToOperations = new HashMap<IReference, SecureOpsInfo>();

    public SecureDataManager(ISecureModelSet modelSet, IDataManager delegate) {
        this.modelSet = modelSet;
        this.delegate = delegate;
    }

    public IDataManager add(Iterable<? extends IStatement> statements, IReference ... contexts) {
        SecureOps secureOps = this.assertModes(contexts, contexts, writeModes);
        if (secureOps != null) {
            secureOps.addStatements(statements.iterator());
        } else {
            super.add(statements, contexts);
        }
        if (secureOps != null && !this.secureTransaction.isActive()) {
            secureOps.execute();
        }
        return this;
    }

    public IDataManager add(Iterable<? extends IStatement> statements, IReference[] readContexts, IReference ... addContexts) {
        SecureOps secureOps = this.assertModes(readContexts, addContexts, writeModes);
        if (secureOps != null) {
            secureOps.addStatements(statements.iterator());
        } else {
            super.add(statements, this.assertReadable(readContexts), addContexts);
        }
        if (secureOps != null && !this.secureTransaction.isActive()) {
            secureOps.execute();
        }
        return this;
    }

    protected SecureOps assertModes(IReference[] readContexts, IReference[] contexts, Set<IReference> modes) {
        URI userId = SecurityUtil.getUser();
        boolean restrictedMode = false;
        if (contexts.length == 0) {
            throw new KommaException("Writing to the default context has been denied.");
        }
        for (IReference ctx : contexts) {
            IReference actualMode = this.modelSet.writeModeFor(ctx, (IReference)userId);
            if (actualMode != null && modes.contains(actualMode)) {
                restrictedMode |= ENILINKACL.MODE_WRITERESTRICTED.equals((Object)actualMode);
                continue;
            }
            throw new KommaException("Accessing the context " + ctx + " has been denied.");
        }
        if (restrictedMode) {
            SecureOps secureOps = super.getTransaction().isActive() ? this.secureOps((IReference)SecurityUtil.getUser(), contexts) : new SecureOps(contexts);
            return secureOps;
        }
        return null;
    }

    protected IReference[] assertReadable(IReference ... contexts) {
        URI userId = SecurityUtil.getUser();
        ArrayList<IReference> accessibleCtxs = new ArrayList<IReference>(contexts.length);
        for (IReference ctx : contexts) {
            if (!this.modelSet.isReadableBy(ctx, (IReference)userId)) continue;
            accessibleCtxs.add(ctx);
        }
        if (accessibleCtxs.isEmpty() && contexts.length > 0) {
            throw new KommaException("Reading without a dataset has been denied.");
        }
        return accessibleCtxs.toArray(new IReference[accessibleCtxs.size()]);
    }

    public void close() {
        this.secureTransaction = null;
        super.close();
    }

    public <R> IDataManagerQuery<R> createQuery(String query, String baseURI, boolean includeInferred, IReference ... contexts) {
        return super.createQuery(query, baseURI, includeInferred, this.assertReadable(contexts));
    }

    public IDataManager getDelegate() {
        return this.delegate;
    }

    public ITransaction getTransaction() {
        if (this.secureTransaction == null) {
            this.secureTransaction = new SecureTransaction(super.getTransaction()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void commit() {
                    try {
                        for (SecureOpsInfo opInfo : SecureDataManager.this.userToOperations.values()) {
                            if (opInfo.contextsToOps.isEmpty()) continue;
                            for (Map.Entry<Set<IReference>, SecureOps> entry : opInfo.contextsToOps.entrySet()) {
                                entry.getValue().execute();
                            }
                        }
                    }
                    finally {
                        SecureDataManager.this.userToOperations.clear();
                    }
                    super.commit();
                }

                @Override
                public void rollback() {
                    SecureDataManager.this.userToOperations.clear();
                    super.rollback();
                }
            };
        }
        return this.secureTransaction;
    }

    public boolean hasMatch(IReference subject, IReference predicate, IValue object, boolean includeInferred, IReference ... contexts) {
        return super.hasMatch(subject, predicate, object, includeInferred, this.assertReadable(contexts));
    }

    public IExtendedIterator<IStatement> match(IReference subject, IReference predicate, IValue object, boolean includeInferred, IReference ... contexts) {
        return super.match(subject, predicate, object, includeInferred, this.assertReadable(contexts));
    }

    public IDataManager remove(Iterable<? extends IStatementPattern> statements, IReference ... contexts) {
        SecureOps secureOps = this.assertModes(contexts, contexts, removeModes);
        if (secureOps != null) {
            secureOps.removeStatements(statements.iterator());
        } else {
            super.remove(statements, contexts);
        }
        if (secureOps != null && !this.secureTransaction.isActive()) {
            secureOps.execute();
        }
        return this;
    }

    SecureOps secureOps(IReference user, IReference[] contexts) {
        HashSet<IReference> key;
        SecureOps ops;
        SecureOpsInfo opsInfo = this.userToOperations.get(user);
        if (opsInfo == null) {
            opsInfo = new SecureOpsInfo();
            this.userToOperations.put(user, opsInfo);
        }
        if ((ops = opsInfo.contextsToOps.get(key = new HashSet<IReference>(Arrays.asList(contexts)))) == null) {
            ops = new SecureOps(contexts);
            opsInfo.contextsToOps.put(key, ops);
        }
        return ops;
    }

    static enum WriteMode {
        ADD,
        MODIFY,
        NONE;

    }

    static class SecureOpsInfo {
        Map<Set<IReference>, SecureOps> contextsToOps = new LinkedHashMap<Set<IReference>, SecureOps>();

        SecureOpsInfo() {
        }
    }

    class SecureOps {
        final Map<IReference, Collection<Op>> blockedOps = new HashMap<IReference, Collection<Op>>();
        final Queue<Op> checkedOps = new LinkedList<Op>();
        final IReference[] contexts;
        Op nextOp;
        IExtendedIterator<Op> ops = WrappedIterator.emptyIterator();
        final Map<IReference, WriteMode> resourceModes = new HashMap<IReference, WriteMode>();
        final URI userId = SecurityUtil.getUser();

        SecureOps(IReference[] contexts) {
            this.contexts = contexts;
        }

        Set<IReference> aclModes(IReference resource) {
            IDataManagerQuery aclQuery = SecureDataManager.this.createQuery("prefix acl: <http://www.w3.org/ns/auth/acl#> prefix foaf: <http://xmlns.com/foaf/0.1/> select ?mode where { { ?target acl:owner ?agent . bind (acl:Control as ?mode) } union {{ ?acl acl:accessTo ?target } union { ?target a [ rdfs:subClassOf* ?class ] . ?acl acl:accessToClass ?class } . { ?acl acl:agent [ foaf:member* ?agent ] } union { ?agent a [ rdfs:subClassOf* ?agentClass ] . ?acl acl:agentClass ?agentClass } . ?acl acl:mode ?mode }}", "base:", false, this.contexts);
            aclQuery.setParameter("target", (IValue)resource).setParameter("user", (IValue)this.userId);
            return aclQuery.evaluate().mapWith((IMap)new IMap<Object, IReference>(){

                public IReference map(Object value) {
                    return (IReference)((IBindings)value).get("mode");
                }
            }).toSet();
        }

        void addStatements(Iterator<? extends IStatement> stmts) {
            this.ops = this.ops.andThen((Iterator)WrappedIterator.create(stmts).mapWith((IMap)new IMap<IStatement, Op>(){

                public Op map(IStatement stmt) {
                    return new AddOp(stmt);
                }
            }));
        }

        void block(Op op) {
            IReference s = op.stmt.getSubject();
            Collection<Op> blocked = this.blockedOps.get(s);
            if (blocked == null) {
                blocked = new ArrayList<Op>(2);
                this.blockedOps.put(s, blocked);
            }
            blocked.add(op);
        }

        void execute() {
            this.flushOperations();
            while (!this.blockedOps.isEmpty()) {
                HashSet<IReference> roots = new HashSet<IReference>(this.blockedOps.keySet());
                for (Iterable iterable : this.blockedOps.values()) {
                    for (Op op : iterable) {
                        IStatementPattern stmt = op.stmt;
                        Object o = stmt.getObject();
                        if (!(o instanceof IReference) || stmt.getSubject().equals(o)) continue;
                        roots.remove(o);
                    }
                }
                for (IReference iReference : roots) {
                    WriteMode writeMode = this.writeMode(iReference);
                    if (writeMode == WriteMode.NONE) {
                        writeMode = this.writeModeFromChain(iReference);
                    }
                    if (writeMode != WriteMode.NONE) {
                        this.unlock(iReference, writeMode);
                        continue;
                    }
                    boolean onlyRemove = true;
                    for (Op op : this.blockedOps.remove(iReference)) {
                        if (!op.isAdd()) continue;
                        onlyRemove = false;
                        break;
                    }
                    if (onlyRemove && !SecureDataManager.this.hasMatch(iReference, null, null, false, this.contexts)) continue;
                    throw new KommaException("Changing the resource " + iReference + " is not allowed.");
                }
                this.flushOperations();
            }
            if (!this.blockedOps.isEmpty()) {
                throw new KommaException("Some statements violate the security constraints.");
            }
        }

        void flushOperations() {
            while (this.loadNextOp()) {
                if (this.nextOp.isAdd()) {
                    SecureDataManager.super.add(new StmtIterator(true), this.contexts, this.contexts);
                    continue;
                }
                SecureDataManager.super.remove(new StmtIterator(false), this.contexts);
            }
        }

        boolean loadNextOp() {
            if (this.nextOp == null) {
                WriteMode writeMode = WriteMode.NONE;
                if (!this.checkedOps.isEmpty()) {
                    this.nextOp = this.checkedOps.remove();
                    writeMode = this.nextOp.mode;
                }
                while (this.nextOp == null && this.ops.hasNext()) {
                    Op op = (Op)this.ops.next();
                    boolean isAdd = op.isAdd();
                    IStatementPattern stmt = op.stmt;
                    IReference s = stmt.getSubject();
                    if (!isAdd && (s == null || stmt.getObject() == null && WEBACL.PROPERTY_ACCESSTO.equals((Object)stmt.getPredicate()))) {
                        this.ops = WrappedIterator.create(SecureDataManager.this.match(s, stmt.getPredicate(), (IValue)stmt.getObject(), false, this.contexts).toList().iterator()).mapWith((IMap)new IMap<IStatement, Op>(){

                            public Op map(IStatement stmt) {
                                return new RemoveOp((IStatementPattern)stmt);
                            }
                        }).andThen(this.ops);
                        continue;
                    }
                    writeMode = this.writeMode(op);
                    if (isAdd && writeMode != WriteMode.NONE || writeMode == WriteMode.MODIFY) {
                        this.nextOp = op;
                        continue;
                    }
                    if (s.getURI() == null) {
                        this.block(op);
                        continue;
                    }
                    throw new KommaException("Modification is denied for resource: " + s);
                }
                if (this.nextOp != null) {
                    Object o = this.nextOp.stmt.getObject();
                    if (o == null) {
                        for (IStatementPattern stmt : SecureDataManager.this.match(this.nextOp.stmt.getSubject(), this.nextOp.stmt.getPredicate(), null, false, this.contexts)) {
                            o = stmt.getObject();
                            if (!(o instanceof IReference)) continue;
                            this.unlock((IReference)o, writeMode);
                        }
                    } else if (o instanceof IReference) {
                        this.unlock((IReference)o, writeMode);
                    }
                }
                return this.nextOp != null;
            }
            return true;
        }

        void removeStatements(Iterator<? extends IStatementPattern> stmts) {
            this.ops = this.ops.andThen((Iterator)WrappedIterator.create(stmts).mapWith((IMap)new IMap<IStatementPattern, Op>(){

                public Op map(IStatementPattern stmt) {
                    return new RemoveOp(stmt);
                }
            }));
        }

        void setModes(Collection<IReference> elements, WriteMode mode) {
            for (IReference elem : elements) {
                this.resourceModes.put(elem, mode);
            }
        }

        void unlock(IReference resource, WriteMode writeMode) {
            if (resource.getURI() == null) {
                this.resourceModes.put(resource, writeMode);
                Iterable blocked = this.blockedOps.remove(resource);
                if (blocked != null) {
                    for (Op op : blocked) {
                        if (!op.isAdd() && writeMode != WriteMode.MODIFY) {
                            throw new KommaException("Insufficient access rights for execution a remove operation with the pattern: " + op.stmt);
                        }
                        op.mode = writeMode;
                        this.checkedOps.add(op);
                        Object o = op.stmt.getObject();
                        if (!(o instanceof IReference)) continue;
                        this.resourceModes.put((IReference)o, writeMode);
                    }
                }
            }
        }

        WriteMode writeMode(IReference resource) {
            WriteMode writeMode = this.resourceModes.get(resource);
            if (writeMode != null) {
                return writeMode;
            }
            if (resource.getURI() == null) {
                return WriteMode.NONE;
            }
            if (SecurityUtil.SYSTEM_USER.equals((Object)this.userId)) {
                return WriteMode.MODIFY;
            }
            if (resource.equals(this.userId)) {
                return WriteMode.MODIFY;
            }
            IDataManagerQuery aclQuery = SecureDataManager.this.createQuery("prefix acl: <http://www.w3.org/ns/auth/acl#> prefix foaf: <http://xmlns.com/foaf/0.1/> select ?mode where { { ?target acl:owner ?agent . bind (acl:Control as ?mode) } union {{ ?acl acl:accessTo ?target } union { ?target a [ rdfs:subClassOf* ?class ] . ?acl acl:accessToClass ?class } . { ?acl acl:agent [ foaf:member* ?agent ] } union { ?agent a [ rdfs:subClassOf* ?agentClass ] . ?acl acl:agentClass ?agentClass } . ?acl acl:mode ?mode }}", "base:", false, this.contexts);
            aclQuery.setParameter("target", (IValue)resource).setParameter("user", (IValue)this.userId);
            Set<IReference> modes = this.aclModes(resource);
            writeMode = modes.contains(WEBACL.MODE_CONTROL) || modes.contains(WEBACL.MODE_WRITE) ? WriteMode.MODIFY : (modes.contains(WEBACL.MODE_APPEND) ? WriteMode.MODIFY : WriteMode.NONE);
            this.resourceModes.put(resource, writeMode);
            return writeMode;
        }

        WriteMode writeMode(Op op) {
            IStatementPattern stmt = op.stmt;
            boolean isAdd = op.isAdd();
            IValue o = (IValue)stmt.getObject();
            if (isAdd && o instanceof IReference && ((IReference)o).getURI() == null && !this.resourceModes.containsKey(o) && SecureDataManager.this.hasMatch(null, null, o, false, this.contexts) && this.writeModeFromChain((IReference)o) == WriteMode.NONE) {
                throw new KommaException("Write access to blank node has been denied: " + o);
            }
            IReference p = stmt.getPredicate();
            if (isAdd && WEBACL.PROPERTY_ACCESSTOCLASS.equals((Object)p)) {
                throw new KommaException("Adding access contraints for classes of resources is not allowed.");
            }
            if (WEBACL.PROPERTY_ACCESSTO.equals((Object)p)) {
                if (o instanceof IReference && (this.userId.equals((Object)o) || this.aclModes((IReference)o).contains(WEBACL.MODE_CONTROL))) {
                    if (stmt.getSubject().getURI() == null && !SecureDataManager.this.hasMatch(null, null, (IValue)stmt.getSubject(), false, this.contexts)) {
                        this.resourceModes.put(stmt.getSubject(), WriteMode.MODIFY);
                        return WriteMode.MODIFY;
                    }
                } else {
                    throw new KommaException("Modifying access constraint of the resource " + o + " has been denied.");
                }
            }
            return this.writeMode(stmt.getSubject());
        }

        WriteMode writeModeFromChain(IReference resource) {
            HashSet<IReference> seen = new HashSet<IReference>();
            LinkedList<IReference> chain = new LinkedList<IReference>();
            chain.add(resource);
            seen.add(resource);
            while (!chain.isEmpty()) {
                IReference r = (IReference)chain.remove();
                IExtendedIterator<IStatement> stmts = SecureDataManager.this.match(null, null, (IValue)r, false, this.contexts);
                Throwable throwable = null;
                try {
                    for (IStatement stmt : stmts) {
                        IReference s = stmt.getSubject();
                        boolean isBlank = s.getURI() == null;
                        WriteMode mode = isBlank ? this.resourceModes.get(s) : this.writeMode(s);
                        if (mode == null && isBlank) {
                            if (seen.add(s)) {
                                chain.add(s);
                            }
                            continue;
                        }
                        if (mode == null) {
                            mode = WriteMode.NONE;
                        }
                        this.setModes(seen, mode);
                        WriteMode writeMode = mode;
                        return writeMode;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stmts == null) continue;
                    if (throwable != null) {
                        try {
                            stmts.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    stmts.close();
                }
            }
            this.setModes(seen, WriteMode.NONE);
            return WriteMode.NONE;
        }

        class StmtIterator<S extends IStatementPattern>
        extends NiceIterator<S> {
            final boolean isAdd;
            S stmt;

            StmtIterator(boolean isAdd) {
                this.isAdd = isAdd;
            }

            public boolean hasNext() {
                if (this.stmt == null && SecureOps.this.loadNextOp() && SecureOps.this.nextOp.isAdd() == this.isAdd) {
                    this.stmt = SecureOps.this.nextOp.stmt;
                    SecureOps.this.nextOp = null;
                }
                return this.stmt != null;
            }

            public S next() {
                if (this.stmt == null) {
                    this.noElements("No more statements available.");
                }
                S next = this.stmt;
                this.stmt = null;
                return next;
            }
        }
    }

    static class RemoveOp
    extends Op {
        RemoveOp(IStatementPattern stmt) {
            super(stmt);
        }

        @Override
        boolean isAdd() {
            return false;
        }
    }

    static abstract class Op {
        WriteMode mode = WriteMode.NONE;
        final IStatementPattern stmt;

        Op(IStatementPattern stmt) {
            this.stmt = stmt;
        }

        abstract boolean isAdd();
    }

    static class AddOp
    extends Op {
        AddOp(IStatement stmt) {
            super((IStatementPattern)stmt);
        }

        @Override
        boolean isAdd() {
            return true;
        }
    }
}

