/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.platform.core.security;

import java.lang.annotation.Annotation;
import java.util.List;
import net.enilink.composition.properties.PropertySet;
import net.enilink.composition.properties.annotations.Type;
import net.enilink.composition.properties.komma.KommaPropertySet;
import net.enilink.composition.properties.komma.KommaPropertySetFactory;
import net.enilink.komma.core.IQuery;
import net.enilink.komma.core.IReference;
import net.enilink.komma.core.URI;
import net.enilink.komma.core.URIs;
import net.enilink.komma.model.MODELS;
import net.enilink.platform.core.security.ISecureModelSet;
import net.enilink.platform.core.security.SecurityUtil;
import net.enilink.vocab.acl.WEBACL;

public class SecurePropertySetFactory
extends KommaPropertySetFactory {
    public <E> PropertySet<E> createPropertySet(Object bean, String uri, Class<E> elementType, Annotation ... annotations) {
        if (bean instanceof ISecureModelSet && uri.equals(MODELS.PROPERTY_MODEL.toString())) {
            URI predicate = URIs.createURI((String)uri);
            URI rdfValueType = null;
            for (Annotation annotation : annotations) {
                if (!Type.class.equals(annotation.annotationType())) continue;
                rdfValueType = URIs.createURI((String)((Type)annotation).value());
            }
            KommaPropertySet propertySet = new KommaPropertySet<E>((IReference)bean, (IReference)predicate, elementType, rdfValueType){

                protected IQuery<?> createElementsQuery(String query, String filterPattern, int limit) {
                    URI userId = SecurityUtil.getUser();
                    if (userId != null) {
                        query = "prefix acl: <http://www.w3.org/ns/auth/acl#> SELECT DISTINCT ?o WHERE { ?s ?p ?o . { ?o acl:owner ?agent } union {{ ?acl acl:accessTo ?o } union { ?acl acl:accessToClass ?class . ?o a ?class } . ?acl acl:mode ?mode . { ?acl acl:agent ?agent } union { ?agent a ?agentClass . ?acl acl:agentClass ?agentClass }}}";
                        return (IQuery)((IQuery)super.createElementsQuery(query, filterPattern, limit).setParameter("agent", (Object)userId)).setParameter("mode", (Object)WEBACL.MODE_READ);
                    }
                    return super.createElementsQuery(query, filterPattern, limit);
                }

                protected void setCache(List<E> cache) {
                }
            };
            this.injector.injectMembers((Object)propertySet);
            return propertySet;
        }
        return super.createPropertySet(bean, uri, elementType, annotations);
    }
}

