/*
 * Decompiled with CFR 0.152.
 */
package net.enilink.platform.core.security;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.Collections;
import java.util.Set;
import javax.security.auth.Subject;
import net.enilink.komma.core.IEntityManager;
import net.enilink.komma.core.IQuery;
import net.enilink.komma.core.IReference;
import net.enilink.komma.core.URI;
import net.enilink.komma.core.URIs;
import net.enilink.komma.em.concepts.IResource;
import net.enilink.platform.security.auth.EnilinkPrincipal;
import net.enilink.vocab.foaf.Group;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;

public class SecurityUtil {
    public static final URI UNKNOWN_USER = SecurityUtil.usernameToUri("anonymous");
    public static final URI SYSTEM_USER = SecurityUtil.usernameToUri("system");
    public static final URI USERS_MODEL = URIs.createURI((String)"enilink:model:users");
    public static final URI ADMINISTRATORS_GROUP = URIs.createURI((String)"enilink:group:Administrators");
    public static final Subject SYSTEM_USER_SUBJECT = SecurityUtil.subjectForUser(SYSTEM_USER);
    public static final String QUERY_ACLMODE = "prefix acl: <http://www.w3.org/ns/auth/acl#> prefix foaf: <http://xmlns.com/foaf/0.1/> select ?mode where { { ?target acl:owner ?agent . bind (acl:Control as ?mode) } union {{ ?acl acl:accessTo ?target } union { ?target a [ rdfs:subClassOf* ?class ] . ?acl acl:accessToClass ?class } . { ?acl acl:agent [ foaf:member* ?agent ] } union { ?agent a [ rdfs:subClassOf* ?agentClass ] . ?acl acl:agentClass ?agentClass } . ?acl acl:mode ?mode }}";
    public static final String QUERY_MEMBER = "prefix foaf: <http://xmlns.com/foaf/0.1/> ask where { ?group foaf:member* ?agent }";
    private static final QualifiedName JOB_CONTEXT = new QualifiedName("net.enilink.platform.core.security", "Context");

    public static Subject subjectForUser(URI user) {
        return new Subject(true, Collections.singleton(new EnilinkPrincipal(user)), Collections.emptySet(), Collections.emptySet());
    }

    public static URI usernameToUri(String username) {
        return URIs.createURI((String)("enilink:user:" + username));
    }

    public static URI getUser() {
        Set<EnilinkPrincipal> principals;
        AccessControlContext context;
        Subject s = null;
        Job job = Job.getJobManager().currentJob();
        if (job != null && (context = (AccessControlContext)job.getProperty(JOB_CONTEXT)) != null) {
            s = Subject.getSubject(context);
        }
        if (s == null) {
            s = Subject.getSubject(AccessController.getContext());
        }
        if (s != null && !(principals = s.getPrincipals(EnilinkPrincipal.class)).isEmpty()) {
            return principals.iterator().next().getId();
        }
        return UNKNOWN_USER;
    }

    public static boolean hasType(IEntityManager em, IReference type) {
        return ((IResource)em.find((IReference)SecurityUtil.getUser(), IResource.class, new Class[0])).getRdfTypes().contains(type);
    }

    public static boolean isMemberOf(IEntityManager em, IReference group) {
        URI user = SecurityUtil.getUser();
        return ((Group)em.find(group, Group.class, new Class[0])).getFoafMember().contains(user) || ((IQuery)((IQuery)em.createQuery(QUERY_MEMBER).setParameter("agent", (Object)user)).setParameter("group", (Object)group)).getBooleanResult();
    }

    static {
        Job.getJobManager().addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void scheduled(IJobChangeEvent event) {
                AccessControlContext context = null;
                Job job = Job.getJobManager().currentJob();
                if (job != null) {
                    context = (AccessControlContext)job.getProperty(JOB_CONTEXT);
                }
                if (context == null) {
                    context = AccessController.getContext();
                }
                event.getJob().setProperty(JOB_CONTEXT, (Object)context);
            }
        });
    }
}

