/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.iterator;

import java.util.NoSuchElementException;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;
import org.eclipse.rdf4j.common.iteration.FilterIteration;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Union;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryBindingSet;
import org.eclipse.rdf4j.query.algebra.helpers.TupleExprs;
import org.eclipse.rdf4j.query.impl.EmptyBindingSet;

public class JoinIterator
extends LookAheadIteration<BindingSet, QueryEvaluationException> {
    private final EvaluationStrategy strategy;
    private final Join join;
    private final CloseableIteration<BindingSet, QueryEvaluationException> leftIter;
    private volatile CloseableIteration<BindingSet, QueryEvaluationException> rightIter;

    public JoinIterator(EvaluationStrategy strategy, Join join, BindingSet bindings) throws QueryEvaluationException {
        this.strategy = strategy;
        this.join = join;
        this.leftIter = strategy.evaluate(join.getLeftArg(), bindings);
        this.rightIter = new EmptyIteration<BindingSet, QueryEvaluationException>();
    }

    @Override
    protected BindingSet getNextElement() throws QueryEvaluationException {
        try {
            while (this.rightIter.hasNext() || this.leftIter.hasNext()) {
                if (this.rightIter.hasNext()) {
                    return (BindingSet)this.rightIter.next();
                }
                this.rightIter.close();
                if (!this.leftIter.hasNext()) continue;
                TupleExpr rightArg = this.join.getRightArg();
                if (this.isOutOfScopeForLeftArgBindings(rightArg)) {
                    BindingSet next = (BindingSet)this.leftIter.next();
                    this.rightIter = new MergeIteration(next, new BindingSetFilterIteration(next, this.strategy.evaluate(rightArg, (BindingSet)new EmptyBindingSet())));
                    continue;
                }
                this.rightIter = this.strategy.evaluate(rightArg, (BindingSet)this.leftIter.next());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return null;
    }

    @Override
    protected void handleClose() throws QueryEvaluationException {
        try {
            super.handleClose();
        }
        finally {
            try {
                this.leftIter.close();
            }
            finally {
                this.rightIter.close();
            }
        }
    }

    private boolean isOutOfScopeForLeftArgBindings(TupleExpr expr) {
        if (expr instanceof Union) {
            return true;
        }
        return TupleExprs.isGraphPatternGroup(expr) && !(expr instanceof Filter);
    }

    private class BindingSetFilterIteration
    extends FilterIteration<BindingSet, QueryEvaluationException> {
        private BindingSet bindingSet;

        public BindingSetFilterIteration(BindingSet bindingSet, CloseableIteration<BindingSet, QueryEvaluationException> iteration) {
            super(iteration);
            this.bindingSet = bindingSet;
        }

        @Override
        protected boolean accept(BindingSet toBeFiltered) throws QueryEvaluationException {
            for (Binding b : this.bindingSet) {
                Value v = b.getValue();
                String name = b.getName();
                if (!toBeFiltered.hasBinding(name) || toBeFiltered.getValue(name).equals(v)) continue;
                return false;
            }
            return true;
        }
    }

    private class MergeIteration
    extends LookAheadIteration<BindingSet, QueryEvaluationException> {
        private BindingSet bindingSet;
        private CloseableIteration<BindingSet, QueryEvaluationException> iter;

        public MergeIteration(BindingSet mergeBS, CloseableIteration<BindingSet, QueryEvaluationException> iter) {
            this.bindingSet = mergeBS;
            this.iter = iter;
        }

        @Override
        protected BindingSet getNextElement() throws QueryEvaluationException {
            if (!this.iter.hasNext()) {
                return null;
            }
            BindingSet bs = (BindingSet)this.iter.next();
            QueryBindingSet result = new QueryBindingSet(bs);
            for (Binding b : this.bindingSet) {
                if (result.hasBinding(b.getName())) continue;
                result.addBinding(b);
            }
            return result;
        }

        @Override
        protected void handleClose() {
            super.handleClose();
            this.iter.close();
        }
    }
}

